/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.containers.ChangeBufferingList;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.FileId2ValueMapping;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ValueContainerImpl<Value>
extends UpdatableValueContainer<Value>
implements Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.indexing.impl.ValueContainerImpl");
    private static final Object myNullValue = new Object();
    private Object myInputIdMapping;
    private Object myInputIdMappingValue;
    static final ThreadLocal<IndexId> ourDebugIndexInfo = new ThreadLocal();
    private static final EmptyValueIterator emptyIterator = new EmptyValueIterator();
    private static final ValueContainer.IntIterator EMPTY_ITERATOR = new IntIdsIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return this;
        }
    };
    static final int NUMBER_OF_VALUES_THRESHOLD = 20;
    private static final ValueContainer.IntPredicate EMPTY_PREDICATE = new ValueContainer.IntPredicate(){

        @Override
        public boolean contains(int id) {
            return false;
        }
    };

    ValueContainerImpl() {
    }

    @Override
    public void addValue(int inputId, Value value) {
        Object fileSetObject = this.getFileSetObject(value);
        if (fileSetObject == null) {
            this.attachFileSetForNewValue(value, inputId);
        } else if (fileSetObject instanceof Integer) {
            int existingValue = (Integer)fileSetObject;
            if (existingValue != inputId) {
                ChangeBufferingList list = new ChangeBufferingList();
                list.add(existingValue);
                list.add(inputId);
                this.resetFileSetForValue(value, list);
            }
        } else {
            ((ChangeBufferingList)fileSetObject).add(inputId);
        }
    }

    @Nullable
    private THashMap<Value, Object> asMapping() {
        return this.myInputIdMapping instanceof THashMap ? (THashMap)this.myInputIdMapping : null;
    }

    private Value nullValue() {
        return (Value)myNullValue;
    }

    private void resetFileSetForValue(Value value, @NotNull Object fileSet) {
        THashMap<Value, Object> map;
        if (fileSet == null) {
            ValueContainerImpl.$$$reportNull$$$0(0);
        }
        if (value == null) {
            value = this.nullValue();
        }
        if ((map = this.asMapping()) == null) {
            this.myInputIdMappingValue = fileSet;
        } else {
            map.put(value, fileSet);
        }
    }

    @Override
    public int size() {
        return this.myInputIdMapping != null ? (this.myInputIdMapping instanceof THashMap ? ((THashMap)this.myInputIdMapping).size() : 1) : 0;
    }

    @Override
    public void removeAssociatedValue(int inputId) {
        if (this.myInputIdMapping == null) {
            return;
        }
        SmartList<Object> fileSetObjects = null;
        SmartList valueObjects = null;
        ValueContainer.ValueIterator valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (!valueIterator.getValueAssociationPredicate().contains(inputId)) continue;
            if (fileSetObjects == null) {
                fileSetObjects = new SmartList<Object>();
                valueObjects = new SmartList();
            } else if (DebugAssertions.DEBUG) {
                LOG.error("Expected only one value per-inputId for " + ourDebugIndexInfo.get(), String.valueOf(fileSetObjects.get(0)), String.valueOf(value));
            }
            fileSetObjects.add(valueIterator.getFileSetObject());
            valueObjects.add(value);
        }
        if (fileSetObjects != null) {
            int len = valueObjects.size();
            for (int i = 0; i < len; ++i) {
                this.removeValue(inputId, fileSetObjects.get(i), valueObjects.get(i));
            }
        }
    }

    void removeValue(int inputId, Value value) {
        this.removeValue(inputId, this.getFileSetObject(value), value);
    }

    private void removeValue(int inputId, Object fileSet, Value value) {
        THashMap<Value, Object> mapping;
        if (fileSet == null) {
            return;
        }
        if (fileSet instanceof ChangeBufferingList) {
            ChangeBufferingList changesList = (ChangeBufferingList)fileSet;
            changesList.remove(inputId);
            if (!changesList.isEmpty()) {
                return;
            }
        } else if (fileSet instanceof Integer && (Integer)fileSet != inputId) {
            return;
        }
        if ((mapping = this.asMapping()) == null) {
            this.myInputIdMapping = null;
            this.myInputIdMappingValue = null;
        } else {
            mapping.remove(value);
            if (mapping.size() == 1) {
                Object mappingValue = mapping.keySet().iterator().next();
                this.myInputIdMapping = mappingValue;
                Object inputIdMappingValue = mapping.get(mappingValue);
                this.myInputIdMappingValue = inputIdMappingValue != null ? inputIdMappingValue : new Integer(0);
            }
        }
    }

    @Override
    @NotNull
    public InvertedIndexValueIterator<Value> getValueIterator() {
        if (this.myInputIdMapping != null) {
            final THashMap<Value, Object> mapping = this.asMapping();
            if (mapping == null) {
                InvertedIndexValueIterator invertedIndexValueIterator = new InvertedIndexValueIterator<Value>(){
                    private Value value;
                    {
                        this.value = ValueContainerImpl.this.myInputIdMapping;
                    }

                    @Override
                    @NotNull
                    public ValueContainer.IntIterator getInputIdsIterator() {
                        ValueContainer.IntIterator intIterator = ValueContainerImpl.getIntIteratorOutOfFileSetObject(this.getFileSetObject());
                        if (intIterator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return intIterator;
                    }

                    @Override
                    @NotNull
                    public ValueContainer.IntPredicate getValueAssociationPredicate() {
                        ValueContainer.IntPredicate intPredicate = ValueContainerImpl.getPredicateOutOfFileSetObject(this.getFileSetObject());
                        if (intPredicate == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return intPredicate;
                    }

                    @Override
                    public Object getFileSetObject() {
                        return ValueContainerImpl.this.myInputIdMappingValue;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.value != null;
                    }

                    @Override
                    public Value next() {
                        Object next = this.value;
                        if (next == myNullValue) {
                            next = null;
                        }
                        this.value = null;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/util/indexing/impl/ValueContainerImpl$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getInputIdsIterator";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getValueAssociationPredicate";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
                if (invertedIndexValueIterator == null) {
                    ValueContainerImpl.$$$reportNull$$$0(1);
                }
                return invertedIndexValueIterator;
            }
            InvertedIndexValueIterator invertedIndexValueIterator = new InvertedIndexValueIterator<Value>(){
                private Value current;
                private Object currentValue;
                private final Iterator<Map.Entry<Value, Object>> iterator;
                {
                    this.iterator = mapping.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Value next() {
                    Map.Entry entry = this.iterator.next();
                    Object next = this.current = entry.getKey();
                    this.currentValue = entry.getValue();
                    if (next == myNullValue) {
                        next = null;
                    }
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                @NotNull
                public ValueContainer.IntIterator getInputIdsIterator() {
                    ValueContainer.IntIterator intIterator = ValueContainerImpl.getIntIteratorOutOfFileSetObject(this.getFileSetObject());
                    if (intIterator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return intIterator;
                }

                @Override
                @NotNull
                public ValueContainer.IntPredicate getValueAssociationPredicate() {
                    ValueContainer.IntPredicate intPredicate = ValueContainerImpl.getPredicateOutOfFileSetObject(this.getFileSetObject());
                    if (intPredicate == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return intPredicate;
                }

                @Override
                public Object getFileSetObject() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    return this.currentValue;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/indexing/impl/ValueContainerImpl$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getInputIdsIterator";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getValueAssociationPredicate";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            if (invertedIndexValueIterator == null) {
                ValueContainerImpl.$$$reportNull$$$0(2);
            }
            return invertedIndexValueIterator;
        }
        EmptyValueIterator emptyValueIterator = emptyIterator;
        if (emptyValueIterator == null) {
            ValueContainerImpl.$$$reportNull$$$0(3);
        }
        return emptyValueIterator;
    }

    @NotNull
    private static ValueContainer.IntPredicate getPredicateOutOfFileSetObject(@Nullable Object input) {
        if (input == null) {
            ValueContainer.IntPredicate intPredicate = EMPTY_PREDICATE;
            if (intPredicate == null) {
                ValueContainerImpl.$$$reportNull$$$0(4);
            }
            return intPredicate;
        }
        if (input instanceof Integer) {
            final int singleId = (Integer)input;
            ValueContainer.IntPredicate intPredicate = new ValueContainer.IntPredicate(){

                @Override
                public boolean contains(int id) {
                    return id == singleId;
                }
            };
            if (intPredicate == null) {
                ValueContainerImpl.$$$reportNull$$$0(5);
            }
            return intPredicate;
        }
        ValueContainer.IntPredicate intPredicate = ((ChangeBufferingList)input).intPredicate();
        if (intPredicate == null) {
            ValueContainerImpl.$$$reportNull$$$0(6);
        }
        return intPredicate;
    }

    @NotNull
    private static ValueContainer.IntIterator getIntIteratorOutOfFileSetObject(@Nullable Object input) {
        if (input == null) {
            ValueContainer.IntIterator intIterator = EMPTY_ITERATOR;
            if (intIterator == null) {
                ValueContainerImpl.$$$reportNull$$$0(7);
            }
            return intIterator;
        }
        if (input instanceof Integer) {
            SingleValueIterator singleValueIterator = new SingleValueIterator((Integer)input);
            if (singleValueIterator == null) {
                ValueContainerImpl.$$$reportNull$$$0(8);
            }
            return singleValueIterator;
        }
        IntIdsIterator intIdsIterator = ((ChangeBufferingList)input).intIterator();
        if (intIdsIterator == null) {
            ValueContainerImpl.$$$reportNull$$$0(9);
        }
        return intIdsIterator;
    }

    private Object getFileSetObject(Value value) {
        if (this.myInputIdMapping == null) {
            return null;
        }
        Value Value = value = value != null ? value : this.nullValue();
        if (this.myInputIdMapping == value || this.myInputIdMapping.equals(value)) {
            return this.myInputIdMappingValue;
        }
        THashMap<Value, Object> mapping = this.asMapping();
        return mapping == null ? null : mapping.get(value);
    }

    public ValueContainerImpl<Value> clone() {
        try {
            ValueContainerImpl clone = (ValueContainerImpl)super.clone();
            THashMap<Value, Object> mapping = this.asMapping();
            if (mapping != null) {
                final THashMap cloned = mapping.clone();
                cloned.forEachEntry(new TObjectObjectProcedure<Value, Object>(){

                    public boolean execute(Value key, Object val) {
                        if (val instanceof ChangeBufferingList) {
                            cloned.put(key, ((ChangeBufferingList)val).clone());
                        }
                        return true;
                    }
                });
                clone.myInputIdMapping = cloned;
            } else if (this.myInputIdMappingValue instanceof ChangeBufferingList) {
                clone.myInputIdMappingValue = ((ChangeBufferingList)this.myInputIdMappingValue).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private ChangeBufferingList ensureFileSetCapacityForValue(Value value, int count) {
        if (count <= 1) {
            return null;
        }
        Object fileSetObject = this.getFileSetObject(value);
        if (fileSetObject != null) {
            if (fileSetObject instanceof Integer) {
                ChangeBufferingList list = new ChangeBufferingList(count + 1);
                list.add((Integer)fileSetObject);
                this.resetFileSetForValue(value, list);
                return list;
            }
            if (fileSetObject instanceof ChangeBufferingList) {
                ChangeBufferingList list = (ChangeBufferingList)fileSetObject;
                list.ensureCapacity(count);
                return list;
            }
            return null;
        }
        ChangeBufferingList fileSet = new ChangeBufferingList(count);
        this.attachFileSetForNewValue(value, fileSet);
        return fileSet;
    }

    private void attachFileSetForNewValue(Value value, Object fileSet) {
        Value Value = value = value != null ? value : this.nullValue();
        if (this.myInputIdMapping != null) {
            THashMap mapping = this.asMapping();
            if (mapping == null) {
                Object oldMapping = this.myInputIdMapping;
                mapping = new THashMap(2);
                this.myInputIdMapping = mapping;
                mapping.put(oldMapping, this.myInputIdMappingValue);
                this.myInputIdMappingValue = null;
            }
            mapping.put(value, fileSet);
        } else {
            this.myInputIdMapping = value;
            this.myInputIdMappingValue = fileSet;
        }
    }

    @Override
    public void saveTo(DataOutput out, DataExternalizer<Value> externalizer) throws IOException {
        DataInputOutputUtil.writeINT(out, this.size());
        ValueContainer.ValueIterator valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            externalizer.save(out, value);
            Object fileSetObject = valueIterator.getFileSetObject();
            if (fileSetObject instanceof Integer) {
                DataInputOutputUtil.writeINT(out, (int)((Integer)fileSetObject));
                continue;
            }
            ChangeBufferingList originalInput = (ChangeBufferingList)fileSetObject;
            IntIdsIterator intIterator = originalInput.sortedIntIterator();
            if (DebugAssertions.DEBUG) {
                DebugAssertions.assertTrue(intIterator.hasAscendingOrder());
            }
            if (intIterator.size() == 1) {
                DataInputOutputUtil.writeINT(out, intIterator.next());
                continue;
            }
            DataInputOutputUtil.writeINT(out, -intIterator.size());
            int prev = 0;
            while (intIterator.hasNext()) {
                int fileId = intIterator.next();
                DataInputOutputUtil.writeINT(out, fileId - prev);
                prev = fileId;
            }
        }
    }

    public void readFrom(DataInputStream stream, DataExternalizer<Value> externalizer) throws IOException {
        FileId2ValueMapping<Value> mapping = null;
        while (stream.available() > 0) {
            int valueCount = DataInputOutputUtil.readINT(stream);
            if (valueCount < 0) {
                boolean doCompact;
                int inputId = -valueCount;
                if (mapping == null && this.size() > 20) {
                    mapping = new FileId2ValueMapping<Value>(this);
                }
                if (mapping != null) {
                    doCompact = mapping.removeFileId(inputId);
                } else {
                    this.removeAssociatedValue(inputId);
                    doCompact = true;
                }
                if (!doCompact) continue;
                this.setNeedsCompacting(true);
                continue;
            }
            for (int valueIdx = 0; valueIdx < valueCount; ++valueIdx) {
                Value value = externalizer.read(stream);
                int idCountOrSingleValue = DataInputOutputUtil.readINT(stream);
                if (idCountOrSingleValue > 0) {
                    this.addValue(idCountOrSingleValue, value);
                    if (mapping == null) continue;
                    mapping.associateFileIdToValue(idCountOrSingleValue, value);
                    continue;
                }
                idCountOrSingleValue = -idCountOrSingleValue;
                ChangeBufferingList changeBufferingList = this.ensureFileSetCapacityForValue(value, idCountOrSingleValue);
                int prev = 0;
                for (int i = 0; i < idCountOrSingleValue; ++i) {
                    int id = DataInputOutputUtil.readINT(stream);
                    if (changeBufferingList != null) {
                        changeBufferingList.add(prev + id);
                    } else {
                        this.addValue(prev + id, value);
                    }
                    if (mapping != null) {
                        mapping.associateFileIdToValue(prev + id, value);
                    }
                    prev += id;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/ValueContainerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/ValueContainerImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueIterator";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredicateOutOfFileSetObject";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntIteratorOutOfFileSetObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetFileSetForValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingleValueIterator
    implements IntIdsIterator {
        private final int myValue;
        private boolean myValueRead = false;

        private SingleValueIterator(int value) {
            this.myValue = value;
        }

        @Override
        public boolean hasNext() {
            return !this.myValueRead;
        }

        @Override
        public int next() {
            this.myValueRead = true;
            return this.myValue;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new SingleValueIterator(this.myValue);
        }
    }

    static class EmptyValueIterator<Value>
    extends EmptyIterator<Value>
    implements InvertedIndexValueIterator<Value> {
        EmptyValueIterator() {
        }

        @Override
        @NotNull
        public ValueContainer.IntIterator getInputIdsIterator() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public ValueContainer.IntPredicate getValueAssociationPredicate() {
            throw new IllegalStateException();
        }

        @Override
        public Object getFileSetObject() {
            throw new IllegalStateException();
        }
    }
}

