/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class OptionFlags {
    private static final OptionFlags singleton = new OptionFlags();
    public static boolean ALLOW_INCLUDE = true;
    public static final boolean USE_HECTOR = false;
    public static boolean ADD_NICE_FOR_DOT = false;
    public static final boolean STRICT_SELFMESSAGE_POSITION = true;
    public static final boolean FORCE_TEOZ = false;
    public static final boolean USE_INTERFACE_EYE1 = false;
    public static final boolean USE_INTERFACE_EYE2 = false;
    public static final boolean OMEGA_CROSSING = false;
    private boolean verbose;
    private boolean extractFromMetadata;
    private boolean word;
    private boolean systemExit;
    private boolean gui;
    private boolean quiet;
    private boolean checkDotError;
    private boolean printFonts;
    private boolean useSuggestEngine;
    private boolean encodesprite;
    private boolean dumpHtmlStats;
    private boolean dumpStats;
    private boolean loopStats;
    private boolean overwrite;
    private boolean enableStats = OptionFlags.defaultForStats();
    private String fileSeparator = "_";
    private long timeoutMs = 900000L;
    private File logData;
    private final AtomicBoolean logDataInitized = new AtomicBoolean(false);

    public static void setMaxPixel(int max) {
        ImageBuilder.setMaxPixel(max);
    }

    public void reset() {
        this.reset(false);
        GraphvizUtils.setDotExecutable(null);
    }

    public final void setDotExecutable(String dotExecutable) {
        GraphvizUtils.setDotExecutable(dotExecutable);
    }

    private OptionFlags() {
        this.reset(true);
    }

    private void reset(boolean exit) {
        this.verbose = false;
        this.extractFromMetadata = false;
        this.word = false;
        this.systemExit = exit;
        this.gui = false;
        this.quiet = false;
        this.checkDotError = false;
        this.printFonts = false;
        this.useSuggestEngine = true;
        this.encodesprite = false;
    }

    public boolean useJavaInsteadOfDot() {
        return false;
    }

    public static OptionFlags getInstance() {
        return singleton;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public final boolean isExtractFromMetadata() {
        return this.extractFromMetadata;
    }

    public final void setExtractFromMetadata(boolean extractFromMetadata) {
        this.extractFromMetadata = extractFromMetadata;
    }

    public final boolean isWord() {
        return this.word;
    }

    public final void setWord(boolean word) {
        this.word = word;
    }

    public final boolean isSystemExit() {
        return this.systemExit;
    }

    public final void setSystemExit(boolean systemExit) {
        this.systemExit = systemExit;
    }

    public final boolean isGui() {
        return this.gui;
    }

    public final void setGui(boolean gui) {
        this.gui = gui;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public final boolean isCheckDotError() {
        return this.checkDotError;
    }

    public final void setCheckDotError(boolean checkDotError) {
        this.checkDotError = checkDotError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logData(File file, Diagram system) {
        String warnOrError = system.getWarningOrError();
        if (warnOrError == null) {
            return;
        }
        AtomicBoolean atomicBoolean = this.logDataInitized;
        synchronized (atomicBoolean) {
            if (this.logData == null && !this.logDataInitized.get()) {
                String s = GraphvizUtils.getenvLogData();
                if (s != null) {
                    this.setLogData(new File(s));
                }
                this.logDataInitized.set(true);
            }
            if (this.logData == null) {
                return;
            }
            PrintStream ps = null;
            try {
                ps = new PrintStream(new FileOutputStream(this.logData, true));
                ps.println("Start of " + file.getName());
                ps.println(warnOrError);
                ps.println("End of " + file.getName());
                ps.println();
            }
            catch (FileNotFoundException e) {
                Log.error("Cannot open " + this.logData);
                e.printStackTrace();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogData(File logData) {
        this.logData = logData;
        logData.delete();
        PrintStream ps = null;
        try {
            ps = new PrintStream(new FileOutputStream(logData));
            ps.println();
        }
        catch (FileNotFoundException e) {
            Log.error("Cannot open " + logData);
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public final boolean isPrintFonts() {
        return this.printFonts;
    }

    public final void setPrintFonts(boolean printFonts) {
        this.printFonts = printFonts;
    }

    public final boolean isUseSuggestEngine() {
        return this.useSuggestEngine;
    }

    public final void setUseSuggestEngine(boolean useSuggestEngine) {
        this.useSuggestEngine = useSuggestEngine;
    }

    public final boolean isEncodesprite() {
        return this.encodesprite;
    }

    public final void setEncodesprite(boolean encodesprite) {
        this.encodesprite = encodesprite;
    }

    public final boolean isOverwrite() {
        return this.overwrite;
    }

    public final void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public final String getFileSeparator() {
        return this.fileSeparator;
    }

    public final void setFileSeparator(String fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public final boolean isDumpHtmlStats() {
        return this.dumpHtmlStats;
    }

    public final void setDumpHtmlStats(boolean value) {
        this.dumpHtmlStats = value;
    }

    public final boolean isDumpStats() {
        return this.dumpStats;
    }

    public final void setDumpStats(boolean dumpStats) {
        this.dumpStats = dumpStats;
    }

    public final boolean isLoopStats() {
        return this.loopStats;
    }

    public final void setLoopStats(boolean loopStats) {
        this.loopStats = loopStats;
    }

    private static boolean defaultForStats() {
        return OptionFlags.isTrue(System.getProperty("PLANTUML_STATS")) || OptionFlags.isTrue(System.getenv("PLANTUML_STATS"));
    }

    private static boolean isTrue(String value) {
        return "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    public boolean isEnableStats() {
        return this.enableStats;
    }

    public void setEnableStats(boolean enableStats) {
        this.enableStats = enableStats;
    }

    public final long getTimeoutMs() {
        return this.timeoutMs;
    }

    public final void setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }
}

