/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.preproc.Defines;

public class Pipe {
    private final Option option;
    private final InputStream is;
    private final PrintStream ps;
    private boolean closed = false;
    private final String charset;

    public Pipe(Option option, PrintStream ps, InputStream is, String charset) {
        this.option = option;
        this.is = is;
        this.ps = ps;
        this.charset = charset;
    }

    public boolean managePipe() throws IOException {
        boolean error = false;
        boolean noStdErr = this.option.isPipeNoStdErr();
        do {
            String source;
            if ((source = this.readOneDiagram()) == null) {
                this.ps.flush();
                return error;
            }
            SourceStringReader sourceStringReader = new SourceStringReader(Defines.createEmpty(), source, this.option.getConfig());
            if (this.option.isComputeurl()) {
                for (BlockUml s : sourceStringReader.getBlocks()) {
                    this.ps.println(s.getEncodedUrl());
                }
            } else if (this.option.isSyntax()) {
                Diagram system = sourceStringReader.getBlocks().get(0).getDiagram();
                if (system instanceof UmlDiagram) {
                    this.ps.println(((UmlDiagram)system).getUmlDiagramType().name());
                    this.ps.println(system.getDescription());
                } else if (system instanceof PSystemError) {
                    error = true;
                    this.printErrorText(this.ps, (PSystemError)system);
                } else {
                    this.ps.println("OTHER");
                    this.ps.println(system.getDescription());
                }
            } else if (this.option.isPipeMap()) {
                String result = sourceStringReader.getCMapData(0, this.option.getFileFormatOption());
                this.ps.println(result);
            } else {
                OutputStream os = noStdErr ? new ByteArrayOutputStream() : this.ps;
                DiagramDescription result = sourceStringReader.outputImage(os, this.option.getImageIndex(), this.option.getFileFormatOption());
                if (result != null && "(error)".equalsIgnoreCase(result.getDescription())) {
                    error = true;
                    this.manageErrors(noStdErr ? this.ps : System.err, sourceStringReader);
                } else if (noStdErr) {
                    OutputStream baos = os;
                    ((ByteArrayOutputStream)baos).close();
                    this.ps.write(((ByteArrayOutputStream)baos).toByteArray());
                }
                if (this.option.getPipeDelimitor() != null) {
                    this.ps.println(this.option.getPipeDelimitor());
                }
            }
            this.ps.flush();
        } while (!this.closed);
        return error;
    }

    private void manageErrors(PrintStream output, SourceStringReader sourceStringReader) {
        this.printErrorText(output, (PSystemError)sourceStringReader.getBlocks().get(0).getDiagram());
    }

    private void printErrorText(PrintStream output, PSystemError sys) {
        output.println("ERROR");
        output.println(sys.getHigherErrorPosition2().getPosition());
        for (ErrorUml er : sys.getErrorsUml()) {
            output.println(er.getError());
        }
        output.flush();
    }

    private boolean isFinished(String s) {
        return s == null || s.startsWith("@end");
    }

    private String readOneDiagram() throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        do {
            if ((s = this.readOneLine()) == null) {
                this.closed = true;
                continue;
            }
            sb.append(s);
            sb.append("\n");
        } while (!this.isFinished(s));
        if (sb.length() == 0) {
            return null;
        }
        String source = sb.toString();
        if (!source.startsWith("@start")) {
            source = "@startuml\n" + source + "\n@enduml";
        }
        return source;
    }

    private String readOneLine() throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            if ((read = this.is.read()) == -1) {
                if (baos.size() == 0) {
                    return null;
                }
                break;
            }
            if (read == 13 || read == 10) continue;
            baos.write(read);
        } while (read != 10);
        if (this.charset == null) {
            return new String(baos.toByteArray());
        }
        return new String(baos.toByteArray(), this.charset);
    }
}

