/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileImageData;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.GeneratedImageImpl;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;

public class SourceFileReader2
implements ISourceFileReader {
    private final File file;
    private final File outputFile;
    private final BlockUmlBuilder builder;
    private FileFormatOption fileFormatOption;

    public SourceFileReader2(Defines defines, File file, File outputFile, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        this.outputFile = outputFile;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        this.builder = new BlockUmlBuilder(config, charset, defines, this.getReader(charset), file.getAbsoluteFile().getParentFile(), file.getAbsolutePath());
    }

    @Override
    public boolean hasError() {
        for (BlockUml b : this.builder.getBlockUmls()) {
            if (!(b.getDiagram() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GeneratedImage> getGeneratedImages() throws IOException {
        Log.info("Reading file: " + this.file);
        ArrayList<GeneratedImageImpl> result = new ArrayList<GeneratedImageImpl>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            SuggestedFile suggested = SuggestedFile.fromOutputFile(this.outputFile, this.fileFormatOption.getFileFormat());
            Diagram system = blockUml.getDiagram();
            OptionFlags.getInstance().logData(this.file, system);
            for (FileImageData fdata : PSystemUtils.exportDiagrams(system, suggested, this.fileFormatOption)) {
                String desc = "[" + this.file.getName() + "] " + system.getDescription();
                GeneratedImageImpl generatedImage = new GeneratedImageImpl(fdata.getFile(), desc, blockUml);
                result.add(generatedImage);
            }
        }
        Log.info("Number of image(s): " + result.size());
        return Collections.unmodifiableList(result);
    }

    private Reader getReader(String charset) throws FileNotFoundException, UnsupportedEncodingException {
        if (charset == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(this.file));
        }
        Log.info("Using charset " + charset);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), charset);
    }

    @Override
    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public final Set<FileWithSuffix> getIncludedFiles2() {
        return this.builder.getIncludedFiles();
    }

    @Override
    public List<BlockUml> getBlocks() {
        return this.builder.getBlockUmls();
    }
}

