/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.StripeStyle;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.utils.CharHidder;

public class CreoleStripeSimpleParser {
    private final String line;
    private final StripeStyle style;
    private final CreoleMode modeSimpleLine;
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;

    public CreoleStripeSimpleParser(String line, CreoleContext creoleContext, FontConfiguration fontConfiguration, ISkinSimple skinParam, CreoleMode modeSimpleLine) {
        Pattern2 p2;
        Matcher2 m2;
        Pattern2 p1;
        Matcher2 m1;
        if (line.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(line);
        }
        this.fontConfiguration = fontConfiguration;
        this.modeSimpleLine = modeSimpleLine;
        this.skinParam = skinParam;
        if (skinParam == null) {
            throw new IllegalArgumentException();
        }
        Pattern2 p4 = MyPattern.cmpile("^--([^-]*)--$");
        Matcher2 m4 = p4.matcher(line);
        if (m4.find()) {
            this.line = m4.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '-');
            return;
        }
        Pattern2 p5 = MyPattern.cmpile("^==([^=]*)==$");
        Matcher2 m5 = p5.matcher(line);
        if (m5.find()) {
            this.line = m5.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Pattern2 p5b = MyPattern.cmpile("^===*==$");
        Matcher2 m5b = p5b.matcher(line);
        if (m5b.find()) {
            this.line = "";
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Pattern2 p7 = MyPattern.cmpile("^\\.\\.([^\\.]*)\\.\\.$");
        Matcher2 m7 = p7.matcher(line);
        if (m7.find()) {
            this.line = m7.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '.');
            return;
        }
        if (modeSimpleLine == CreoleMode.FULL && (m1 = (p1 = MyPattern.cmpile("^(\\*+)([^*]+(?:[^*]|\\*\\*[^*]+\\*\\*)*)$")).matcher(line)).find()) {
            this.line = StringUtils.trin(m1.group(2));
            int order = m1.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITHOUT_NUMBER, order, '\u0000');
            return;
        }
        if (modeSimpleLine == CreoleMode.FULL && (m2 = (p2 = MyPattern.cmpile("^(#+)(.+)$")).matcher(CharHidder.hide(line))).find()) {
            this.line = StringUtils.trin(CharHidder.unhide(m2.group(2)));
            int order = CharHidder.unhide(m2.group(1)).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITH_NUMBER, order, '\u0000');
            return;
        }
        Pattern2 p3 = MyPattern.cmpile("^(=+)(.+)$");
        Matcher2 m3 = p3.matcher(line);
        if (m3.find()) {
            this.line = StringUtils.trin(m3.group(2));
            int order = m3.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.HEADING, order, '\u0000');
            return;
        }
        this.line = line;
        this.style = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');
    }

    public Stripe createStripe(CreoleContext context) {
        StripeSimple result = new StripeSimple(this.fontConfiguration, this.style, context, this.skinParam, this.modeSimpleLine);
        result.analyzeAndAdd(this.line);
        return result;
    }
}

