/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.preproc.DefineVariable;
import net.sourceforge.plantuml.preproc.Variables;

public class DefineSignature {
    private final String key;
    private final String fctName;
    private final Variables vars = new Variables();

    public DefineSignature(String key) {
        this.key = key;
        StringTokenizer st = new StringTokenizer(key, "(),");
        this.fctName = st.nextToken().trim();
        while (st.hasMoreTokens()) {
            String var1 = st.nextToken().trim();
            this.vars.add(new DefineVariable(var1));
        }
    }

    public String toString() {
        return this.key + "/" + this.fctName + "/" + this.vars;
    }

    public boolean isMethod() {
        return this.key.contains("(");
    }

    public String getKey() {
        return this.key;
    }

    public List<Variables> getVariationVariables() {
        ArrayList<Variables> result = new ArrayList<Variables>();
        int count = this.vars.countDefaultValue();
        for (int i = 0; i <= count; ++i) {
            result.add(this.vars.removeSomeDefaultValues(i));
        }
        return Collections.unmodifiableList(result);
    }

    public String getFonctionName() {
        return this.fctName;
    }
}

