/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.preproc.ReadLine;

class ReadLineInsertable
implements ReadLine {
    private final ReadLine source;
    private final List<CharSequence2> inserted = new LinkedList<CharSequence2>();

    public ReadLineInsertable(ReadLine source) {
        this.source = source;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        if (this.inserted.size() > 0) {
            Iterator<CharSequence2> it = this.inserted.iterator();
            CharSequence2 result = it.next();
            it.remove();
            return result;
        }
        return this.source.readLine();
    }

    public void insert(List<? extends CharSequence> data, LineLocation location) {
        for (CharSequence charSequence : data) {
            this.insert(charSequence, location);
        }
    }

    public void insert(CharSequence s, LineLocation location) {
        this.inserted.add(new CharSequence2Impl(s, location));
    }
}

