/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.DayOfWeek;
import net.sourceforge.plantuml.project3.Month;

public class DayAsDate
implements Complement {
    private final int year;
    private final int dayOfMonth;
    private final Month month;

    public static DayAsDate create(int year, String month, int dayOfMonth) {
        return new DayAsDate(year, Month.fromString(month), dayOfMonth);
    }

    public static DayAsDate create(int year, int month, int dayOfMonth) {
        return new DayAsDate(year, Month.values()[month - 1], dayOfMonth);
    }

    private DayAsDate(int year, Month month, int dayOfMonth) {
        this.year = year;
        this.dayOfMonth = dayOfMonth;
        this.month = month;
    }

    public String toString() {
        return "" + this.year + "/" + (Object)((Object)this.month) + "/" + this.dayOfMonth;
    }

    public final int getDayOfMonth() {
        return this.dayOfMonth;
    }

    private int daysPerMonth() {
        return this.month.getDaysPerMonth(this.year);
    }

    public DayAsDate next() {
        int newDayOfMonth = this.dayOfMonth + 1;
        if (newDayOfMonth <= this.daysPerMonth()) {
            return new DayAsDate(this.year, this.month, newDayOfMonth);
        }
        assert (newDayOfMonth > this.daysPerMonth());
        newDayOfMonth = 1;
        Month newMonth = this.month.next();
        int newYear = newMonth == Month.JANUARY ? this.year + 1 : this.year;
        return new DayAsDate(newYear, newMonth, newDayOfMonth);
    }

    public Month getMonth() {
        return this.month;
    }

    public DayOfWeek getDayOfWeek() {
        int q = this.dayOfMonth;
        int m = this.month.m();
        int y = m >= 13 ? this.year - 1 : this.year;
        int k = y % 100;
        int j = y / 100;
        int h = (q + 13 * (m + 1) / 5 + k + k / 4 + j / 4 + 5 * j) % 7;
        return DayOfWeek.fromH(h);
    }
}

