/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageEmptyPackage
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final HtmlColor specificBackColor;
    private final ISkinParam skinParam;
    private final Stereotype stereotype;
    private final TextBlock stereoBlock;
    private final Url url;

    public EntityImageEmptyPackage(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        this.skinParam = skinParam;
        this.specificBackColor = entity.getColors(skinParam).getColor(ColorType.BACK);
        this.stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE, this.stereotype), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
        this.stereoBlock = this.stereotype == null || this.stereotype.getLabel(false) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.withMargin(Display.create(this.stereotype.getLabels(skinParam.useGuillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE_STEREOTYPE, this.stereotype), HorizontalAlignment.CENTER, skinParam), 1.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        Dimension2D dim = TextBlockUtils.mergeTB(this.desc, this.stereoBlock, HorizontalAlignment.LEFT).calculateDimension(stringBounder);
        dim = Dimension2DDouble.atLeast(dim, 0.0, 2.0 * dimDesc.getHeight());
        return Dimension2DDouble.delta(dim, 20.0, 20.0);
    }

    private UStroke getStroke() {
        UStroke stroke = this.getSkinParam().getThickness(LineParam.packageBorder, this.getStereo());
        if (stroke == null) {
            stroke = new UStroke(2.0);
        }
        return stroke;
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        HtmlColor back = Cluster.getBackColor(this.specificBackColor, this.skinParam, this.stereotype);
        double roundCorner = 0.0;
        ClusterDecoration decoration = new ClusterDecoration(this.getSkinParam().getPackageStyle(), null, this.desc, this.stereoBlock, 0.0, 0.0, widthTotal, heightTotal, this.getStroke());
        decoration.drawU(ug, back, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.packageBorder, this.getStereo()), this.getSkinParam().shadowing(), 0.0);
        if (this.url != null) {
            ug.closeAction();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

