/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.PlacementStrategy;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ULayoutGroup {
    private final PlacementStrategy placementStrategy;

    public ULayoutGroup(PlacementStrategy placementStrategy) {
        this.placementStrategy = placementStrategy;
    }

    public void drawU(UGraphic ug, double width, double height) {
        for (Map.Entry<TextBlock, Point2D> ent : this.placementStrategy.getPositions(width, height).entrySet()) {
            TextBlock block2 = ent.getKey();
            Point2D pos = ent.getValue();
            block2.drawU(ug.apply(new UTranslate(pos)));
        }
    }

    public void add(TextBlock block2) {
        this.placementStrategy.add(block2);
    }

    public Rectangle2D getInnerPosition(String member, double width, double height, StringBounder stringBounder) {
        Set<Map.Entry<TextBlock, Point2D>> all = this.placementStrategy.getPositions(width, height).entrySet();
        Rectangle2D result = this.tryOne(all, member, stringBounder, InnerStrategy.STRICT);
        if (result == null) {
            result = this.tryOne(all, member, stringBounder, InnerStrategy.LAZZY);
        }
        return result;
    }

    private Rectangle2D tryOne(Set<Map.Entry<TextBlock, Point2D>> all, String member, StringBounder stringBounder, InnerStrategy mode) {
        for (Map.Entry<TextBlock, Point2D> ent : all) {
            TextBlock block2 = ent.getKey();
            Rectangle2D result = block2.getInnerPosition(member, stringBounder, mode);
            if (result == null) continue;
            UTranslate translate = new UTranslate(ent.getValue());
            return translate.apply(result);
        }
        return null;
    }
}

