/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import smetana.core.CFunction;
import smetana.core.JUtils;
import smetana.core.UnsupportedC;
import smetana.core.amiga.Area;

public class CFunctionImpl
extends UnsupportedC
implements CFunction,
Area {
    private final Class codingClass;
    private final String name;
    private final Method method;

    public static CFunctionImpl create(Class codingClass, String name) {
        return new CFunctionImpl(codingClass, name);
    }

    private CFunctionImpl(Class codingClass, String name) {
        this.codingClass = codingClass;
        this.name = name;
        for (Method m : codingClass.getMethods()) {
            if (!m.getName().equals(name)) continue;
            this.method = m;
            return;
        }
        JUtils.LOG("CANNOT FIND METHOD " + name + " IN " + codingClass);
        throw new IllegalStateException("codingClass=" + codingClass + " name=" + name);
    }

    public String toString() {
        return this.codingClass.getName() + "::" + this.name;
    }

    @Override
    public Object exe(Object ... args) {
        JUtils.LOG("-------");
        for (Object arg : args) {
            JUtils.LOG("arg=" + arg);
        }
        JUtils.LOG("method=" + this.method);
        try {
            return this.method.invoke(null, args);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(this.toString());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(this.toString());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(this.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void memcopyFrom(Area source) {
        throw new UnsupportedOperationException();
    }
}

