/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

public abstract class JpsNamedElementReferenceBase<S extends JpsNamedElement, T extends JpsNamedElement, Self extends JpsNamedElementReferenceBase<S, T, Self>>
extends JpsCompositeElementBase<Self>
implements JpsElementReference<T> {
    private static final JpsElementChildRole<JpsElementReference<? extends JpsCompositeElement>> PARENT_REFERENCE_ROLE = JpsElementChildRoleBase.create((String)"parent");
    protected final String myElementName;

    protected JpsNamedElementReferenceBase(@NotNull String elementName, @NotNull JpsElementReference<? extends JpsCompositeElement> parentReference) {
        if (elementName == null) {
            JpsNamedElementReferenceBase.$$$reportNull$$$0(0);
        }
        if (parentReference == null) {
            JpsNamedElementReferenceBase.$$$reportNull$$$0(1);
        }
        this.myElementName = elementName;
        this.myContainer.setChild(PARENT_REFERENCE_ROLE, parentReference);
    }

    protected JpsNamedElementReferenceBase(JpsNamedElementReferenceBase<S, T, Self> original) {
        super(original);
        this.myElementName = original.myElementName;
    }

    public T resolve() {
        JpsCompositeElement parent = (JpsCompositeElement)this.getParentReference().resolve();
        if (parent == null) {
            return null;
        }
        JpsElementCollection<S> collection = this.getCollection(parent);
        if (collection == null) {
            return null;
        }
        List elements = collection.getElements();
        for (JpsNamedElement element : elements) {
            T resolved;
            if (!element.getName().equals(this.myElementName) || (resolved = this.resolve(element)) == null) continue;
            return resolved;
        }
        return null;
    }

    @Nullable
    protected abstract JpsElementCollection<? extends S> getCollection(@NotNull JpsCompositeElement var1);

    @Nullable
    protected abstract T resolve(S var1);

    public JpsElementReference<? extends JpsCompositeElement> getParentReference() {
        return (JpsElementReference)this.myContainer.getChild(PARENT_REFERENCE_ROLE);
    }

    public JpsElementReference<T> asExternal(@NotNull JpsModel model) {
        if (model == null) {
            JpsNamedElementReferenceBase.$$$reportNull$$$0(2);
        }
        model.registerExternalReference((JpsElementReference)this);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/model/impl/JpsNamedElementReferenceBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "asExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

