/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeInputFilter
implements InputFilter {
    private static final Logger LOG = Logger.getInstance(CompositeInputFilter.class);
    private final List<InputFilterWrapper> myFilters;
    private final DumbService myDumbService;

    public CompositeInputFilter(@NotNull Project project) {
        if (project == null) {
            CompositeInputFilter.$$$reportNull$$$0(0);
        }
        this.myFilters = ContainerUtilRt.newArrayList();
        this.myDumbService = DumbService.getInstance(project);
    }

    @Override
    @Nullable
    public List<Pair<String, ConsoleViewContentType>> applyFilter(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            CompositeInputFilter.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            CompositeInputFilter.$$$reportNull$$$0(2);
        }
        boolean dumb = this.myDumbService.isDumb();
        for (InputFilterWrapper filter : this.myFilters) {
            if (dumb && !filter.isDumbAware) continue;
            long t0 = System.currentTimeMillis();
            List<Pair<String, ConsoleViewContentType>> result2 = filter.applyFilter(text, contentType);
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 100L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + text + "'''");
            }
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public void addFilter(@NotNull InputFilter filter) {
        if (filter == null) {
            CompositeInputFilter.$$$reportNull$$$0(3);
        }
        InputFilterWrapper wrapper = new InputFilterWrapper(filter);
        this.myFilters.add(wrapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/CompositeInputFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InputFilterWrapper
    implements InputFilter {
        @NotNull
        private final InputFilter myOriginal;
        private boolean isBroken;
        private final boolean isDumbAware;

        InputFilterWrapper(@NotNull InputFilter original) {
            if (original == null) {
                InputFilterWrapper.$$$reportNull$$$0(0);
            }
            this.isDumbAware = DumbService.isDumbAware(original);
            this.myOriginal = original;
        }

        @Override
        @Nullable
        public List<Pair<String, ConsoleViewContentType>> applyFilter(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
            if (text == null) {
                InputFilterWrapper.$$$reportNull$$$0(1);
            }
            if (contentType == null) {
                InputFilterWrapper.$$$reportNull$$$0(2);
            }
            if (!this.isBroken) {
                try {
                    return this.myOriginal.applyFilter(text, contentType);
                }
                catch (ProcessCanceledException ignored) {
                    ProgressManager.checkCanceled();
                }
                catch (Throwable e) {
                    this.isBroken = true;
                    LOG.error(e);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/CompositeInputFilter$InputFilterWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

