/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class WebBrowserService {
    public static WebBrowserService getInstance() {
        return ServiceManager.getService(WebBrowserService.class);
    }

    @NotNull
    public abstract Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest var1, boolean var2) throws WebBrowserUrlProvider.BrowserException;

    public static boolean isHtmlOrXmlLanguage(@NotNull Language language) {
        if (language == null) {
            WebBrowserService.$$$reportNull$$$0(0);
        }
        return language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE || language == XMLLanguage.INSTANCE;
    }

    public static boolean isHtmlOrXmlFile(@NotNull PsiFile psiFile) {
        Language baseLanguage;
        if (psiFile == null) {
            WebBrowserService.$$$reportNull$$$0(1);
        }
        if (WebBrowserService.isHtmlOrXmlLanguage(baseLanguage = psiFile.getViewProvider().getBaseLanguage())) {
            return true;
        }
        if (psiFile.getFileType() instanceof LanguageFileType) {
            return WebBrowserService.isHtmlOrXmlLanguage(((LanguageFileType)psiFile.getFileType()).getLanguage());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/browsers/WebBrowserService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isHtmlOrXmlLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isHtmlOrXmlFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

