/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.ModifiableCellAppearanceEx;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeAppearance
implements ModifiableCellAppearanceEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.util.CompositeAppearance");
    private Icon myIcon;
    private final List<TextSection> mySections = new ArrayList<TextSection>();
    private int myInsertionIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            CompositeAppearance.$$$reportNull$$$0(0);
        }
        List<TextSection> list = this.mySections;
        synchronized (list) {
            for (TextSection section : this.mySections) {
                TextAttributes attributes = section.getTextAttributes();
                component.append(section.getText(), SimpleTextAttributes.fromTextAttributes(attributes));
            }
            component.setIcon(this.myIcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customize(@NotNull HtmlListCellRenderer renderer) {
        if (renderer == null) {
            CompositeAppearance.$$$reportNull$$$0(1);
        }
        List<TextSection> list = this.mySections;
        synchronized (list) {
            for (TextSection section : this.mySections) {
                TextAttributes attributes = section.getTextAttributes();
                renderer.append(section.getText(), SimpleTextAttributes.fromTextAttributes(attributes));
            }
            renderer.setIcon(this.myIcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon() {
        List<TextSection> list = this.mySections;
        synchronized (list) {
            return this.myIcon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIcon(@Nullable Icon icon) {
        List<TextSection> list = this.mySections;
        synchronized (list) {
            this.myIcon = icon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getText() {
        List<TextSection> list = this.mySections;
        // MONITORENTER : list
        StringBuilder buffer = new StringBuilder();
        Iterator<TextSection> iterator = this.mySections.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String string = buffer.toString();
                // MONITOREXIT : list
                if (string != null) return string;
                CompositeAppearance.$$$reportNull$$$0(2);
                return string;
            }
            TextSection section = iterator.next();
            buffer.append(section.TEXT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        List<TextSection> list = this.mySections;
        synchronized (list) {
            if (!(obj instanceof CompositeAppearance)) {
                return false;
            }
            CompositeAppearance appearance = (CompositeAppearance)obj;
            if (SwingUtilities.isEventDispatchThread()) {
                return appearance.mySections.equals(this.mySections);
            }
            return new ArrayList<TextSection>(appearance.mySections).equals(new ArrayList<TextSection>(this.mySections));
        }
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSectionAt(int index, @NotNull TextSection section) {
        if (section == null) {
            CompositeAppearance.$$$reportNull$$$0(3);
        }
        List<TextSection> list = this.mySections;
        synchronized (list) {
            this.mySections.add(index, section);
            Iterator<TextSection> iterator = this.mySections.iterator();
            while (iterator.hasNext()) {
                TextSection textSection = iterator.next();
                if (textSection != null) continue;
                LOG.error("index: " + index + " size: " + this.mySections.size());
                iterator.remove();
            }
        }
    }

    public DequeEnd getBeginning() {
        return new DequeBeginning();
    }

    public DequeEnd getEnding() {
        return new DequeEnding();
    }

    public DequeEnd getSuffix() {
        return new DequeSuffix();
    }

    public static CompositeAppearance textComment(String text, String comment) {
        DequeEnd ending = new CompositeAppearance().getEnding();
        ending.addText(text);
        ending.addComment(comment);
        return ending.getAppearance();
    }

    public static CompositeAppearance single(String text, SimpleTextAttributes textAttributes) {
        CompositeAppearance result2 = new CompositeAppearance();
        result2.getEnding().addText(text, textAttributes);
        return result2;
    }

    public static CompositeAppearance single(String text) {
        return CompositeAppearance.single(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public static CompositeAppearance invalid(String absolutePath) {
        CompositeAppearance appearance = new CompositeAppearance();
        appearance.setIcon(PlatformIcons.INVALID_ENTRY_ICON);
        appearance.getEnding().addText(absolutePath, SimpleTextAttributes.ERROR_ATTRIBUTES);
        return appearance;
    }

    public Iterator<TextSection> getSectionsIterator() {
        return this.mySections.iterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/util/CompositeAppearance";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/util/CompositeAppearance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSectionAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DequeSuffix
    extends DequeEnd {
        private DequeSuffix() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSection(TextSection section) {
            List list = CompositeAppearance.this.mySections;
            synchronized (list) {
                CompositeAppearance.this.addSectionAt(CompositeAppearance.this.mySections.size(), section);
            }
        }
    }

    private class DequeEnding
    extends DequeEnd {
        private DequeEnding() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSection(TextSection section) {
            List list = CompositeAppearance.this.mySections;
            synchronized (list) {
                CompositeAppearance.this.addSectionAt(CompositeAppearance.this.myInsertionIndex, section);
                CompositeAppearance.this.myInsertionIndex++;
            }
        }
    }

    private class DequeBeginning
    extends DequeEnd {
        private DequeBeginning() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSection(TextSection section) {
            List list = CompositeAppearance.this.mySections;
            synchronized (list) {
                CompositeAppearance.this.addSectionAt(0, section);
                CompositeAppearance.this.myInsertionIndex++;
            }
        }
    }

    public abstract class DequeEnd {
        public void addText(String text, SimpleTextAttributes textAttributes) {
            this.addText(text, textAttributes.toTextAttributes());
        }

        public void addText(String text) {
            this.addText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        public abstract void addSection(TextSection var1);

        public void addText(String text, TextAttributes attributes) {
            this.addSection(new TextSection(text, attributes));
        }

        public void addSurrounded(String text, String prefix, String suffix, SimpleTextAttributes textAttributes) {
            if (text != null && !text.trim().isEmpty()) {
                this.addText(prefix + text + suffix, textAttributes);
            }
        }

        public CompositeAppearance getAppearance() {
            return CompositeAppearance.this;
        }

        public void addComment(String comment, SimpleTextAttributes commentAttributes) {
            this.addSurrounded(comment, " (", ")", commentAttributes);
        }

        public void addComment(String comment) {
            this.addComment(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static class TextSection {
        private static final TextAttributes DEFAULT_TEXT_ATTRIBUTES = new TextAttributes(null, null, null, null, 0);
        private static final String DEFAULT_TEXT = "";
        private final String TEXT;
        private final TextAttributes ATTRIBUTES;

        public TextSection(String text, TextAttributes attributes) {
            this.ATTRIBUTES = attributes == null ? DEFAULT_TEXT_ATTRIBUTES : attributes;
            this.TEXT = text == null ? DEFAULT_TEXT : text;
        }

        public String getText() {
            return this.TEXT;
        }

        public TextAttributes getTextAttributes() {
            return this.ATTRIBUTES;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TextSection)) {
                return false;
            }
            TextSection section = (TextSection)obj;
            return section.ATTRIBUTES.equals(this.ATTRIBUTES) && section.TEXT.equals(this.TEXT);
        }

        public int hashCode() {
            return this.TEXT.hashCode();
        }
    }
}

