/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ToolWindowEP
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.ToolWindowEP");
    public static final ExtensionPointName<ToolWindowEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.toolWindow");
    @Attribute(value="id")
    public String id;
    @Attribute(value="anchor")
    public String anchor;
    @Attribute(value="icon")
    public String icon;
    @Attribute(value="factoryClass")
    public String factoryClass;
    @Attribute(value="conditionClass")
    public String conditionClass;
    @Attribute(value="secondary")
    public boolean secondary;
    @Attribute(value="canCloseContents")
    public boolean canCloseContents;
    private Class<? extends ToolWindowFactory> myFactoryClass;
    private ToolWindowFactory myFactory;

    public ToolWindowFactory getToolWindowFactory() {
        if (this.myFactory == null) {
            try {
                this.myFactory = (ToolWindowFactory)ToolWindowEP.instantiate(this.getFactoryClass(), (PicoContainer)ApplicationManager.getApplication().getPicoContainer());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return this.myFactory;
    }

    public Class<? extends ToolWindowFactory> getFactoryClass() {
        if (this.myFactoryClass == null) {
            if (this.factoryClass == null) {
                LOG.error((Throwable)new PluginException("No toolwindow factory specified for " + this.id, this.getPluginId()));
                return null;
            }
            try {
                this.myFactoryClass = this.findClass(this.factoryClass);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return this.myFactoryClass;
    }

    @Nullable
    public Condition<Project> getCondition() {
        if (this.conditionClass != null) {
            try {
                return (Condition)this.instantiate(this.conditionClass, ApplicationManager.getApplication().getPicoContainer());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.id;
    }
}

