/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerAuthenticationManager;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitImplBase
implements Git {
    public static final String REMOTE_PROGRESS_PREFIX = "remote: ";
    public static final String[] PROGRESS_INDICATORS = new String[]{"Counting objects:", "Compressing objects:", "Writing objects:", "Receiving objects:", "Resolving deltas:"};
    public static final String[] ERROR_INDICATORS = new String[]{"warning:", "error:", "fatal:", "remote: error", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable", "The file will have its original", "runnerw:"};

    GitImplBase() {
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(0);
        }
        GitCommandResult gitCommandResult = this.run(handler, GitImplBase.getCollectingCollector());
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(1);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<GitLineHandler> handlerConstructor) {
        if (handlerConstructor == null) {
            GitImplBase.$$$reportNull$$$0(2);
        }
        GitCommandResult gitCommandResult = this.run(handlerConstructor, (Computable<OutputCollector>)((Computable)GitImplBase::getCollectingCollector));
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(3);
        }
        return gitCommandResult;
    }

    @NotNull
    private static OutputCollector getCollectingCollector() {
        OutputCollector outputCollector = new OutputCollector(){

            @Override
            public void outputLineReceived(@NotNull String line) {
                if (line == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.addOutputLine(line);
            }

            @Override
            public void errorLineReceived(@NotNull String line) {
                if (line == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!GitImplBase.looksLikeError(line)) {
                    this.addOutputLine(line);
                } else {
                    this.addErrorLine(line);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "git4idea/commands/GitImplBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLineReceived";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLineReceived";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (outputCollector == null) {
            GitImplBase.$$$reportNull$$$0(4);
        }
        return outputCollector;
    }

    @Override
    @NotNull
    public GitCommandResult runCommandWithoutCollectingOutput(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(5);
        }
        GitCommandResult gitCommandResult = this.run(handler, new OutputCollector(){

            @Override
            protected void outputLineReceived(@NotNull String line) {
                if (line == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            protected void errorLineReceived(@NotNull String line) {
                if (line == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.addErrorLine(line);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "git4idea/commands/GitImplBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLineReceived";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLineReceived";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(6);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult run(@NotNull Computable<GitLineHandler> handlerConstructor, @NotNull Computable<OutputCollector> outputCollectorConstructor) {
        OutputCollector outputCollector;
        GitLineHandler handler;
        GitCommandResult result2;
        if (handlerConstructor == null) {
            GitImplBase.$$$reportNull$$$0(7);
        }
        if (outputCollectorConstructor == null) {
            GitImplBase.$$$reportNull$$$0(8);
        }
        int authAttempt = 0;
        while ((result2 = this.run(handler = (GitLineHandler)handlerConstructor.compute(), outputCollector = (OutputCollector)outputCollectorConstructor.compute())).isAuthenticationFailed() && authAttempt++ < 2) {
        }
        GitCommandResult gitCommandResult = result2;
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(9);
        }
        return gitCommandResult;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private GitCommandResult run(@NotNull GitLineHandler handler, @NotNull OutputCollector outputCollector) {
        block21: {
            GitCommandResult gitCommandResult;
            Throwable throwable;
            GitHandlerAuthenticationManager authenticationManager;
            block19: {
                block20: {
                    Project project;
                    if (handler == null) {
                        GitImplBase.$$$reportNull$$$0(10);
                    }
                    if (outputCollector == null) {
                        GitImplBase.$$$reportNull$$$0(11);
                    }
                    if ((project = handler.project()) == null || !handler.isRemote()) break block21;
                    authenticationManager = this.prepareAuthentication(project, handler);
                    throwable = null;
                    gitCommandResult = GitCommandResult.withAuthentication(GitImplBase.doRun(handler, outputCollector), authenticationManager.isHttpAuthFailed());
                    if (authenticationManager == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        authenticationManager.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                authenticationManager.close();
            }
            GitCommandResult gitCommandResult2 = gitCommandResult;
            if (gitCommandResult2 == null) {
                GitImplBase.$$$reportNull$$$0(12);
            }
            return gitCommandResult2;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (authenticationManager != null) {
                                if (throwable != null) {
                                    try {
                                        authenticationManager.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    authenticationManager.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        GitCommandResult gitCommandResult3 = GitCommandResult.startError("Failed to start Git process " + e.getLocalizedMessage());
                        if (gitCommandResult3 == null) {
                            GitImplBase.$$$reportNull$$$0(13);
                        }
                        return gitCommandResult3;
                    }
                }
            }
        }
        GitCommandResult gitCommandResult = GitImplBase.doRun(handler, outputCollector);
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(14);
        }
        return gitCommandResult;
    }

    @NotNull
    protected GitHandlerAuthenticationManager prepareAuthentication(@NotNull Project project, @NotNull GitLineHandler handler) throws IOException {
        if (project == null) {
            GitImplBase.$$$reportNull$$$0(15);
        }
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(16);
        }
        GitHandlerAuthenticationManager gitHandlerAuthenticationManager = GitHandlerAuthenticationManager.prepare(project, handler);
        if (gitHandlerAuthenticationManager == null) {
            GitImplBase.$$$reportNull$$$0(17);
        }
        return gitHandlerAuthenticationManager;
    }

    @NotNull
    private static GitCommandResult doRun(@NotNull GitLineHandler handler, @NotNull OutputCollector outputCollector) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(18);
        }
        if (outputCollector == null) {
            GitImplBase.$$$reportNull$$$0(19);
        }
        GitVersion version = GitVersion.NULL;
        if (handler.isPreValidateExecutable()) {
            String executablePath = handler.getExecutablePath();
            try {
                version = GitExecutableManager.getInstance().identifyVersion(executablePath);
            }
            catch (Exception e) {
                GitCommandResult gitCommandResult = GitImplBase.handlePreValidationException(handler.project(), e);
                if (gitCommandResult == null) {
                    GitImplBase.$$$reportNull$$$0(20);
                }
                return gitCommandResult;
            }
        }
        GitImplBase.getGitTraceEnvironmentVariables(version).forEach(handler::addCustomEnvironmentVariable);
        GitCommandResultListener resultListener = new GitCommandResultListener(outputCollector);
        handler.addLineListener(resultListener);
        try (AccessToken ignored = GitImplBase.lock(handler);){
            GitImplBase.writeOutputToConsole(handler);
            handler.runInCurrentThread();
        }
        catch (IOException e) {
            GitCommandResult gitCommandResult = GitCommandResult.error("Error processing input stream: " + e.getLocalizedMessage());
            if (gitCommandResult == null) {
                GitImplBase.$$$reportNull$$$0(21);
            }
            return gitCommandResult;
        }
        GitCommandResult gitCommandResult = new GitCommandResult(resultListener.myStartFailed, resultListener.myExitCode, outputCollector.myErrorOutput, outputCollector.myOutput);
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(22);
        }
        return gitCommandResult;
    }

    @NotNull
    public static Map<String, String> getGitTraceEnvironmentVariables(@NotNull GitVersion version) {
        if (version == null) {
            GitImplBase.$$$reportNull$$$0(23);
        }
        HashMap<String, String> environment = new HashMap<String, String>(5);
        environment.put("GIT_TRACE", "0");
        if (GitVersionSpecialty.ENV_GIT_TRACE_PACK_ACCESS_ALLOWED.existsIn(version)) {
            environment.put("GIT_TRACE_PACK_ACCESS", "");
        }
        environment.put("GIT_TRACE_PACKET", "");
        environment.put("GIT_TRACE_PERFORMANCE", "0");
        environment.put("GIT_TRACE_SETUP", "0");
        HashMap<String, String> hashMap = environment;
        if (hashMap == null) {
            GitImplBase.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    @NotNull
    private static GitCommandResult handlePreValidationException(@Nullable Project project, @NotNull Exception e) {
        if (e == null) {
            GitImplBase.$$$reportNull$$$0(25);
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (project != null && progressIndicator != null && !progressIndicator.getModalityState().dominates(ModalityState.NON_MODAL)) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            throw new ProcessCanceledException((Throwable)e);
        }
        GitCommandResult gitCommandResult = GitCommandResult.startError(GitBundle.getString("git.executable.validation.error.start.title") + ": \n" + GitExecutableProblemsNotifier.getPrettyErrorMessage(e));
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(26);
        }
        return gitCommandResult;
    }

    private static void writeOutputToConsole(final @NotNull GitLineHandler handler) {
        Project project;
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(27);
        }
        if ((project = handler.project()) != null && !project.isDefault()) {
            final GitVcsConsoleWriter vcsConsoleWriter = GitVcsConsoleWriter.getInstance(project);
            handler.addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (!handler.isSilent() && !StringUtil.isEmptyOrSpaces((String)line)) {
                        if (outputType == ProcessOutputTypes.STDOUT && !handler.isStdoutSuppressed()) {
                            vcsConsoleWriter.showMessage(line);
                        } else if (outputType == ProcessOutputTypes.STDERR && !handler.isStderrSuppressed() && !GitImplBase.looksLikeProgress(line)) {
                            vcsConsoleWriter.showErrorMessage(line);
                        }
                    }
                }
            });
            if (!handler.isSilent()) {
                vcsConsoleWriter.showCommandLine("[" + GitImplBase.stringifyWorkingDir(project.getBasePath(), handler.getWorkingDirectory()) + "] " + handler.printableCommandLine());
            }
        }
    }

    @NotNull
    private static AccessToken lock(@NotNull GitLineHandler handler) {
        Project project;
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(28);
        }
        if ((project = handler.project()) != null && !project.isDefault() && GitCommand.LockingPolicy.WRITE == handler.getCommand().lockingPolicy()) {
            final ReadWriteLock executionLock = GitVcs.getInstance(project).getCommandLock();
            executionLock.writeLock().lock();
            AccessToken accessToken = new AccessToken(){

                public void finish() {
                    executionLock.writeLock().unlock();
                }
            };
            if (accessToken == null) {
                GitImplBase.$$$reportNull$$$0(29);
            }
            return accessToken;
        }
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        if (accessToken == null) {
            GitImplBase.$$$reportNull$$$0(30);
        }
        return accessToken;
    }

    private static boolean looksLikeProgress(@NotNull String line) {
        if (line == null) {
            GitImplBase.$$$reportNull$$$0(31);
        }
        String trimmed = StringUtil.trimStart((String)line, (String)REMOTE_PROGRESS_PREFIX);
        return ContainerUtil.exists((Object[])PROGRESS_INDICATORS, indicator -> StringUtil.startsWith((CharSequence)trimmed, (CharSequence)indicator));
    }

    private static boolean looksLikeError(@NotNull String text) {
        if (text == null) {
            GitImplBase.$$$reportNull$$$0(32);
        }
        return ContainerUtil.exists((Object[])ERROR_INDICATORS, indicator -> {
            if (text == null) {
                GitImplBase.$$$reportNull$$$0(37);
            }
            return StringUtil.startsWithIgnoreCase((String)text.trim(), (String)indicator);
        });
    }

    @NotNull
    static String stringifyWorkingDir(@Nullable String basePath, @NotNull File workingDir) {
        if (workingDir == null) {
            GitImplBase.$$$reportNull$$$0(33);
        }
        if (basePath != null) {
            String relPath = FileUtil.getRelativePath((String)basePath, (String)FileUtil.toSystemIndependentName((String)workingDir.getPath()), (char)'/');
            if (".".equals(relPath)) {
                String string = workingDir.getName();
                if (string == null) {
                    GitImplBase.$$$reportNull$$$0(34);
                }
                return string;
            }
            if (relPath != null) {
                String string = FileUtil.toSystemDependentName((String)relPath);
                if (string == null) {
                    GitImplBase.$$$reportNull$$$0(35);
                }
                return string;
            }
        }
        String string = workingDir.getPath();
        if (string == null) {
            GitImplBase.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitImplBase";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerConstructor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollectorConstructor";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollector";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitImplBase";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectingCollector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommandWithoutCollectingOutput";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAuthentication";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitTraceEnvironmentVariables";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "handlePreValidationException";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "lock";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runCommandWithoutCollectingOutput";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "prepareAuthentication";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getGitTraceEnvironmentVariables";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "handlePreValidationException";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "writeOutputToConsole";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeProgress";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeError";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "stringifyWorkingDir";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$looksLikeError$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class OutputCollector {
        final List<String> myOutput = new ArrayList<String>();
        final List<String> myErrorOutput = new ArrayList<String>();

        private OutputCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addOutputLine(@NotNull String line) {
            if (line == null) {
                OutputCollector.$$$reportNull$$$0(0);
            }
            List<String> list = this.myOutput;
            synchronized (list) {
                this.myOutput.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addErrorLine(@NotNull String line) {
            if (line == null) {
                OutputCollector.$$$reportNull$$$0(1);
            }
            List<String> list = this.myErrorOutput;
            synchronized (list) {
                this.myErrorOutput.add(line);
            }
        }

        abstract void outputLineReceived(@NotNull String var1);

        abstract void errorLineReceived(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "line";
            objectArray2[1] = "git4idea/commands/GitImplBase$OutputCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOutputLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addErrorLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GitCommandResultListener
    implements GitLineHandlerListener {
        private final OutputCollector myOutputCollector;
        private int myExitCode = 0;
        private boolean myStartFailed = false;

        public GitCommandResultListener(OutputCollector outputCollector) {
            this.myOutputCollector = outputCollector;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOutputCollector.outputLineReceived(line);
            } else if (outputType == ProcessOutputTypes.STDERR) {
                this.myOutputCollector.errorLineReceived(line);
            }
        }

        public void processTerminated(int code) {
            this.myExitCode = code;
        }

        public void startFailed(Throwable t) {
            this.myStartFailed = true;
            this.myOutputCollector.errorLineReceived("Failed to start Git process " + t.getLocalizedMessage());
        }
    }
}

