/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.util.containers.MultiMap;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateSession
implements UpdateSession {
    private final boolean myResult;
    @NotNull
    private final Map<GitRepository, String> mySkippedRoots;

    public GitUpdateSession(boolean result2, @NotNull Map<GitRepository, String> roots) {
        if (roots == null) {
            GitUpdateSession.$$$reportNull$$$0(0);
        }
        this.myResult = result2;
        this.mySkippedRoots = roots;
    }

    @NotNull
    public List<VcsException> getExceptions() {
        List<VcsException> list = Collections.emptyList();
        if (list == null) {
            GitUpdateSession.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void onRefreshFilesCompleted() {
    }

    public boolean isCanceled() {
        return !this.myResult;
    }

    @Nullable
    public String getAdditionalNotificationContent() {
        if (this.mySkippedRoots.isEmpty()) {
            return null;
        }
        if (this.mySkippedRoots.size() == 1) {
            GitRepository repo = this.mySkippedRoots.keySet().iterator().next();
            return DvcsUtil.getShortRepositoryName((Repository)repo) + " was skipped (" + this.mySkippedRoots.get(repo) + ")";
        }
        String prefix = "Skipped " + this.mySkippedRoots.size() + " repositories: <br/>";
        MultiMap<String, GitRepository> grouped = GitUpdateSession.groupByReasons(this.mySkippedRoots);
        if (grouped.keySet().size() == 1) {
            String reason2 = (String)grouped.keySet().iterator().next();
            return prefix + DvcsUtil.getShortNames((Collection)grouped.get((Object)reason2)) + " (" + reason2 + ")";
        }
        return prefix + StringUtil.join((Collection)grouped.keySet(), reason -> DvcsUtil.getShortNames((Collection)grouped.get(reason)) + " (" + reason + ")", (String)"<br/>");
    }

    @NotNull
    private static MultiMap<String, GitRepository> groupByReasons(@NotNull Map<GitRepository, String> skippedRoots) {
        if (skippedRoots == null) {
            GitUpdateSession.$$$reportNull$$$0(2);
        }
        MultiMap result2 = MultiMap.create();
        skippedRoots.forEach((file, s) -> result2.putValue(s, file));
        MultiMap multiMap = result2;
        if (multiMap == null) {
            GitUpdateSession.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitUpdateSession";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitUpdateSession";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByReasons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "groupByReasons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

