/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlAutoPopupHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        boolean isXmlLikeFile;
        boolean spaceInTag;
        if (project == null) {
            XmlAutoPopupHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XmlAutoPopupHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            XmlAutoPopupHandler.$$$reportNull$$$0(2);
        }
        boolean bl = spaceInTag = (isXmlLikeFile = XmlGtTypedHandler.fileContainsXmlLanguage(file2)) && charTyped == ' ';
        if (spaceInTag) {
            PsiElement parent;
            spaceInTag = false;
            PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
            if (at != null && (parent = at.getParent()) instanceof XmlTag) {
                spaceInTag = true;
            }
        }
        if ((charTyped == '<' || charTyped == '{' || charTyped == '/' || spaceInTag) && isXmlLikeFile) {
            XmlAutoPopupHandler.autoPopupXmlLookup(project, editor);
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                XmlAutoPopupHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
        if (result3 == null) {
            XmlAutoPopupHandler.$$$reportNull$$$0(4);
        }
        return result3;
    }

    public static void autoPopupXmlLookup(Project project, Editor editor) {
        AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, (Condition<PsiFile>)((Condition)file2 -> {
            Language templateDataLanguage;
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = InjectedLanguageUtil.findElementAtNoCommit(file2, offset - 1);
            if (lastElement instanceof PsiFile) {
                lastElement = file2.findElementAt(offset - 1);
            }
            if (lastElement == null || !lastElement.isValid()) {
                return false;
            }
            if (XmlAutoPopupHandler.doCompleteIfNeeded(offset, file2, lastElement)) {
                return true;
            }
            FileViewProvider fileViewProvider = file2.getViewProvider();
            PsiElement parent = lastElement.getParent();
            if (fileViewProvider instanceof TemplateLanguageFileViewProvider && (templateDataLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage()) != parent.getLanguage()) {
                lastElement = fileViewProvider.findElementAt(offset - 1, templateDataLanguage);
                if (lastElement == null || !lastElement.isValid()) {
                    return false;
                }
                return XmlAutoPopupHandler.doCompleteIfNeeded(offset, file2, lastElement);
            }
            return false;
        }));
    }

    private static boolean doCompleteIfNeeded(int offset, PsiFile file2, PsiElement lastElement) {
        Ref isRelevantLanguage = new Ref();
        Ref isAnt = new Ref();
        String text2 = lastElement.getText();
        int len = offset - lastElement.getTextRange().getStartOffset();
        if (len < text2.length()) {
            text2 = text2.substring(0, len);
        }
        return text2.equals("<") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || text2.equals(" ") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || text2.endsWith("${") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) && (Boolean)isAnt.get() != false || text2.endsWith("@{") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) && (Boolean)isAnt.get() != false || text2.endsWith("</") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt);
    }

    private static boolean isLanguageRelevant(PsiElement element, PsiFile file2, Ref<Boolean> isRelevantLanguage, Ref<Boolean> isAnt) {
        Boolean result2;
        Boolean isAntFile = (Boolean)isAnt.get();
        if (isAntFile == null) {
            isAntFile = XmlUtil.isAntFile(file2);
            isAnt.set((Object)isAntFile);
        }
        if ((result2 = (Boolean)isRelevantLanguage.get()) == null) {
            Language language = element.getLanguage();
            PsiElement parent = element.getParent();
            if (element instanceof PsiWhiteSpace && parent != null) {
                language = parent.getLanguage();
            }
            result2 = language instanceof XMLLanguage || HtmlUtil.supportsXmlTypedHandlers(file2) || isAntFile != false;
            isRelevantLanguage.set((Object)result2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlAutoPopupHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlAutoPopupHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

