/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.DocumentFoldingInfo;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.WeakList;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFoldingManagerImpl
extends CodeFoldingManager
implements ProjectComponent,
Disposable {
    private final Project myProject;
    private final Collection<Document> myDocumentsWithFoldingInfo = new WeakList();
    private final Key<DocumentFoldingInfo> myFoldingInfoInDocumentKey = Key.create((String)"FOLDING_INFO_IN_DOCUMENT_KEY");
    private static final Key<Boolean> FOLDING_STATE_KEY = Key.create((String)"FOLDING_STATE_KEY");

    CodeFoldingManagerImpl(Project project) {
        this.myProject = project;
    }

    public void dispose() {
        for (Document document : this.myDocumentsWithFoldingInfo) {
            if (document == null) continue;
            document.putUserData(this.myFoldingInfoInDocumentKey, null);
        }
    }

    public void projectOpened() {
        EditorMouseMotionAdapter myMouseMotionListener = new EditorMouseMotionAdapter(){
            LightweightHint myCurrentHint;
            FoldRegion myCurrentFold;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseMoved(EditorMouseEvent e) {
                if (CodeFoldingManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                LightweightHint hint = null;
                try {
                    HintManager hintManager = HintManager.getInstance();
                    if (hintManager != null && hintManager.hasShownHintsThatWillHideByOtherHint(false)) {
                        return;
                    }
                    if (e.getArea() != EditorMouseEventArea.FOLDING_OUTLINE_AREA) {
                        return;
                    }
                    Editor editor = e.getEditor();
                    if (PsiDocumentManager.getInstance((Project)CodeFoldingManagerImpl.this.myProject).isUncommited(editor.getDocument())) {
                        return;
                    }
                    MouseEvent mouseEvent = e.getMouseEvent();
                    FoldRegion fold2 = ((EditorEx)editor).getGutterComponentEx().findFoldingAnchorAt(mouseEvent.getX(), mouseEvent.getY());
                    if (fold2 == null || !fold2.isValid()) {
                        return;
                    }
                    if (fold2 == this.myCurrentFold && this.myCurrentHint != null) {
                        hint = this.myCurrentHint;
                        return;
                    }
                    TextRange psiElementRange = EditorFoldingInfo.get(editor).getPsiElementRange(fold2);
                    if (psiElementRange == null) {
                        return;
                    }
                    int textOffset = psiElementRange.getStartOffset();
                    Point foldStartXY = editor.visualPositionToXY(editor.offsetToVisualPosition(Math.max(textOffset, fold2.getStartOffset())));
                    Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
                    if (visibleArea.y > foldStartXY.y) {
                        int desiredEndVisualLine;
                        int availableVisualLines;
                        int startVisualLine;
                        int endVisualLine;
                        if (this.myCurrentHint != null) {
                            this.myCurrentHint.hide();
                            this.myCurrentHint = null;
                        }
                        if ((endVisualLine = (startVisualLine = editor.offsetToVisualPosition((int)textOffset).line) + (availableVisualLines = EditorFragmentComponent.getAvailableVisualLinesAboveEditor(editor))) > (desiredEndVisualLine = Math.max(0, editor.xyToVisualPosition((Point)new Point((int)0, (int)visibleArea.y)).line - 1))) {
                            endVisualLine = desiredEndVisualLine;
                        }
                        int endOffset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(new VisualPosition(endVisualLine, 0)));
                        UnfairTextRange textRange = new UnfairTextRange(textOffset, endOffset);
                        hint = EditorFragmentComponent.showEditorFragmentHint(editor, (TextRange)textRange, true, true);
                        this.myCurrentFold = fold2;
                        this.myCurrentHint = hint;
                    }
                }
                finally {
                    if (hint == null) {
                        if (this.myCurrentHint != null) {
                            this.myCurrentHint.hide();
                            this.myCurrentHint = null;
                        }
                        this.myCurrentFold = null;
                    }
                }
            }
        };
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)myMouseMotionListener, (Disposable)this.myProject)));
    }

    @Override
    public void releaseFoldings(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(0);
        }
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        Project project = editor.getProject();
        if (!(project == null || project.equals(this.myProject) && project.isOpen())) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file2 == null || !file2.getViewProvider().isPhysical() || !file2.isValid()) {
            return;
        }
        EditorFoldingInfo.get(editor).dispose();
    }

    @Override
    public void buildInitialFoldings(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null || !project.equals(this.myProject) || editor.isDisposed()) {
            return;
        }
        if (!((FoldingModelEx)editor.getFoldingModel()).isFoldingEnabled()) {
            return;
        }
        if (!FoldingUpdate.supportsDumbModeFolding(editor)) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        CodeFoldingState foldingState = this.buildInitialFoldings(document);
        if (foldingState != null) {
            foldingState.setToEditor(editor);
        }
    }

    @Override
    @Nullable
    public CodeFoldingState buildInitialFoldings(@NotNull Document document) {
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        if (psiDocumentManager.isUncommited(document)) {
            return null;
        }
        PsiFile file2 = psiDocumentManager.getPsiFile(document);
        if (file2 == null || !file2.isValid() || !file2.getViewProvider().isPhysical() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        List<FoldingUpdate.RegionInfo> regionInfos = FoldingUpdate.getFoldingsFor(file2, document, true);
        return editor -> {
            ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
            if (this.myProject.isDisposed() || editor.isDisposed()) {
                return;
            }
            FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
            if (!foldingModel.isFoldingEnabled()) {
                return;
            }
            if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject) && !FoldingUpdate.supportsDumbModeFolding(editor)) {
                return;
            }
            foldingModel.runBatchFoldingOperationDoNotCollapseCaret(new UpdateFoldRegionsOperation(this.myProject, editor, file2, regionInfos, UpdateFoldRegionsOperation.ApplyDefaultStateMode.YES, false, false));
            this.initFolding(editor);
        };
    }

    @Override
    @Nullable
    public Boolean isCollapsedByDefault(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(3);
        }
        return (Boolean)region.getUserData(UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT);
    }

    @Override
    public void scheduleAsyncFoldingUpdate(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(4);
        }
        editor.putUserData(FoldingUpdate.CODE_FOLDING_KEY, null);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private void initFolding(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(5);
        }
        Document document = editor.getDocument();
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            Editor[] editors;
            if (editor == null) {
                CodeFoldingManagerImpl.$$$reportNull$$$0(23);
            }
            DocumentFoldingInfo documentFoldingInfo = this.getDocumentFoldingInfo(document);
            for (Editor otherEditor : editors = EditorFactory.getInstance().getEditors(document, this.myProject)) {
                if (otherEditor == editor || !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(otherEditor)) continue;
                documentFoldingInfo.loadFromEditor(otherEditor);
                break;
            }
            documentFoldingInfo.setToEditor(editor);
            documentFoldingInfo.clear();
            editor.putUserData(FOLDING_STATE_KEY, (Object)Boolean.TRUE);
        });
    }

    @Override
    @Nullable
    public FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(6);
        }
        return FoldingUtil.findFoldRegion(editor, startOffset, endOffset);
    }

    @Override
    public FoldRegion[] getFoldRegionsAtOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(7);
        }
        return FoldingUtil.getFoldRegionsAtOffset(editor, offset);
    }

    @Override
    public void updateFoldRegions(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(8);
        }
        this.updateFoldRegions(editor, false);
    }

    public void updateFoldRegions(Editor editor, boolean quick) {
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable2 = this.updateFoldRegions(editor, false, quick);
        if (runnable2 != null) {
            runnable2.run();
        }
    }

    @Override
    public void forceDefaultState(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(9);
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable2 = this.updateFoldRegions(editor, true, false);
        if (runnable2 != null) {
            runnable2.run();
        }
        FoldRegion[] regions = editor.getFoldingModel().getAllFoldRegions();
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            for (FoldRegion region : regions) {
                Boolean collapsedByDefault = (Boolean)region.getUserData(UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT);
                if (collapsedByDefault == null) continue;
                region.setExpanded(collapsedByDefault == false);
            }
        });
    }

    @Override
    @Nullable
    public Runnable updateFoldRegionsAsync(@NotNull Editor editor, boolean firstTime) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(10);
        }
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return null;
        }
        Runnable runnable2 = this.updateFoldRegions(editor, firstTime, false);
        return () -> {
            if (editor == null) {
                CodeFoldingManagerImpl.$$$reportNull$$$0(22);
            }
            if (runnable2 != null) {
                runnable2.run();
            }
            if (firstTime && !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                this.initFolding(editor);
            }
        };
    }

    @Nullable
    private Runnable updateFoldRegions(@NotNull Editor editor, boolean applyDefaultState, boolean quick) {
        PsiFile file2;
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(11);
        }
        return (file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument())) == null ? null : FoldingUpdate.updateFoldRegions(editor, file2, applyDefaultState, quick);
    }

    @Override
    public CodeFoldingState saveFoldingState(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(editor.getDocument());
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            info.loadFromEditor(editor);
        }
        return info;
    }

    @Override
    public void restoreFoldingState(@NotNull Editor editor, @NotNull CodeFoldingState state2) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(13);
        }
        if (state2 == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            state2.setToEditor(editor);
        }
    }

    @Override
    public void writeFoldingState(@NotNull CodeFoldingState state2, @NotNull Element element) {
        if (state2 == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(15);
        }
        if (element == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(16);
        }
        if (state2 instanceof DocumentFoldingInfo) {
            ((DocumentFoldingInfo)state2).writeExternal(element);
        }
    }

    @Override
    public CodeFoldingState readFoldingState(@NotNull Element element, @NotNull Document document) {
        if (element == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(17);
        }
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(18);
        }
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(document);
        info.readExternal(element);
        return info;
    }

    @NotNull
    private DocumentFoldingInfo getDocumentFoldingInfo(@NotNull Document document) {
        DocumentFoldingInfo info;
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(19);
        }
        if ((info = (DocumentFoldingInfo)document.getUserData(this.myFoldingInfoInDocumentKey)) == null) {
            info = new DocumentFoldingInfo(this.myProject, document);
            DocumentFoldingInfo written = (DocumentFoldingInfo)((UserDataHolderEx)document).putUserDataIfAbsent(this.myFoldingInfoInDocumentKey, (Object)info);
            if (written == info) {
                this.myDocumentsWithFoldingInfo.add(document);
            } else {
                info = written;
            }
        }
        DocumentFoldingInfo documentFoldingInfo = info;
        if (documentFoldingInfo == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(20);
        }
        return documentFoldingInfo;
    }

    private static boolean isFoldingsInitializedInEditor(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(21);
        }
        return Boolean.TRUE.equals(editor.getUserData(FOLDING_STATE_KEY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentFoldingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "releaseFoldings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildInitialFoldings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsyncFoldingUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initFolding";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFoldRegion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFoldRegionsAtOffset";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forceDefaultState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegionsAsync";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveFoldingState";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "restoreFoldingState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeFoldingState";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readFoldingState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFoldingInfo";
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isFoldingsInitializedInEditor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateFoldRegionsAsync$4";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initFolding$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

