/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestRunnableState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImportTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AbstractImportTestsAction.class);
    public static final String TEST_HISTORY_SIZE = "test_history_size";
    private SMTRunnerConsoleProperties myProperties;

    public AbstractImportTestsAction(@Nullable String text2, @Nullable String description, @Nullable Icon icon) {
        super(text2, description, icon);
    }

    public AbstractImportTestsAction(SMTRunnerConsoleProperties properties, @Nullable String text2, @Nullable String description, @Nullable Icon icon) {
        this(text2, description, icon);
        this.myProperties = properties;
    }

    public static int getHistorySize() {
        int historySize;
        try {
            historySize = Math.max(0, Integer.parseInt(PropertiesComponent.getInstance().getValue(TEST_HISTORY_SIZE, "10")));
        }
        catch (NumberFormatException e) {
            historySize = 10;
        }
        return historySize;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    @Nullable
    public abstract VirtualFile getFile(@NotNull Project var1);

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        VirtualFile file2 = this.getFile(project);
        if (file2 != null) {
            try {
                RunConfiguration initialConfiguration;
                ProgramRunner runner;
                ImportRunProfile profile2 = new ImportRunProfile(file2, project);
                SMTRunnerConsoleProperties properties = profile2.getProperties();
                if (properties == null) {
                    properties = this.myProperties;
                    LOG.info("Failed to detect test framework in " + file2.getPath() + "; use " + (properties != null ? properties.getTestFrameworkName() + " from toolbar" : "no properties"));
                }
                Executor executor = properties != null ? properties.getExecutor() : ExecutorRegistry.getInstance().getExecutorById(DefaultRunExecutor.EXECUTOR_ID);
                ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.create((Project)project, (Executor)executor, (RunProfile)profile2);
                ExecutionTarget target2 = profile2.getTarget();
                if (target2 != null) {
                    builder2 = builder2.target(target2);
                }
                ProgramRunner programRunner = runner = (initialConfiguration = profile2.getInitialConfiguration()) != null ? RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)initialConfiguration) : null;
                if (runner != null) {
                    builder2 = builder2.runner(runner);
                }
                builder2.buildAndExecute();
            }
            catch (ExecutionException e1) {
                Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)"Import Failed");
            }
        }
    }

    public static void adjustHistory(Project project) {
        int historySize = AbstractImportTestsAction.getHistorySize();
        File[] files2 = TestStateStorage.getTestHistoryRoot(project).listFiles((dir, name) -> name.endsWith(".xml"));
        if (files2 != null && files2.length >= historySize + 1) {
            Arrays.sort(files2, (o1, o2) -> {
                long l2;
                long l1 = o1.lastModified();
                if (l1 == (l2 = o2.lastModified())) {
                    return FileUtil.compareFiles((File)o1, (File)o2);
                }
                return l1 < l2 ? -1 : 1;
            });
            FileUtil.delete((File)files2[0]);
        }
    }

    public static class ImportRunProfile
    implements RunProfile {
        private final VirtualFile myFile;
        private final Project myProject;
        private RunConfiguration myConfiguration;
        private boolean myImported;
        private SMTRunnerConsoleProperties myProperties;
        private String myTargetId;

        public ImportRunProfile(VirtualFile file2, Project project) {
            this.myFile = file2;
            this.myProject = project;
            try {
                Element config = JDOMUtil.load((File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile)).getChild("config");
                if (config != null) {
                    ConfigurationType configurationType;
                    String configTypeId = config.getAttributeValue("configId");
                    if (configTypeId != null && (configurationType = ConfigurationTypeUtil.findConfigurationType((String)configTypeId)) != null) {
                        this.myConfiguration = configurationType.getConfigurationFactories()[0].createTemplateConfiguration(project);
                        this.myConfiguration.setName(config.getAttributeValue("name"));
                        this.myConfiguration.readExternal(config);
                        Executor executor = ExecutorRegistry.getInstance().getExecutorById(DefaultRunExecutor.EXECUTOR_ID);
                        if (executor != null && this.myConfiguration instanceof SMRunnerConsolePropertiesProvider) {
                            this.myProperties = ((SMRunnerConsolePropertiesProvider)this.myConfiguration).createTestConsoleProperties(executor);
                        }
                    }
                    this.myTargetId = config.getAttributeValue("target");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ExecutionTarget getTarget() {
            if (this.myTargetId != null) {
                if (DefaultExecutionTarget.INSTANCE.getId().equals(this.myTargetId)) {
                    return DefaultExecutionTarget.INSTANCE;
                }
                RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(RunManagerImpl.getInstanceImpl(this.myProject), this.myConfiguration, false);
                for (ExecutionTargetProvider provider : (ExecutionTargetProvider[])Extensions.getExtensions((ExtensionPointName)ExecutionTargetProvider.EXTENSION_NAME)) {
                    for (ExecutionTarget target2 : provider.getTargets(this.myProject, (RunnerAndConfigurationSettings)settings)) {
                        if (!this.myTargetId.equals(target2.getId())) continue;
                        return target2;
                    }
                }
                return null;
            }
            return DefaultExecutionTarget.INSTANCE;
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (executor == null) {
                ImportRunProfile.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                ImportRunProfile.$$$reportNull$$$0(1);
            }
            if (!this.myImported) {
                this.myImported = true;
                return new ImportedTestRunnableState(this, VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            }
            if (this.myConfiguration != null) {
                try {
                    return this.myConfiguration.getState(executor, environment);
                }
                catch (Throwable e) {
                    if (this.myTargetId != null && this.getTarget() == null) {
                        throw new ExecutionException("The target " + this.myTargetId + " does not exist");
                    }
                    LOG.info(e);
                    throw new ExecutionException("Unable to run the configuration: settings are corrupted");
                }
            }
            throw new ExecutionException("Unable to run the configuration: failed to detect test framework");
        }

        public String getName() {
            return this.myImported && this.myConfiguration != null ? this.myConfiguration.getName() : this.myFile.getNameWithoutExtension();
        }

        @Nullable
        public Icon getIcon() {
            return this.myProperties != null ? this.myProperties.getConfiguration().getIcon() : null;
        }

        public SMTRunnerConsoleProperties getProperties() {
            return this.myProperties;
        }

        public RunConfiguration getInitialConfiguration() {
            return this.myConfiguration;
        }

        public Project getProject() {
            return this.myProject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "environment";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile";
            objectArray[2] = "getState";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

