/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.update;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.update.RunningApplicationUpdater;
import com.intellij.execution.update.RunningApplicationUpdaterProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateRunningApplicationAction
extends AnAction {
    public UpdateRunningApplicationAction() {
        super("Update Running Application", null, AllIcons.Javaee.UpdateRunningApplication);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        Presentation presentation = e.getPresentation();
        if (contentDescriptor != null && project != null) {
            ProcessHandler processHandler2 = contentDescriptor.getProcessHandler();
            RunningApplicationUpdater updater = UpdateRunningApplicationAction.findUpdater(project, processHandler2);
            if (updater != null) {
                presentation.setEnabled(processHandler2.isStartNotified() && !processHandler2.isProcessTerminating() && !processHandler2.isProcessTerminated() && updater.isEnabled());
                presentation.setText(updater.getDescription());
            } else {
                presentation.setEnabled(false);
            }
            presentation.setVisible(true);
            return;
        }
        List<RunningApplicationUpdater> updaters = UpdateRunningApplicationAction.getAvailableUpdaters(project);
        boolean enable = !updaters.isEmpty();
        presentation.setEnabledAndVisible(enable);
        if (updaters.size() == 1) {
            presentation.setText(updaters.get(0).getDescription());
        } else {
            presentation.setText("Update Running Application...");
        }
    }

    @Nullable
    private static RunningApplicationUpdater findUpdater(@NotNull Project project, @Nullable ProcessHandler processHandler2) {
        if (project == null) {
            UpdateRunningApplicationAction.$$$reportNull$$$0(0);
        }
        if (processHandler2 == null) {
            return null;
        }
        for (RunningApplicationUpdaterProvider provider : (RunningApplicationUpdaterProvider[])RunningApplicationUpdaterProvider.EP_NAME.getExtensions()) {
            RunningApplicationUpdater updater = provider.createUpdater(project, processHandler2);
            if (updater == null) continue;
            return updater;
        }
        return null;
    }

    private static List<RunningApplicationUpdater> getAvailableUpdaters(@Nullable Project project) {
        ProcessHandler[] processes;
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<RunningApplicationUpdater> result2 = new ArrayList<RunningApplicationUpdater>();
        for (ProcessHandler process2 : processes = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (process2.isProcessTerminated() || process2.isProcessTerminating() || !process2.isStartNotified()) continue;
            ContainerUtil.addIfNotNull(result2, (Object)UpdateRunningApplicationAction.findUpdater(project, process2));
        }
        return result2;
    }

    public void actionPerformed(AnActionEvent e) {
        RunningApplicationUpdater updater;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        if (contentDescriptor != null && (updater = UpdateRunningApplicationAction.findUpdater(project, contentDescriptor.getProcessHandler())) != null && updater.isEnabled()) {
            updater.performUpdate();
            return;
        }
        List<RunningApplicationUpdater> updaters = UpdateRunningApplicationAction.getAvailableUpdaters(project);
        if (updaters.isEmpty()) {
            return;
        }
        if (updaters.size() > 1) {
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<RunningApplicationUpdater>("Select Process to Update", updaters){

                @NotNull
                public String getTextFor(RunningApplicationUpdater value) {
                    String string = value.getShortName();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public Icon getIconFor(RunningApplicationUpdater value) {
                    return value.getIcon();
                }

                public PopupStep onChosen(RunningApplicationUpdater selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> selectedValue.performUpdate());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/update/UpdateRunningApplicationAction$1", "getTextFor"));
                }
            });
            popup2.showCenteredInCurrentWindow(project);
        } else {
            updaters.get(0).performUpdate();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/update/UpdateRunningApplicationAction", "findUpdater"));
    }
}

