/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromTemplateAction<T extends PsiElement>
extends AnAction
implements WriteActionAware {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.CreateFromTemplateAction");

    public CreateFromTemplateAction(String text2, String description, Icon icon) {
        super(text2, description, icon);
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null || project == null) {
            return;
        }
        CreateFileFromTemplateDialog.Builder builder2 = CreateFileFromTemplateDialog.createDialog(project);
        this.buildDialog(project, dir, builder2);
        final Ref selectedTemplateName = Ref.create(null);
        Object createdElement = builder2.show(this.getErrorTitle(), this.getDefaultTemplateName(dir), new CreateFileFromTemplateDialog.FileCreator<T>(){

            @Override
            public T createFile(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (templateName == null) {
                    1.$$$reportNull$$$0(1);
                }
                selectedTemplateName.set((Object)templateName);
                return CreateFromTemplateAction.this.createFile(name, templateName, dir);
            }

            @Override
            public boolean startInWriteAction() {
                return CreateFromTemplateAction.this.startInWriteAction();
            }

            @Override
            @NotNull
            public String getActionName(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (templateName == null) {
                    1.$$$reportNull$$$0(3);
                }
                String string = CreateFromTemplateAction.this.getActionName(dir, name, templateName);
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "templateName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/CreateFromTemplateAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/CreateFromTemplateAction$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createFile";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getActionName";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (createdElement != null) {
            view.selectElement(createdElement);
            this.postProcess(createdElement, (String)selectedTemplateName.get(), builder2.getCustomProperties());
        }
    }

    protected void postProcess(T createdElement, String templateName, Map<String, String> customProperties) {
    }

    @Nullable
    protected abstract T createFile(String var1, String var2, PsiDirectory var3);

    protected abstract void buildDialog(Project var1, PsiDirectory var2, CreateFileFromTemplateDialog.Builder var3);

    @Nullable
    protected String getDefaultTemplateName(@NotNull PsiDirectory dir) {
        String property;
        if (dir == null) {
            CreateFromTemplateAction.$$$reportNull$$$0(0);
        }
        return (property = this.getDefaultTemplateProperty()) == null ? null : PropertiesComponent.getInstance((Project)dir.getProject()).getValue(property);
    }

    @Nullable
    protected String getDefaultTemplateProperty() {
        return null;
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return project != null && view != null && view.getDirectories().length != 0;
    }

    protected abstract String getActionName(PsiDirectory var1, String var2, String var3);

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    public static void moveCaretAfterNameIdentifier(PsiNameIdentifierOwner createdElement) {
        PsiElement nameIdentifier;
        VirtualFile virtualFile;
        Project project = createdElement.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null && (virtualFile = createdElement.getContainingFile().getVirtualFile()) != null && FileDocumentManager.getInstance().getDocument(virtualFile) == editor.getDocument() && (nameIdentifier = createdElement.getNameIdentifier()) != null) {
            editor.getCaretModel().moveToOffset(nameIdentifier.getTextRange().getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/ide/actions/CreateFromTemplateAction", "getDefaultTemplateName"));
    }
}

