/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleFullScreenAction
extends DumbAwareAction {
    private static final String TEXT_ENTER_FULL_SCREEN = ActionsBundle.message((String)"action.ToggleFullScreen.text.enter", (Object[])new Object[0]);
    private static final String TEXT_EXIT_FULL_SCREEN = ActionsBundle.message((String)"action.ToggleFullScreen.text.exit", (Object[])new Object[0]);

    public void actionPerformed(AnActionEvent e) {
        IdeFrameEx frame = ToggleFullScreenAction.getFrame();
        if (frame != null) {
            frame.toggleFullScreen(!frame.isInFullScreen());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isApplicable;
        if (e == null) {
            ToggleFullScreenAction.$$$reportNull$$$0(0);
        }
        Presentation p = e.getPresentation();
        IdeFrameEx frame = null;
        boolean bl = isApplicable = WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (frame = ToggleFullScreenAction.getFrame()) != null;
        if (e.getPlace() != "MainToolbar") {
            p.setVisible(isApplicable);
        }
        p.setEnabled(isApplicable);
        if (isApplicable) {
            p.setText(frame.isInFullScreen() ? TEXT_EXIT_FULL_SCREEN : TEXT_ENTER_FULL_SCREEN);
        }
    }

    @Nullable
    private static IdeFrameEx getFrame() {
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        if (focusOwner != null) {
            Window window;
            Window window2 = window = focusOwner instanceof JFrame ? (Window)focusOwner : SwingUtilities.getWindowAncestor(focusOwner);
            if (window != null && !(window instanceof IdeFrameEx)) {
                window = SwingUtilities.getWindowAncestor(window);
            }
            if (window instanceof IdeFrameEx) {
                return (IdeFrameEx)((Object)window);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleFullScreenAction", "update"));
    }
}

