/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.groups;

import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunAnythingGroup {
    volatile int myMoreIndex = -1;
    private volatile int myTitleIndex = -1;

    @NotNull
    public abstract String getTitle();

    protected int getMaxInitialItems() {
        return 5;
    }

    protected int getMaxItemsToInsert() {
        return 5;
    }

    public abstract SearchResult getItems(@NotNull DataContext var1, @NotNull DefaultListModel var2, @NotNull String var3, boolean var4, @NotNull Runnable var5);

    public void resetMoreIndex() {
        this.myMoreIndex = -1;
    }

    private static void shiftMoreIndex(Collection<RunAnythingGroup> groups, int baseIndex, int shift) {
        groups.stream().filter(runAnythingGroup -> runAnythingGroup.myMoreIndex >= baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myMoreIndex += shift);
    }

    @Nullable
    public static String getTitle(@NotNull Collection<RunAnythingGroup> groups, int titleIndex) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(0);
        }
        return groups.stream().filter(runAnythingGroup -> titleIndex == runAnythingGroup.myTitleIndex).findFirst().map(RunAnythingGroup::getTitle).orElse(null);
    }

    private static void shiftTitleIndex(@NotNull Collection<RunAnythingGroup> groups, int baseIndex, int shift) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(1);
        }
        groups.stream().filter(runAnythingGroup -> runAnythingGroup.myTitleIndex != -1 && runAnythingGroup.myTitleIndex > baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myTitleIndex += shift);
    }

    public static void clearMoreIndex(@NotNull Collection<RunAnythingGroup> groups) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(2);
        }
        groups.forEach(runAnythingGroup -> {
            runAnythingGroup.myMoreIndex = -1;
        });
    }

    private static void clearTitleIndex(@NotNull Collection<RunAnythingGroup> groups) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(3);
        }
        groups.forEach(runAnythingGroup -> {
            runAnythingGroup.myTitleIndex = -1;
        });
    }

    public static int[] getAllIndexes(@NotNull Collection<RunAnythingGroup> groups) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(4);
        }
        TIntArrayList list2 = new TIntArrayList();
        for (RunAnythingGroup runAnythingGroup : groups) {
            list2.add(runAnythingGroup.myTitleIndex);
        }
        for (RunAnythingGroup runAnythingGroup : groups) {
            list2.add(runAnythingGroup.myMoreIndex);
        }
        return list2.toNativeArray();
    }

    @Nullable
    public static RunAnythingGroup findGroupByMoreIndex(@NotNull Collection<RunAnythingGroup> groups, int moreIndex) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(5);
        }
        return groups.stream().filter(runAnythingGroup -> moreIndex == runAnythingGroup.myMoreIndex).findFirst().orElse(null);
    }

    public static boolean isMoreIndex(@NotNull Collection<RunAnythingGroup> groups, int index) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(6);
        }
        return groups.stream().anyMatch(runAnythingGroup -> runAnythingGroup.myMoreIndex == index);
    }

    public static void shiftIndexes(@NotNull Collection<RunAnythingGroup> groups, int baseIndex, int shift) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(7);
        }
        RunAnythingGroup.shiftTitleIndex(groups, baseIndex, shift);
        RunAnythingGroup.shiftMoreIndex(groups, baseIndex, shift);
    }

    public static void clearIndexes(@NotNull Collection<RunAnythingGroup> groups) {
        if (groups == null) {
            RunAnythingGroup.$$$reportNull$$$0(8);
        }
        RunAnythingGroup.clearTitleIndex(groups);
        RunAnythingGroup.clearMoreIndex(groups);
    }

    public final synchronized void collectItems(DataContext dataContext, @NotNull DefaultListModel model, @NotNull String pattern, @NotNull Runnable cancellationChecker) {
        if (model == null) {
            RunAnythingGroup.$$$reportNull$$$0(9);
        }
        if (pattern == null) {
            RunAnythingGroup.$$$reportNull$$$0(10);
        }
        if (cancellationChecker == null) {
            RunAnythingGroup.$$$reportNull$$$0(11);
        }
        SearchResult result2 = this.getItems(dataContext, model, pattern, false, cancellationChecker);
        cancellationChecker.run();
        if (!result2.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (cancellationChecker == null) {
                    RunAnythingGroup.$$$reportNull$$$0(12);
                }
                if (model == null) {
                    RunAnythingGroup.$$$reportNull$$$0(13);
                }
                cancellationChecker.run();
                this.myTitleIndex = model.size();
                result2.forEach(model::addElement);
                this.myMoreIndex = result2.myNeedMore ? model.getSize() - 1 : -1;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationChecker";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/runAnything/groups/RunAnythingGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shiftTitleIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearMoreIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "clearTitleIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllIndexes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findGroupByMoreIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isMoreIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shiftIndexes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "clearIndexes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "collectItems";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectItems$9";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SearchResult
    extends ArrayList<RunAnythingItem> {
        boolean myNeedMore;

        public boolean isNeedMore() {
            return this.myNeedMore;
        }

        public void setNeedMore(boolean needMore) {
            this.myNeedMore = needMore;
        }
    }
}

