/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.AdvancedDnDSource;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.Highlighters;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.GeometryUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnDManagerImpl
extends DnDManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.dnd.DnDManager");
    @NonNls
    private static final String SOURCE_KEY = "DnD Source";
    @NonNls
    private static final String TARGET_KEY = "DnD Target";
    public static final Key<Pair<Image, Point>> DRAGGED_IMAGE_KEY = new Key("draggedImage");
    private DnDEventImpl myCurrentEvent;
    private DnDEvent myLastHighlightedEvent;
    private static final DnDTarget NULL_TARGET = new NullTarget();
    private WeakReference<DnDTarget> myLastProcessedTarget = new WeakReference<DnDTarget>(NULL_TARGET);
    private DragSourceContext myCurrentDragContext;
    private Component myLastProcessedOverComponent;
    private Point myLastProcessedPoint;
    private String myLastMessage;
    private DnDEvent myLastProcessedEvent;
    private final DragGestureListener myDragGestureListener = new MyDragGestureListener();
    private final DropTargetListener myDropTargetListener = new MyDropTargetListener();
    private static final Image EMPTY_IMAGE = UIUtil.createImage((int)1, (int)1, (int)3);
    private final Timer myTooltipTimer = UIUtil.createNamedTimer((String)"DndManagerImpl tooltip timer", (int)ToolTipManager.sharedInstance().getInitialDelay(), (ActionListener)new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DnDManagerImpl.this.onTimer();
        }
    });
    private Runnable myHighlighterShowRequest;
    private Rectangle myLastHighlightedRec;
    private int myLastProcessedAction;
    private final Application myApp;
    private WeakReference<Component> myLastDropHandler;

    public DnDManagerImpl(Application app) {
        this.myApp = app;
    }

    public void dispose() {
    }

    public void registerSource(@NotNull AdvancedDnDSource source) {
        if (source == null) {
            DnDManagerImpl.$$$reportNull$$$0(0);
        }
        if (!this.getApplication().isHeadlessEnvironment()) {
            JComponent c = source.getComponent();
            this.registerSource((DnDSource)source, c);
        }
    }

    public void registerSource(DnDSource source, JComponent component) {
        if (!this.getApplication().isHeadlessEnvironment()) {
            component.putClientProperty(SOURCE_KEY, source);
            DragSource defaultDragSource = DragSource.getDefaultDragSource();
            defaultDragSource.createDefaultDragGestureRecognizer(component, 3, this.myDragGestureListener);
        }
    }

    public void unregisterSource(AdvancedDnDSource source) {
        JComponent c = source.getComponent();
        this.unregisterSource((DnDSource)source, c);
    }

    public void unregisterSource(DnDSource source, JComponent component) {
        component.putClientProperty(SOURCE_KEY, null);
        this.cleanup(source, null, null);
    }

    private void cleanup(@Nullable DnDSource source, @Nullable DnDTarget target2, @Nullable JComponent targetComponent) {
        Runnable cleanup = () -> {
            if (this.shouldCancelCurrentDnDOperation(source, target2, targetComponent)) {
                this.myLastProcessedOverComponent = null;
                this.myCurrentDragContext = null;
                this.resetEvents("cleanup");
            }
        };
        if (this.myApp.isDispatchThread()) {
            cleanup.run();
        } else {
            SwingUtilities.invokeLater(cleanup);
        }
    }

    private boolean shouldCancelCurrentDnDOperation(DnDSource source, DnDTarget target2, JComponent targetComponent) {
        DnDEvent currentDnDEvent = this.myLastProcessedEvent;
        if (currentDnDEvent == null) {
            return true;
        }
        if (source != null && currentDnDEvent.equals(source)) {
            return true;
        }
        if (target2 != null && targetComponent != null) {
            for (Container eachParent = targetComponent; eachParent != null; eachParent = eachParent.getParent()) {
                if (!target2.equals(DnDManagerImpl.getTarget(eachParent))) continue;
                return true;
            }
        }
        return false;
    }

    public void registerTarget(DnDTarget target2, JComponent component) {
        if (!this.getApplication().isHeadlessEnvironment()) {
            component.putClientProperty(TARGET_KEY, target2);
            new DropTarget(component, 3, this.myDropTargetListener);
        }
    }

    public void unregisterTarget(DnDTarget target2, JComponent component) {
        component.putClientProperty(TARGET_KEY, null);
        this.cleanup(null, target2, component);
    }

    private DnDEventImpl updateCurrentEvent(Component aComponentOverDragging, Point aPoint, int nativeAction, @Nullable DataFlavor[] flavors, @Nullable Transferable transferable) {
        DnDTarget processedTarget;
        boolean sameTarget;
        DnDTarget target2;
        JComponent jComp;
        DnDTarget target3;
        LOG.debug("updateCurrentEvent: " + aComponentOverDragging);
        DnDEventImpl currentEvent = this.myCurrentEvent;
        if (this.myCurrentEvent == null && aComponentOverDragging instanceof JComponent && (target3 = DnDManagerImpl.getTarget(jComp = (JComponent)aComponentOverDragging)) instanceof DnDNativeTarget) {
            DnDEventImpl event = (DnDEventImpl)jComp.getClientProperty("DnDEvent");
            if (event == null) {
                DnDNativeTarget.EventInfo info = new DnDNativeTarget.EventInfo(flavors, transferable);
                event = new DnDEventImpl(this, DnDAction.COPY, info, aPoint);
                jComp.putClientProperty("DnDEvent", event);
            }
            currentEvent = event;
        }
        if (currentEvent == null) {
            return currentEvent;
        }
        DnDAction dndAction = DnDManagerImpl.getDnDActionForPlatformAction(nativeAction);
        if (dndAction == null) {
            return null;
        }
        currentEvent.updateAction(dndAction);
        currentEvent.setPoint(aPoint);
        currentEvent.setHandlerComponent(aComponentOverDragging);
        boolean samePoint = currentEvent.getPoint().equals(this.myLastProcessedPoint);
        boolean sameComponent = currentEvent.getCurrentOverComponent().equals(this.myLastProcessedOverComponent);
        boolean sameAction = nativeAction == this.myLastProcessedAction;
        LOG.debug("updateCurrentEvent: point:" + aPoint);
        LOG.debug("updateCurrentEvent: action:" + nativeAction);
        if (samePoint && sameComponent && sameAction) {
            return currentEvent;
        }
        DnDTarget immediateTarget = target2 = DnDManagerImpl.getTarget(aComponentOverDragging);
        Component eachParent = aComponentOverDragging;
        Pair pair = (Pair)currentEvent.getUserData(DRAGGED_IMAGE_KEY);
        if (pair != null) {
            target2.updateDraggedImage((Image)pair.first, aPoint, (Point)pair.second);
        }
        LOG.debug("updateCurrentEvent: action:" + nativeAction);
        while (true) {
            boolean canGoToParent = this.update(target2, currentEvent);
            if (currentEvent.isDropPossible()) {
                if (!currentEvent.wasDelegated()) break;
                target2 = currentEvent.getDelegatedTarget();
                break;
            }
            if (!canGoToParent || (eachParent = DnDManagerImpl.findAllowedParentComponent(eachParent)) == null) break;
            target2 = DnDManagerImpl.getTarget(eachParent);
        }
        LOG.debug("updateCurrentEvent: target:" + target2);
        LOG.debug("updateCurrentEvent: immediateTarget:" + immediateTarget);
        if (!currentEvent.isDropPossible() && !immediateTarget.equals(target2)) {
            this.update(immediateTarget, currentEvent);
        }
        this.updateCursor();
        Container current = (Container)currentEvent.getCurrentOverComponent();
        Point point = currentEvent.getPointOn(DnDManagerImpl.getLayeredPane(current));
        Rectangle inPlaceRect = new Rectangle(point.x - 5, point.y - 5, 5, 5);
        if (!currentEvent.equals(this.myLastProcessedEvent)) {
            this.hideCurrentHighlighter();
        }
        boolean bl = sameTarget = (processedTarget = this.getLastProcessedTarget()) != null && processedTarget.equals(target2);
        if (sameTarget) {
            if (currentEvent.isDropPossible()) {
                if (!this.myLastProcessedPoint.equals(currentEvent.getPoint()) && !Highlighters.isVisibleExcept(48)) {
                    this.hideCurrentHighlighter();
                    this.queueTooltip(currentEvent, DnDManagerImpl.getLayeredPane(current), inPlaceRect);
                }
            } else if (this.myLastProcessedPoint == null || currentEvent == null || !this.myLastProcessedPoint.equals(currentEvent.getPoint())) {
                this.hideCurrentHighlighter();
                this.queueTooltip(currentEvent, DnDManagerImpl.getLayeredPane(current), inPlaceRect);
            }
        } else {
            this.hideCurrentHighlighter();
            if (processedTarget != null) {
                processedTarget.cleanUpOnLeave();
            }
            currentEvent.clearDropHandler();
            if (!currentEvent.isDropPossible()) {
                this.queueTooltip(currentEvent, DnDManagerImpl.getLayeredPane(current), inPlaceRect);
            }
        }
        this.myLastProcessedTarget = new WeakReference<DnDTarget>(target2);
        this.myLastProcessedPoint = currentEvent.getPoint();
        this.myLastProcessedOverComponent = currentEvent.getCurrentOverComponent();
        this.myLastProcessedAction = currentEvent.getAction().getActionId();
        this.myLastProcessedEvent = (DnDEvent)currentEvent.clone();
        return currentEvent;
    }

    private void updateCursor() {
        Cursor cursor;
        if (this.myCurrentDragContext == null || this.myCurrentEvent == null) {
            return;
        }
        if (this.myCurrentEvent.isDropPossible()) {
            cursor = this.myCurrentEvent.getCursor();
            if (cursor == null) {
                cursor = this.myCurrentEvent.getAction().getCursor();
            }
        } else {
            cursor = this.myCurrentEvent.getAction().getRejectCursor();
        }
        this.myCurrentDragContext.setCursor(cursor);
    }

    private boolean update(DnDTarget target2, DnDEvent currentEvent) {
        LOG.debug("update target:" + target2);
        currentEvent.clearDelegatedTarget();
        boolean canGoToParent = target2.update(currentEvent);
        String message = DnDManagerImpl.isMessageProvided(currentEvent) ? currentEvent.getExpectedDropResult() : "";
        if (this.myLastMessage != null && !this.myLastMessage.equals(message)) {
            this.hideCurrentHighlighter();
        }
        this.myLastMessage = message;
        return canGoToParent;
    }

    private static Component findAllowedParentComponent(Component aComponentOverDragging) {
        DnDTarget target2;
        Component eachParent = aComponentOverDragging;
        do {
            if ((eachParent = eachParent.getParent()) != null) continue;
            return null;
        } while ((target2 = DnDManagerImpl.getTarget(eachParent)) == NULL_TARGET);
        return eachParent;
    }

    private static DnDSource getSource(Component component) {
        if (component instanceof JComponent) {
            return (DnDSource)((JComponent)component).getClientProperty(SOURCE_KEY);
        }
        return null;
    }

    private static DnDTarget getTarget(Component component) {
        DnDTarget target2;
        if (component instanceof JComponent && (target2 = (DnDTarget)((JComponent)component).getClientProperty(TARGET_KEY)) != null) {
            return target2;
        }
        return NULL_TARGET;
    }

    void showHighlighter(Component aComponent, int aType, DnDEvent aEvent) {
        Rectangle bounds = aComponent.getBounds();
        Container parent = aComponent.getParent();
        this.showHighlighter(parent, aEvent, bounds, aType);
    }

    void showHighlighter(RelativeRectangle rectangle, int aType, DnDEvent aEvent) {
        JLayeredPane layeredPane = DnDManagerImpl.getLayeredPane(rectangle.getPoint().getComponent());
        Rectangle bounds = rectangle.getRectangleOn((Component)layeredPane);
        this.showHighlighter((Component)layeredPane, aEvent, bounds, aType);
    }

    void showHighlighter(JLayeredPane layeredPane, RelativeRectangle rectangle, int aType, DnDEvent event) {
        Rectangle bounds = rectangle.getRectangleOn((Component)layeredPane);
        this.showHighlighter((Component)layeredPane, event, bounds, aType);
    }

    private boolean isEventBeingHighlighted(DnDEvent event) {
        return event.equals(this.getLastHighlightedEvent());
    }

    private void showHighlighter(Component parent, DnDEvent aEvent, Rectangle bounds, int aType) {
        JLayeredPane layeredPane = DnDManagerImpl.getLayeredPane(parent);
        if (layeredPane == null) {
            return;
        }
        if (this.isEventBeingHighlighted(aEvent) && GeometryUtil.isWithin((Rectangle)this.myLastHighlightedRec, (Point2D)aEvent.getPointOn((Component)layeredPane))) {
            return;
        }
        Rectangle rectangle = SwingUtilities.convertRectangle(parent, bounds, layeredPane);
        this.setLastHighlightedEvent((DnDEvent)((DnDEventImpl)aEvent).clone(), rectangle);
        Highlighters.hide();
        Highlighters.show(aType, layeredPane, rectangle, aEvent);
        if (DnDManagerImpl.isMessageProvided(aEvent)) {
            this.queueTooltip(aEvent, layeredPane, rectangle);
        } else {
            Highlighters.hide(48);
        }
    }

    private void queueTooltip(DnDEvent aEvent, JLayeredPane aLayeredPane, Rectangle aRectangle) {
        this.myHighlighterShowRequest = () -> {
            if (this.myCurrentEvent != aEvent) {
                return;
            }
            Highlighters.hide(48);
            if (aEvent.isDropPossible()) {
                Highlighters.show(16, aLayeredPane, aRectangle, aEvent);
            } else {
                Highlighters.show(32, aLayeredPane, aRectangle, aEvent);
            }
        };
        this.myTooltipTimer.restart();
    }

    private static boolean isMessageProvided(DnDEvent aEvent) {
        return aEvent.getExpectedDropResult() != null && aEvent.getExpectedDropResult().trim().length() > 0;
    }

    void hideCurrentHighlighter() {
        Highlighters.hide();
        this.clearRequest();
        this.setLastHighlightedEvent(null, null);
    }

    private void clearRequest() {
        this.myHighlighterShowRequest = null;
        this.myTooltipTimer.stop();
    }

    private void onTimer() {
        if (this.myHighlighterShowRequest != null) {
            this.myHighlighterShowRequest.run();
        }
        this.clearRequest();
    }

    private static JLayeredPane getLayeredPane(Component aComponent) {
        if (aComponent == null) {
            return null;
        }
        if (aComponent instanceof JLayeredPane) {
            return (JLayeredPane)aComponent;
        }
        if (aComponent instanceof JFrame) {
            return ((JFrame)aComponent).getRootPane().getLayeredPane();
        }
        if (aComponent instanceof JDialog) {
            return ((JDialog)aComponent).getRootPane().getLayeredPane();
        }
        Window window = SwingUtilities.getWindowAncestor(aComponent);
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane().getLayeredPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane().getLayeredPane();
        }
        return null;
    }

    private DnDTarget getLastProcessedTarget() {
        return (DnDTarget)this.myLastProcessedTarget.get();
    }

    DnDEvent getCurrentEvent() {
        return this.myCurrentEvent;
    }

    private DnDEvent getLastHighlightedEvent() {
        return this.myLastHighlightedEvent;
    }

    private void setLastHighlightedEvent(@Nullable DnDEvent lastHighlightedEvent, @Nullable Rectangle aRectangle) {
        this.myLastHighlightedEvent = lastHighlightedEvent;
        this.myLastHighlightedRec = aRectangle;
    }

    private void resetEvents(@NonNls String s) {
        this.myCurrentEvent = DnDManagerImpl.resetEvent(this.myCurrentEvent);
        this.myLastProcessedEvent = DnDManagerImpl.resetEvent(this.myLastProcessedEvent);
        this.myLastHighlightedEvent = DnDManagerImpl.resetEvent(this.myLastHighlightedEvent);
        LOG.debug("Reset events: " + s);
    }

    @Nullable
    private static DnDEventImpl resetEvent(DnDEvent event) {
        if (event == null) {
            return null;
        }
        event.cleanUp();
        return null;
    }

    private static DnDAction getDnDActionForPlatformAction(int platformAction) {
        DnDAction action = null;
        boolean altOnly = UISettings.getInstance().getDndWithPressedAltOnly();
        switch (platformAction) {
            case 1: {
                action = altOnly ? DnDAction.MOVE : DnDAction.COPY;
                break;
            }
            case 2: {
                action = altOnly ? DnDAction.COPY : DnDAction.MOVE;
                break;
            }
            case 0x40000000: {
                action = DnDAction.LINK;
                break;
            }
        }
        return action;
    }

    private void onDragExit() {
        DnDTarget target2;
        if (this.myCurrentDragContext != null) {
            this.myCurrentDragContext.setCursor(null);
        }
        if ((target2 = this.getLastProcessedTarget()) != null) {
            target2.cleanUpOnLeave();
        }
        this.hideCurrentHighlighter();
    }

    private Application getApplication() {
        return this.myApp;
    }

    public void setLastDropHandler(@Nullable Component c) {
        this.myLastDropHandler = c == null ? null : new WeakReference<Component>(c);
    }

    @Nullable
    public Component getLastDropHandler() {
        return (Component)SoftReference.dereference(this.myLastDropHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/dnd/DnDManagerImpl", "registerSource"));
    }

    private class MyDropTargetListener
    extends DropTargetAdapter {
        private MyDropTargetListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Component component = dtde.getDropTargetContext().getComponent();
                DnDEventImpl event = DnDManagerImpl.this.updateCurrentEvent(component, dtde.getLocation(), dtde.getDropAction(), dtde.getCurrentDataFlavors(), dtde.getTransferable());
                if (event != null && event.isDropPossible()) {
                    dtde.acceptDrop(dtde.getDropAction());
                    this.doDrop(component, event);
                    if (event.shouldRemoveHighlighting()) {
                        DnDManagerImpl.this.hideCurrentHighlighter();
                    }
                    dtde.dropComplete(true);
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (Throwable e) {
                LOG.error(e);
                dtde.rejectDrop();
            }
            finally {
                DnDManagerImpl.this.resetEvents("Stop dragging2");
            }
        }

        private void doDrop(Component component, DnDEventImpl currentEvent) {
            if (currentEvent.canHandleDrop()) {
                currentEvent.handleDrop();
            } else {
                DnDManagerImpl.getTarget(component).drop((DnDEvent)currentEvent);
            }
            this.cleanTargetComponent(component);
            DnDManagerImpl.this.setLastDropHandler(component);
            DnDManagerImpl.this.myCurrentDragContext = null;
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            DnDEventImpl event = DnDManagerImpl.this.updateCurrentEvent(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), dtde.getDropAction(), dtde.getCurrentDataFlavors(), dtde.getTransferable());
            if (DnDManagerImpl.this.myCurrentEvent == null) {
                if (event != null && event.isDropPossible()) {
                    dtde.acceptDrag(event.getAction().getActionId());
                } else {
                    dtde.rejectDrag();
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DnDManagerImpl.this.onDragExit();
            this.cleanTargetComponent(dte.getDropTargetContext().getComponent());
        }

        private void cleanTargetComponent(Component c) {
            DnDTarget target2 = DnDManagerImpl.getTarget(c);
            if (target2 instanceof DnDNativeTarget && c instanceof JComponent) {
                ((JComponent)c).putClientProperty("DnDEvent", null);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            DnDManagerImpl.this.updateCurrentEvent(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), dtde.getDropAction(), dtde.getCurrentDataFlavors(), dtde.getTransferable());
        }
    }

    private class MyDragSourceListener
    implements DragSourceListener {
        private final DnDSource mySource;

        public MyDragSourceListener(DnDSource source) {
            this.mySource = source;
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            LOG.debug("dragEnter:" + dsde.getDragSourceContext().getComponent());
            DnDManagerImpl.this.myCurrentDragContext = dsde.getDragSourceContext();
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
            LOG.debug("dragOver:" + dsde.getDragSourceContext().getComponent());
            DnDManagerImpl.this.myCurrentDragContext = dsde.getDragSourceContext();
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            this.mySource.dropActionChanged(dsde.getGestureModifiers());
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            this.mySource.dragDropEnd();
            DnDTarget target2 = DnDManagerImpl.this.getLastProcessedTarget();
            if (target2 != null) {
                target2.cleanUpOnLeave();
            }
            DnDManagerImpl.this.resetEvents("dragDropEnd:" + dsde.getDragSourceContext().getComponent());
            Highlighters.hide(48);
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            LOG.debug("Stop dragging1");
            DnDManagerImpl.this.onDragExit();
        }
    }

    private class MyDragGestureListener
    implements DragGestureListener {
        private MyDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            try {
                DnDSource source = DnDManagerImpl.getSource(dge.getComponent());
                if (source == null || !MouseDragHelper.checkModifiers((InputEvent)dge.getTriggerEvent())) {
                    return;
                }
                DnDAction action = DnDManagerImpl.getDnDActionForPlatformAction(dge.getDragAction());
                if (source.canStartDragging(action, dge.getDragOrigin()) && DnDManagerImpl.this.myCurrentEvent == null) {
                    Pair pair;
                    LOG.debug("Starting dragging for " + action);
                    DnDManagerImpl.this.hideCurrentHighlighter();
                    DnDDragStartBean bean = source.startDragging(action, dge.getDragOrigin());
                    DnDManagerImpl.this.myCurrentEvent = new DnDEventImpl(DnDManagerImpl.this, action, bean.getAttachedObject(), bean.getPoint());
                    DnDManagerImpl.this.myCurrentEvent.setOrgPoint(dge.getDragOrigin());
                    Pair pair2 = pair = bean.isEmpty() ? null : source.createDraggedImage(action, dge.getDragOrigin(), bean);
                    if (pair == null) {
                        pair = Pair.create((Object)EMPTY_IMAGE, (Object)new Point(0, 0));
                    }
                    if (!DragSource.isDragImageSupported()) {
                        DnDManagerImpl.this.myCurrentEvent.putUserData(DRAGGED_IMAGE_KEY, pair);
                    }
                    dge.startDrag(DragSource.DefaultCopyDrop, (Image)pair.first, (Point)pair.second, DnDManagerImpl.this.myCurrentEvent, new MyDragSourceListener(source));
                }
            }
            catch (InvalidDnDOperationException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private static class NullTarget
    implements DnDTarget {
        private NullTarget() {
        }

        public boolean update(DnDEvent aEvent) {
            aEvent.setDropPossible(false, "You cannot drop anything here");
            return false;
        }

        public void drop(DnDEvent aEvent) {
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }
}

