/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextBorder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class WinIntelliJTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public static final String HOVER_PROPERTY = "JTextField.hover";
    private MouseListener hoverListener;

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJTextFieldUI();
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.hoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(this.getComponent(), HOVER_PROPERTY);
        this.getComponent().addMouseListener(this.hoverListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this.hoverListener != null) {
            this.getComponent().removeMouseListener(this.hoverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        if (UIUtil.getParentOfType(JComboBox.class, (Component)c) != null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Container parent = c.getParent();
            if (c.isOpaque() && parent != null) {
                g2.setColor(parent.getBackground());
                g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            if (c.getBorder() instanceof WinIntelliJTextBorder) {
                WinIntelliJTextFieldUI.paintTextFieldBackground(c, g2);
            } else if (c.isOpaque()) {
                super.paintBackground(g);
            }
        }
        finally {
            g2.dispose();
        }
    }

    static void paintTextFieldBackground(JComponent c, Graphics2D g2) {
        g2.setColor(c.isEnabled() ? c.getBackground() : UIManager.getColor("Button.background"));
        if (!c.isEnabled()) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.35f));
        }
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2));
        WinIntelliJTextFieldUI.adjustInWrapperRect(r, c);
        g2.fill(r);
    }

    static void adjustInWrapperRect(Rectangle r, Component c) {
        int delta;
        if (UIUtil.getParentOfType(Wrapper.class, (Component)c) != null && WinIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c) && (delta = c.getHeight() - c.getPreferredSize().height) > 0) {
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)((delta -= delta % 2 == 0 ? 0 : 1) / 2), (int)0));
        }
    }

    @Override
    protected int getMinimumHeight(int textHeight) {
        JTextComponent c = this.getComponent();
        Insets i = c.getInsets();
        return DarculaEditorTextFieldBorder.isComboBoxEditor(c) || UIUtil.getParentOfType(JSpinner.class, (Component)c) != null ? textHeight : WinIntelliJTextBorder.MINIMUM_HEIGHT.get() + i.top + i.bottom;
    }

    @Override
    protected Icon getSearchIcon(boolean hovered, boolean clickable) {
        final Icon icon = UIManager.getIcon(clickable ? "TextField.darcula.searchWithHistory.icon" : "TextField.darcula.search.icon");
        if (icon != null && clickable) {
            return new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    icon.paintIcon(c, g, x, y + JBUI.scale((int)1));
                }

                @Override
                public int getIconWidth() {
                    return icon.getIconWidth() + JBUI.scale((int)4);
                }

                @Override
                public int getIconHeight() {
                    return icon.getIconHeight();
                }
            };
        }
        return icon != null ? icon : IconLoader.findLafIcon((String)"search", DarculaTextFieldUI.class);
    }

    @Override
    protected int getSearchIconGap() {
        return 0;
    }

    @Override
    protected Icon getClearIcon(boolean hovered, boolean clickable) {
        if (!clickable) {
            return null;
        }
        Icon icon = UIManager.getIcon("TextField.darcula.clear.icon");
        return icon != null ? icon : IconLoader.findLafIcon((String)"clear", DarculaTextFieldUI.class);
    }

    @Override
    protected Insets getDefaultMargins() {
        return JBUI.insets((int)2, (int)5);
    }

    @Override
    protected int getClearIconGap() {
        return JBUI.scale((int)3);
    }
}

