/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ProjectConversionUtil;
import com.intellij.conversion.impl.ui.ConvertProjectDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.impl.ConversionResultImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ConversionServiceImpl
extends ConversionService {
    private static final Logger LOG = Logger.getInstance(ConversionServiceImpl.class);

    @Override
    @NotNull
    public ConversionResult convertSilently(@NotNull String projectPath) {
        if (projectPath == null) {
            ConversionServiceImpl.$$$reportNull$$$0(0);
        }
        ConversionResult conversionResult = this.convertSilently(projectPath, new ConversionListener(){

            @Override
            public void conversionNeeded() {
            }

            @Override
            public void successfullyConverted(File backupDir) {
            }

            @Override
            public void error(String message) {
            }

            @Override
            public void cannotWriteToFiles(List<File> readonlyFiles) {
            }
        });
        if (conversionResult == null) {
            ConversionServiceImpl.$$$reportNull$$$0(1);
        }
        return conversionResult;
    }

    @Override
    @NotNull
    public ConversionResult convertSilently(@NotNull String projectPath, @NotNull ConversionListener listener2) {
        ConversionResultImpl conversionResultImpl;
        block13: {
            HashSet<File> affectedFiles;
            List<ConversionRunner> runners;
            ConversionContextImpl context;
            block12: {
                block11: {
                    if (projectPath == null) {
                        ConversionServiceImpl.$$$reportNull$$$0(2);
                    }
                    if (listener2 == null) {
                        ConversionServiceImpl.$$$reportNull$$$0(3);
                    }
                    if (ConversionServiceImpl.isConversionNeeded(projectPath)) break block11;
                    ConversionResultImpl conversionResultImpl2 = ConversionResultImpl.CONVERSION_NOT_NEEDED;
                    if (conversionResultImpl2 == null) {
                        ConversionServiceImpl.$$$reportNull$$$0(4);
                    }
                    return conversionResultImpl2;
                }
                listener2.conversionNeeded();
                context = new ConversionContextImpl(projectPath);
                runners = ConversionServiceImpl.getConversionRunners(context);
                affectedFiles = new HashSet<File>();
                for (ConversionRunner runner : runners) {
                    affectedFiles.addAll(runner.getAffectedFiles());
                }
                List<File> readOnlyFiles = ConversionRunner.getReadOnlyFiles(affectedFiles);
                if (readOnlyFiles.isEmpty()) break block12;
                listener2.cannotWriteToFiles(readOnlyFiles);
                ConversionResultImpl conversionResultImpl3 = ConversionResultImpl.ERROR_OCCURRED;
                if (conversionResultImpl3 == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(5);
                }
                return conversionResultImpl3;
            }
            try {
                File backupDir = ProjectConversionUtil.backupFiles(affectedFiles, context.getProjectBaseDir());
                ArrayList<ConversionRunner> usedRunners = new ArrayList<ConversionRunner>();
                for (ConversionRunner runner : runners) {
                    if (!runner.isConversionNeeded()) continue;
                    runner.preProcess();
                    runner.process();
                    runner.postProcess();
                    usedRunners.add(runner);
                }
                context.saveFiles(affectedFiles, usedRunners);
                listener2.successfullyConverted(backupDir);
                ConversionServiceImpl.saveConversionResult(context);
                conversionResultImpl = new ConversionResultImpl(runners);
                if (conversionResultImpl != null) break block13;
            }
            catch (CannotConvertException | IOException e) {
                listener2.error(e.getMessage());
                ConversionResultImpl conversionResultImpl4 = ConversionResultImpl.ERROR_OCCURRED;
                if (conversionResultImpl4 == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(7);
                }
                return conversionResultImpl4;
            }
            ConversionServiceImpl.$$$reportNull$$$0(6);
        }
        return conversionResultImpl;
    }

    @Override
    @NotNull
    public ConversionResult convert(@NotNull String projectPath) {
        block9: {
            ConversionResultImpl conversionResultImpl;
            block10: {
                block8: {
                    ConversionResultImpl conversionResultImpl2;
                    if (projectPath == null) {
                        ConversionServiceImpl.$$$reportNull$$$0(8);
                    }
                    try {
                        if (new File(projectPath).exists() && !ApplicationManager.getApplication().isHeadlessEnvironment() && ConversionServiceImpl.isConversionNeeded(projectPath)) break block8;
                        conversionResultImpl2 = ConversionResultImpl.CONVERSION_NOT_NEEDED;
                    }
                    catch (CannotConvertException e) {
                        LOG.info((Throwable)e);
                        Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.convert.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.convert.project", (Object[])new Object[0]));
                        ConversionResultImpl conversionResultImpl3 = ConversionResultImpl.ERROR_OCCURRED;
                        if (conversionResultImpl3 == null) {
                            ConversionServiceImpl.$$$reportNull$$$0(12);
                        }
                        return conversionResultImpl3;
                    }
                    if (conversionResultImpl2 == null) {
                        ConversionServiceImpl.$$$reportNull$$$0(9);
                    }
                    return conversionResultImpl2;
                }
                ConversionContextImpl context = new ConversionContextImpl(projectPath);
                List<ConversionRunner> converters2 = ConversionServiceImpl.getConversionRunners(context);
                ConvertProjectDialog dialog2 = new ConvertProjectDialog(context, converters2);
                dialog2.show();
                if (!dialog2.isConverted()) break block9;
                ConversionServiceImpl.saveConversionResult(context);
                conversionResultImpl = new ConversionResultImpl(converters2);
                if (conversionResultImpl != null) break block10;
                ConversionServiceImpl.$$$reportNull$$$0(10);
            }
            return conversionResultImpl;
        }
        ConversionResultImpl conversionResultImpl = ConversionResultImpl.CONVERSION_CANCELED;
        if (conversionResultImpl == null) {
            ConversionServiceImpl.$$$reportNull$$$0(11);
        }
        return conversionResultImpl;
    }

    private static List<ConversionRunner> getConversionRunners(ConversionContextImpl context) throws CannotConvertException {
        List<ConversionRunner> converters2 = ConversionServiceImpl.getSortedConverters(context);
        Iterator<ConversionRunner> iterator = converters2.iterator();
        HashSet<String> convertersToRunIds = new HashSet<String>();
        while (iterator.hasNext()) {
            ConversionRunner runner = iterator.next();
            boolean conversionNeeded = runner.isConversionNeeded();
            if (!conversionNeeded) {
                for (String id : runner.getProvider().getPrecedingConverterIds()) {
                    if (!convertersToRunIds.contains(id)) continue;
                    conversionNeeded = true;
                    break;
                }
            }
            if (conversionNeeded) {
                convertersToRunIds.add(runner.getProvider().getId());
                continue;
            }
            iterator.remove();
        }
        return converters2;
    }

    public static boolean isConversionNeeded(String projectPath) {
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.getSortedConverters(context);
            if (runners.isEmpty()) {
                return false;
            }
            for (ConversionRunner runner : runners) {
                if (!runner.isConversionNeeded()) continue;
                return true;
            }
            ConversionServiceImpl.saveConversionResult(context);
        }
        catch (CannotConvertException e) {
            LOG.info("Cannot check whether conversion of project files is needed or not, conversion won't be performed", (Throwable)e);
        }
        return false;
    }

    private static List<ConversionRunner> getSortedConverters(ConversionContextImpl context) {
        Set<String> performedConversionIds;
        CachedConversionResult conversionResult = ConversionServiceImpl.loadCachedConversionResult(context.getProjectFile());
        Map<String, Long> oldMap = conversionResult.myProjectFilesTimestamps;
        Map<String, Long> newMap = ConversionServiceImpl.getProjectFilesMap(context);
        boolean changed = false;
        LOG.debug("Checking project files");
        for (Map.Entry<String, Long> entry : newMap.entrySet()) {
            String path = entry.getKey();
            Long oldValue = oldMap.get(path);
            if (oldValue == null) {
                LOG.debug(" new file: " + path);
                changed = true;
                continue;
            }
            if (entry.getValue().equals(oldValue)) continue;
            LOG.debug(" changed file: " + path);
            changed = true;
        }
        if (changed) {
            performedConversionIds = Collections.emptySet();
            LOG.debug("Project files were modified.");
        } else {
            performedConversionIds = conversionResult.myAppliedConverters;
            LOG.debug("Project files are up to date. Applied converters: " + performedConversionIds);
        }
        return ConversionServiceImpl.createConversionRunners(context, performedConversionIds);
    }

    private static Map<String, Long> getProjectFilesMap(ConversionContextImpl context) {
        HashMap<String, Long> map2 = new HashMap<String, Long>();
        for (File file2 : context.getAllProjectFiles()) {
            if (!file2.exists()) continue;
            map2.put(file2.getAbsolutePath(), file2.lastModified());
        }
        return map2;
    }

    private static List<ConversionRunner> createConversionRunners(ConversionContextImpl context, Set<String> performedConversionIds) {
        ConverterProvider[] providers;
        ArrayList<ConversionRunner> runners = new ArrayList<ConversionRunner>();
        for (ConverterProvider provider : providers = (ConverterProvider[])ConverterProvider.EP_NAME.getExtensions()) {
            if (performedConversionIds.contains(provider.getId())) continue;
            runners.add(new ConversionRunner(provider, context));
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new ConverterProvidersGraph(providers)));
        DFSTBuilder builder2 = new DFSTBuilder(graph);
        if (!builder2.isAcyclic()) {
            Couple pair = builder2.getCircularDependency();
            LOG.error("cyclic dependencies between converters: " + ((ConverterProvider)pair.getFirst()).getId() + " and " + ((ConverterProvider)pair.getSecond()).getId());
        }
        Comparator comparator2 = builder2.comparator();
        Collections.sort(runners, (o1, o2) -> comparator2.compare(o1.getProvider(), o2.getProvider()));
        return runners;
    }

    @Override
    public void saveConversionResult(@NotNull String projectPath) {
        if (projectPath == null) {
            ConversionServiceImpl.$$$reportNull$$$0(13);
        }
        try {
            ConversionServiceImpl.saveConversionResult(new ConversionContextImpl(projectPath));
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
        }
    }

    private static void saveConversionResult(ConversionContextImpl context) {
        CachedConversionResult conversionResult = new CachedConversionResult();
        for (ConverterProvider provider : (ConverterProvider[])ConverterProvider.EP_NAME.getExtensions()) {
            conversionResult.myAppliedConverters.add(provider.getId());
        }
        conversionResult.myProjectFilesTimestamps = ConversionServiceImpl.getProjectFilesMap(context);
        File infoFile = ConversionServiceImpl.getConversionInfoFile(context.getProjectFile());
        FileUtil.createParentDirs((File)infoFile);
        try {
            JDOMUtil.writeDocument((Document)new Document(XmlSerializer.serialize((Object)conversionResult)), (File)infoFile, (String)SystemProperties.getLineSeparator());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private static CachedConversionResult loadCachedConversionResult(File projectFile) {
        File infoFile;
        block5: {
            CachedConversionResult cachedConversionResult;
            block6: {
                try {
                    infoFile = ConversionServiceImpl.getConversionInfoFile(projectFile);
                    if (infoFile.exists()) break block5;
                    cachedConversionResult = new CachedConversionResult();
                    if (cachedConversionResult != null) break block6;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                    CachedConversionResult cachedConversionResult2 = new CachedConversionResult();
                    if (cachedConversionResult2 == null) {
                        ConversionServiceImpl.$$$reportNull$$$0(16);
                    }
                    return cachedConversionResult2;
                }
                ConversionServiceImpl.$$$reportNull$$$0(14);
            }
            return cachedConversionResult;
        }
        CachedConversionResult cachedConversionResult = (CachedConversionResult)XmlSerializer.deserialize((Element)JDOMUtil.load((File)infoFile), CachedConversionResult.class);
        if (cachedConversionResult == null) {
            ConversionServiceImpl.$$$reportNull$$$0(15);
        }
        return cachedConversionResult;
    }

    private static File getConversionInfoFile(@NotNull File projectFile) {
        if (projectFile == null) {
            ConversionServiceImpl.$$$reportNull$$$0(17);
        }
        String dirName = PathUtil.suggestFileName((String)(projectFile.getName() + Integer.toHexString(projectFile.getAbsolutePath().hashCode())));
        return new File(PathManager.getSystemPath() + File.separator + "conversion" + File.separator + dirName + ".xml");
    }

    @Override
    @NotNull
    public ConversionResult convertModule(@NotNull Project project, @NotNull File moduleFile) {
        ConversionResultImpl conversionResultImpl;
        block15: {
            if (project == null) {
                ConversionServiceImpl.$$$reportNull$$$0(18);
            }
            if (moduleFile == null) {
                ConversionServiceImpl.$$$reportNull$$$0(19);
            }
            String url = project.getPresentableUrl();
            assert (url != null) : project;
            String projectPath = FileUtil.toSystemDependentName((String)url);
            if (!ConversionServiceImpl.isConversionNeeded(projectPath, moduleFile)) {
                ConversionResultImpl conversionResultImpl2 = ConversionResultImpl.CONVERSION_NOT_NEEDED;
                if (conversionResultImpl2 == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(20);
                }
                return conversionResultImpl2;
            }
            int res = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"message.module.file.has.an.older.format.do.you.want.to.convert.it", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (res != 0) {
                ConversionResultImpl conversionResultImpl3 = ConversionResultImpl.CONVERSION_CANCELED;
                if (conversionResultImpl3 == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(21);
                }
                return conversionResultImpl3;
            }
            if (!moduleFile.canWrite()) {
                Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.message.cannot.modify.file.0", (Object[])new Object[]{moduleFile.getAbsolutePath()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
                ConversionResultImpl conversionResultImpl4 = ConversionResultImpl.ERROR_OCCURRED;
                if (conversionResultImpl4 == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(22);
                }
                return conversionResultImpl4;
            }
            try {
                ConversionContextImpl context = new ConversionContextImpl(projectPath);
                List<ConversionRunner> runners = ConversionServiceImpl.createConversionRunners(context, Collections.emptySet());
                File backupFile = ProjectConversionUtil.backupFile(moduleFile);
                ArrayList<ConversionRunner> usedRunners = new ArrayList<ConversionRunner>();
                for (ConversionRunner runner : runners) {
                    if (!runner.isModuleConversionNeeded(moduleFile)) continue;
                    runner.convertModule(moduleFile);
                    usedRunners.add(runner);
                }
                context.saveFiles(Collections.singletonList(moduleFile), usedRunners);
                Messages.showInfoMessage((Project)project, (String)IdeBundle.message((String)"message.your.module.was.successfully.converted.br.old.version.was.saved.to.0", (Object[])new Object[]{backupFile.getAbsolutePath()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
                conversionResultImpl = new ConversionResultImpl(runners);
                if (conversionResultImpl != null) break block15;
            }
            catch (CannotConvertException e) {
                LOG.info((Throwable)e);
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)"Cannot Convert Module");
                ConversionResultImpl conversionResultImpl5 = ConversionResultImpl.ERROR_OCCURRED;
                if (conversionResultImpl5 == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(24);
                }
                return conversionResultImpl5;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ConversionResultImpl conversionResultImpl6 = ConversionResultImpl.ERROR_OCCURRED;
                if (conversionResultImpl6 == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(25);
                }
                return conversionResultImpl6;
            }
            ConversionServiceImpl.$$$reportNull$$$0(23);
        }
        return conversionResultImpl;
    }

    private static boolean isConversionNeeded(String projectPath, File moduleFile) {
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.createConversionRunners(context, Collections.emptySet());
            for (ConversionRunner runner : runners) {
                if (!runner.isModuleConversionNeeded(moduleFile)) continue;
                return true;
            }
            return false;
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/impl/ConversionServiceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/impl/ConversionServiceImpl";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSilently";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCachedConversionResult";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "convertModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertSilently";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveConversionResult";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConversionInfoFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConverterProvidersGraph
    implements InboundSemiGraph<ConverterProvider> {
        private final ConverterProvider[] myProviders;

        public ConverterProvidersGraph(ConverterProvider[] providers) {
            this.myProviders = providers;
        }

        public Collection<ConverterProvider> getNodes() {
            return Arrays.asList(this.myProviders);
        }

        public Iterator<ConverterProvider> getIn(ConverterProvider n) {
            ArrayList<ConverterProvider> preceding = new ArrayList<ConverterProvider>();
            for (String id : n.getPrecedingConverterIds()) {
                for (ConverterProvider provider : this.myProviders) {
                    if (!provider.getId().equals(id)) continue;
                    preceding.add(provider);
                }
            }
            return preceding.iterator();
        }
    }

    @Tag(value="conversion")
    public static class CachedConversionResult {
        @Tag(value="applied-converters")
        @XCollection(elementName="converter", valueAttributeName="id")
        public Set<String> myAppliedConverters = new HashSet<String>();
        @XMap(propertyElementName="project-files", entryTagName="file", keyAttributeName="path", valueAttributeName="timestamp")
        public Map<String, Long> myProjectFilesTimestamps = new HashMap<String, Long>();
    }
}

