/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static <T> T as(@Nullable Object expression, @NotNull Class<T> cls) {
        if (cls == null) {
            JsonUtil.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            return null;
        }
        if (cls.isAssignableFrom(expression.getClass())) {
            return (T)expression;
        }
        return null;
    }

    @Nullable
    public static <T extends JsonElement> T getPropertyValueOfType(@NotNull JsonObject object, @NotNull String name, @NotNull Class<T> clazz) {
        JsonProperty property;
        if (object == null) {
            JsonUtil.$$$reportNull$$$0(1);
        }
        if (name == null) {
            JsonUtil.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            JsonUtil.$$$reportNull$$$0(3);
        }
        if ((property = object.findProperty(name)) == null) {
            return null;
        }
        return (T)((JsonElement)ObjectUtils.tryCast((Object)property.getValue(), clazz));
    }

    @Nullable
    public static List<String> getChildAsStringList(@NotNull JsonObject object, @NotNull String name) {
        JsonArray array;
        if (object == null) {
            JsonUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JsonUtil.$$$reportNull$$$0(5);
        }
        if ((array = JsonUtil.getPropertyValueOfType(object, name, JsonArray.class)) != null) {
            return array.getValueList().stream().filter(value -> value instanceof JsonStringLiteral).map(value -> StringUtil.unquoteString((String)value.getText())).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsSingleStringOrList(@NotNull JsonObject object, @NotNull String name) {
        List<String> list2;
        if (object == null) {
            JsonUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            JsonUtil.$$$reportNull$$$0(7);
        }
        if ((list2 = JsonUtil.getChildAsStringList(object, name)) != null) {
            return list2;
        }
        JsonStringLiteral literal = JsonUtil.getPropertyValueOfType(object, name, JsonStringLiteral.class);
        return literal == null ? null : Collections.singletonList(StringUtil.unquoteString((String)literal.getText()));
    }

    public static boolean isArrayElement(@NotNull PsiElement element) {
        if (element == null) {
            JsonUtil.$$$reportNull$$$0(8);
        }
        return element instanceof JsonValue && element.getParent() instanceof JsonArray;
    }

    public static int getArrayIndexOfItem(@NotNull PsiElement e) {
        PsiElement parent;
        if (e == null) {
            JsonUtil.$$$reportNull$$$0(9);
        }
        if (!((parent = e.getParent()) instanceof JsonArray)) {
            return -1;
        }
        List<JsonValue> elements = ((JsonArray)parent).getValueList();
        for (int i = 0; i < elements.size(); ++i) {
            if (e != elements.get(i)) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/JsonUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "as";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyValueOfType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildAsStringList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildAsSingleStringOrList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayIndexOfItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

