/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.settings.DiffPreviewProvider;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffPreviewPanel
implements PreviewPanel {
    private final JPanel myPanel;
    private final MyViewer myViewer;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public DiffPreviewPanel() {
        this.myViewer = new MyViewer();
        this.myViewer.init();
        for (ThreeSide side : ThreeSide.values()) {
            EditorMouseListener motionListener = new EditorMouseListener(side);
            EditorClickListener clickListener = new EditorClickListener(side);
            EditorEx editor = this.myViewer.getEditor(side);
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)motionListener);
            editor.addEditorMouseListener((com.intellij.openapi.editor.event.EditorMouseListener)clickListener);
            editor.getCaretModel().addCaretListener((CaretListener)clickListener);
        }
        this.myPanel = JBUI.Panels.simplePanel((Component)this.myViewer.getComponent()).withBorder(IdeBorderFactory.createBorder());
    }

    @Override
    public Component getPanel() {
        return this.myPanel;
    }

    @Override
    public void updateView() {
        List<SimpleThreesideDiffChange> changes = this.myViewer.getChanges();
        for (SimpleThreesideDiffChange change : changes) {
            change.reinstallHighlighters();
        }
        this.myViewer.repaint();
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        for (EditorEx editorEx : this.myViewer.getEditors()) {
            editorEx.setColorsScheme(editorEx.createBoundColorSchemeDelegate(highlighterSettings));
            editorEx.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
            editorEx.reinitSettings();
        }
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            DiffPreviewPanel.$$$reportNull$$$0(0);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private void selectColorForLine(@NotNull ThreeSide side, int line) {
        SimpleThreesideDiffChange change;
        if (side == null) {
            DiffPreviewPanel.$$$reportNull$$$0(1);
        }
        if ((change = this.getChange(side, line)) != null) {
            TextDiffTypeFactory.TextDiffTypeImpl diffType = (TextDiffTypeFactory.TextDiffTypeImpl)ObjectUtils.tryCast((Object)change.getDiffType(), TextDiffTypeFactory.TextDiffTypeImpl.class);
            if (diffType != null) {
                ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(diffType.getKey().getExternalName());
            }
            return;
        }
        FoldRegion region = this.getFoldRegion(side, line);
        if (region != null) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(DiffLineSeparatorRenderer.BACKGROUND.getExternalName());
            return;
        }
    }

    private int getLineNumber(@NotNull ThreeSide side, EditorMouseEvent e) {
        if (side == null) {
            DiffPreviewPanel.$$$reportNull$$$0(2);
        }
        EditorEx editor = this.myViewer.getEditor(side);
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
        int offset = editor.logicalPositionToOffset(logicalPosition);
        return editor.getDocument().getLineNumber(offset);
    }

    @Nullable
    private SimpleThreesideDiffChange getChange(@NotNull ThreeSide side, int line) {
        if (side == null) {
            DiffPreviewPanel.$$$reportNull$$$0(3);
        }
        for (SimpleThreesideDiffChange change : this.myViewer.getChanges()) {
            int endLine;
            int startLine = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(line, startLine, endLine = change.getEndLine(side))) continue;
            return change;
        }
        return null;
    }

    @Nullable
    private FoldRegion getFoldRegion(@NotNull ThreeSide side, int line) {
        if (side == null) {
            DiffPreviewPanel.$$$reportNull$$$0(4);
        }
        EditorEx editor = this.myViewer.getEditor(side);
        DocumentEx document = editor.getDocument();
        for (FoldRegion region : editor.getFoldingModel().getAllFoldRegions()) {
            if (region.isExpanded()) continue;
            int line1 = document.getLineNumber(region.getStartOffset());
            int line2 = document.getLineNumber(region.getEndOffset());
            if (line1 > line || line > line2) continue;
            return region;
        }
        return null;
    }

    @Override
    public void blinkSelectedHighlightType(Object selected) {
    }

    @Override
    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public SimpleThreesideDiffViewer testGetViewer() {
        MyViewer myViewer = this.myViewer;
        if (myViewer == null) {
            DiffPreviewPanel.$$$reportNull$$$0(5);
        }
        return myViewer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "testGetViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectColorForLine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFoldRegion";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyViewer
    extends SimpleThreesideDiffViewer {
        public MyViewer() {
            super((DiffContext)new SampleContext(), (DiffRequest)new SampleRequest());
        }

        @Override
        protected boolean forceRediffSynchronously() {
            return true;
        }

        public void repaint() {
            this.myPanel.repaint();
        }
    }

    private class EditorClickListener
    extends EditorMouseAdapter
    implements CaretListener {
        @NotNull
        private final ThreeSide mySide;

        private EditorClickListener(ThreeSide side) {
            if (side == null) {
                EditorClickListener.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        public void mouseClicked(EditorMouseEvent e) {
            DiffPreviewPanel.this.selectColorForLine(this.mySide, DiffPreviewPanel.this.getLineNumber(this.mySide, e));
        }

        public void caretPositionChanged(CaretEvent e) {
            DiffPreviewPanel.this.selectColorForLine(this.mySide, e.getNewPosition().line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel$EditorClickListener", "<init>"));
        }
    }

    private class EditorMouseListener
    extends EditorMouseMotionAdapter {
        @NotNull
        private final ThreeSide mySide;

        private EditorMouseListener(ThreeSide side) {
            if (side == null) {
                EditorMouseListener.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        public void mouseMoved(EditorMouseEvent e) {
            int line = DiffPreviewPanel.this.getLineNumber(this.mySide, e);
            if (DiffPreviewPanel.this.getChange(this.mySide, line) != null || DiffPreviewPanel.this.getFoldRegion(this.mySide, line) != null) {
                EditorUtil.setHandCursor(e.getEditor());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel$EditorMouseListener", "<init>"));
        }
    }

    private static class SampleContext
    extends DiffContext {
        public SampleContext() {
            TextDiffSettingsHolder.TextDiffSettings settings = new TextDiffSettingsHolder.TextDiffSettings();
            settings.setHighlightPolicy(HighlightPolicy.BY_WORD);
            settings.setIgnorePolicy(IgnorePolicy.IGNORE_WHITESPACES);
            settings.setContextRange(2);
            settings.setExpandByDefault(false);
            this.putUserData(TextDiffSettingsHolder.TextDiffSettings.KEY, settings);
        }

        @Nullable
        public Project getProject() {
            return null;
        }

        public boolean isWindowFocused() {
            return false;
        }

        public boolean isFocusedInWindow() {
            return false;
        }

        public void requestFocusInWindow() {
        }
    }

    private static class SampleRequest
    extends ContentDiffRequest {
        private final List<DiffContent> myContents = Arrays.asList(DiffPreviewProvider.getContents());

        @NotNull
        public List<DiffContent> getContents() {
            List<DiffContent> list2 = this.myContents;
            if (list2 == null) {
                SampleRequest.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @NotNull
        public List<String> getContentTitles() {
            List list2 = ContainerUtil.list((Object[])new String[]{null, null, null});
            if (list2 == null) {
                SampleRequest.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Nullable
        public String getTitle() {
            return DiffBundle.message((String)"merge.color.options.dialog.title", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/diff/impl/settings/DiffPreviewPanel$SampleRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContents";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentTitles";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

