/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DelayedNotificator
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.DelayedNotificator");
    @NotNull
    private final ChangeListManagerImpl myManager;
    @NotNull
    private final EventDispatcher<ChangeListListener> myDispatcher;
    @NotNull
    private final ChangeListManagerImpl.Scheduler myScheduler;

    public DelayedNotificator(@NotNull ChangeListManagerImpl manager, @NotNull EventDispatcher<ChangeListListener> dispatcher, @NotNull ChangeListManagerImpl.Scheduler scheduler) {
        if (manager == null) {
            DelayedNotificator.$$$reportNull$$$0(0);
        }
        if (dispatcher == null) {
            DelayedNotificator.$$$reportNull$$$0(1);
        }
        if (scheduler == null) {
            DelayedNotificator.$$$reportNull$$$0(2);
        }
        this.myManager = manager;
        this.myDispatcher = dispatcher;
        this.myScheduler = scheduler;
    }

    public void callNotify(ChangeListCommand command) {
        this.myScheduler.submit(() -> {
            try {
                command.doNotify(this.myDispatcher);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        });
    }

    public void changeListAdded(ChangeList list2) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListAdded(list2));
    }

    public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changesRemoved(changes, fromList));
    }

    public void changesAdded(Collection<Change> changes, ChangeList toList) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changesAdded(changes, toList));
    }

    public void changeListRemoved(ChangeList list2) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListRemoved(list2));
    }

    public void changeListChanged(ChangeList list2) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListChanged(list2));
    }

    public void changeListRenamed(ChangeList list2, String oldName) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListRenamed(list2, oldName));
    }

    public void changeListCommentChanged(ChangeList list2, String oldComment) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListCommentChanged(list2, oldComment));
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changesMoved(changes, fromList, toList));
    }

    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).defaultListChanged(oldDefaultList, newDefaultList, automatic));
    }

    public void unchangedFileStatusChanged() {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).unchangedFileStatusChanged());
    }

    public void changeListUpdateDone() {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListUpdateDone());
    }

    public void allChangeListsMappingsChanged() {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).allChangeListsMappingsChanged());
    }

    public void changeListsForFileChanged(@NotNull FilePath path, @NotNull Set<String> removedChangeListsIds, @NotNull Set<String> addedChangeListsIds) {
        if (path == null) {
            DelayedNotificator.$$$reportNull$$$0(3);
        }
        if (removedChangeListsIds == null) {
            DelayedNotificator.$$$reportNull$$$0(4);
        }
        if (addedChangeListsIds == null) {
            DelayedNotificator.$$$reportNull$$$0(5);
        }
        this.myScheduler.submit(() -> {
            LocalChangeList changeList;
            Change change;
            if (path == null) {
                DelayedNotificator.$$$reportNull$$$0(6);
            }
            if (removedChangeListsIds == null) {
                DelayedNotificator.$$$reportNull$$$0(7);
            }
            if (addedChangeListsIds == null) {
                DelayedNotificator.$$$reportNull$$$0(8);
            }
            if ((change = this.myManager.getChange(path)) == null) {
                return;
            }
            List<Change> changes = Collections.singletonList(change);
            for (String listId : removedChangeListsIds) {
                changeList = this.myManager.getChangeList(listId);
                if (changeList == null) continue;
                ((ChangeListListener)this.myDispatcher.getMulticaster()).changesRemoved(changes, (ChangeList)changeList);
            }
            for (String listId : addedChangeListsIds) {
                changeList = this.myManager.getChangeList(listId);
                if (changeList == null) continue;
                ((ChangeListListener)this.myDispatcher.getMulticaster()).changesAdded(changes, (ChangeList)changeList);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheduler";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedChangeListsIds";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedChangeListsIds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/DelayedNotificator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "changeListsForFileChanged";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$changeListsForFileChanged$13";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

