/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchedFileHolder
extends RecursiveFileHolder<Pair<Boolean, String>> {
    public SwitchedFileHolder(Project project, FileHolder.HolderType holderType) {
        super(project, holderType);
    }

    @Override
    public synchronized SwitchedFileHolder copy() {
        SwitchedFileHolder copyHolder = new SwitchedFileHolder(this.myProject, this.myHolderType);
        copyHolder.myMap.putAll(this.myMap);
        return copyHolder;
    }

    @Override
    protected boolean isFileDirty(VcsDirtyScope scope, VirtualFile file2) {
        if (scope == null) {
            return true;
        }
        if (this.fileDropped(file2)) {
            return true;
        }
        return scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file2));
    }

    private boolean fileDropped(VirtualFile file2) {
        return !file2.isValid() || this.myVcsManager.getVcsFor(file2) == null;
    }

    public Map<VirtualFile, String> getFilesMapCopy() {
        HashMap<VirtualFile, String> result2 = new HashMap<VirtualFile, String>();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.put(vf, (String)((Pair)this.myMap.get(vf)).getSecond());
        }
        return result2;
    }

    public void addFile(VirtualFile file2, String branch, boolean recursive) {
        this.myMap.put(file2, new Pair((Object)recursive, (Object)branch));
    }

    public synchronized MultiMap<String, VirtualFile> getBranchToFileMap() {
        MultiMap result2 = new MultiMap();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.putValue(((Pair)this.myMap.get(vf)).getSecond(), (Object)vf);
        }
        return result2;
    }

    @Override
    public synchronized boolean containsFile(@NotNull VirtualFile file2) {
        VirtualFile floor;
        if (file2 == null) {
            SwitchedFileHolder.$$$reportNull$$$0(0);
        }
        if ((floor = this.myMap.floorKey(file2)) == null) {
            return false;
        }
        NavigableMap floorMap = this.myMap.headMap(floor, true);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)false)) continue;
            Pair value = (Pair)floorMap.get(parent);
            return parent.equals(file2) || (Boolean)value.getFirst() != false;
        }
        return false;
    }

    @Nullable
    public String getBranchForFile(VirtualFile file2) {
        VirtualFile floor = this.myMap.floorKey(file2);
        if (floor == null) {
            return null;
        }
        SortedMap floorMap = this.myMap.headMap(floor);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)false)) continue;
            return (String)((Pair)floorMap.get(parent)).getSecond();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/SwitchedFileHolder", "containsFile"));
    }
}

