/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.CommonBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.SaveProjectAsTemplateDialog;
import com.intellij.project.ProjectKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveProjectAsTemplateAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(SaveProjectAsTemplateAction.class);
    private static final String PROJECT_TEMPLATE_XML = "project-template.xml";
    static final String FILE_HEADER_TEMPLATE_PLACEHOLDER = "<IntelliJ_File_Header>";

    public void actionPerformed(AnActionEvent e) {
        final Project project = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        if (!ProjectKt.isDirectoryBased(project)) {
            Messages.showErrorDialog((Project)project, (String)"Project templates do not support old .ipr (file-based) format.\nPlease convert your project via File->Save as Directory-Based format.", (String)CommonBundle.getErrorTitle());
            return;
        }
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project, ".idea/description.html");
        final SaveProjectAsTemplateDialog dialog2 = new SaveProjectAsTemplateDialog(project, descriptionFile);
        if (dialog2.showAndGet()) {
            final Module moduleToSave = dialog2.getModuleToSave();
            final Path file2 = dialog2.getTemplateFile();
            final String description = dialog2.getDescription();
            FileDocumentManager.getInstance().saveAllDocuments();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Saving Project as Template", true, PerformInBackgroundOption.DEAF){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SaveProjectAsTemplateAction.saveProject(project, file2, moduleToSave, description, dialog2.isReplaceParameters(), indicator, SaveProjectAsTemplateAction.shouldEscape());
                }

                public void onSuccess() {
                    Messages.showInfoMessage((String)(FileUtil.getNameWithoutExtension((String)file2.getFileName().toString()) + " was successfully created.\nIt's available now in Project Wizard"), (String)"Template Created");
                }

                public void onCancel() {
                    PathKt.delete((Path)file2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/platform/templates/SaveProjectAsTemplateAction$1", "run"));
                }
            });
        }
    }

    public static VirtualFile getDescriptionFile(Project project, String path) {
        VirtualFile baseDir = project.getBaseDir();
        return baseDir != null ? baseDir.findFileByRelativePath(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveProject(Project project, @NotNull Path zipFile, Module moduleToSave, String description, boolean replaceParameters, ProgressIndicator indicator, boolean shouldEscape) {
        if (zipFile == null) {
            SaveProjectAsTemplateAction.$$$reportNull$$$0(0);
        }
        Map<String, String> parameters2 = SaveProjectAsTemplateAction.computeParameters(project, replaceParameters);
        indicator.setText("Saving project...");
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project instanceof ProjectImpl) {
                ((ProjectImpl)project).save(true);
            } else {
                project.save();
            }
        });
        indicator.setText("Processing project files...");
        ZipOutputStream stream = null;
        try {
            stream = new ZipOutputStream(PathKt.outputStream((Path)zipFile));
            VirtualFile dir = SaveProjectAsTemplateAction.getDirectoryToSave(project, moduleToSave);
            List<LocalArchivedTemplate.RootDescription> roots = SaveProjectAsTemplateAction.collectStructure(project, moduleToSave);
            LocalArchivedTemplate.RootDescription basePathRoot = SaveProjectAsTemplateAction.findOrAddBaseRoot(roots, dir);
            SaveProjectAsTemplateAction.writeFile(".idea/description.html", description, project, basePathRoot.myRelativePath, stream, true);
            if (replaceParameters) {
                String text2 = SaveProjectAsTemplateAction.getInputFieldsText(parameters2);
                SaveProjectAsTemplateAction.writeFile(".idea/project-template.xml", text2, project, basePathRoot.myRelativePath, stream, false);
            }
            String metaDescription = SaveProjectAsTemplateAction.getTemplateMetaText(shouldEscape, roots);
            SaveProjectAsTemplateAction.writeFile(".idea/template-meta.xml", metaDescription, project, basePathRoot.myRelativePath, stream, true);
            ProjectFileIndex index = moduleToSave == null ? ProjectRootManager.getInstance((Project)project).getFileIndex() : ModuleRootManager.getInstance((Module)moduleToSave).getFileIndex();
            ZipOutputStream finalStream = stream;
            MyContentIterator iterator = new MyContentIterator(indicator, finalStream, project, parameters2, shouldEscape);
            for (LocalArchivedTemplate.RootDescription root : roots) {
                String prefix = "root" + root.myIndex;
                VirtualFile rootFile = root.myFile;
                iterator.setRootAndPrefix(rootFile, prefix);
                index.iterateContentUnderDirectory(rootFile, (ContentIterator)iterator);
            }
        }
        catch (ProcessCanceledException dir) {
            StreamUtil.closeStream(stream);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project, (String)"Can't save project as template", (String)"Internal Error"));
            {
                catch (Throwable throwable) {
                    StreamUtil.closeStream(stream);
                    throw throwable;
                }
            }
            StreamUtil.closeStream((Closeable)stream);
        }
        StreamUtil.closeStream((Closeable)stream);
    }

    private static LocalArchivedTemplate.RootDescription findOrAddBaseRoot(List<LocalArchivedTemplate.RootDescription> roots, VirtualFile dirToSave) {
        for (LocalArchivedTemplate.RootDescription root : roots) {
            if (!root.myRelativePath.isEmpty()) continue;
            return root;
        }
        LocalArchivedTemplate.RootDescription root = new LocalArchivedTemplate.RootDescription(dirToSave, "", roots.size());
        roots.add(root);
        return root;
    }

    static String getFileHeaderTemplateName() {
        if (PlatformUtils.isIntelliJ()) {
            return FileTemplateBase.getQualifiedName("File Header", "java");
        }
        if (PlatformUtils.isPhpStorm()) {
            return FileTemplateBase.getQualifiedName("PHP File Header", "php");
        }
        throw new IllegalStateException("Provide file header template for your IDE");
    }

    private static void writeFile(String path, String text2, Project project, String prefix, ZipOutputStream stream, boolean overwrite) throws IOException {
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project, path);
        if (descriptionFile == null) {
            stream.putNextEntry(new ZipEntry(prefix + "/" + path));
            stream.write(text2.getBytes());
            stream.closeEntry();
        } else if (overwrite) {
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
                try {
                    VfsUtil.saveText((VirtualFile)descriptionFile, (String)text2);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }));
        }
    }

    public static Map<String, String> computeParameters(Project project, boolean replaceParameters) {
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        if (replaceParameters) {
            ApplicationManager.getApplication().runReadAction(() -> {
                ProjectTemplateParameterFactory[] extensions;
                for (ProjectTemplateParameterFactory extension : extensions = (ProjectTemplateParameterFactory[])Extensions.getExtensions((ExtensionPointName)ProjectTemplateParameterFactory.EP_NAME)) {
                    String value = extension.detectParameterValue(project);
                    if (value == null) continue;
                    parameters2.put(value, extension.getParameterId());
                }
            });
        }
        return parameters2;
    }

    public static String getEncodedContent(VirtualFile virtualFile, Project project, Map<String, String> parameters2) throws IOException {
        return SaveProjectAsTemplateAction.getEncodedContent(virtualFile, project, parameters2, FileTemplateBase.getQualifiedName("File Header", "java"), true);
    }

    private static String getEncodedContent(VirtualFile virtualFile, Project project, Map<String, String> parameters2, String fileHeaderTemplateName, boolean shouldEscape) throws IOException {
        String text2 = VfsUtilCore.loadText((VirtualFile)virtualFile);
        FileTemplate template = FileTemplateManager.getInstance(project).getDefaultTemplate(fileHeaderTemplateName);
        String templateText = template.getText();
        Pattern pattern = FileTemplateUtil.getTemplatePattern(template, project, (TIntObjectHashMap<String>)new TIntObjectHashMap());
        String result2 = SaveProjectAsTemplateAction.convertTemplates(text2, pattern, templateText, shouldEscape);
        result2 = ProjectTemplateFileProcessor.encodeFile(result2, virtualFile, project);
        for (Map.Entry<String, String> entry : parameters2.entrySet()) {
            result2 = result2.replace(entry.getKey(), "${" + entry.getValue() + "}");
        }
        return result2;
    }

    private static VirtualFile getDirectoryToSave(Project project, @Nullable Module module2) {
        if (module2 == null) {
            return project.getBaseDir();
        }
        VirtualFile moduleFile = module2.getModuleFile();
        assert (moduleFile != null);
        return moduleFile.getParent();
    }

    @NotNull
    private static List<LocalArchivedTemplate.RootDescription> collectStructure(Project project, Module moduleToSave) {
        ArrayList<LocalArchivedTemplate.RootDescription> result2 = new ArrayList<LocalArchivedTemplate.RootDescription>();
        if (moduleToSave != null) {
            PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)moduleToSave);
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)moduleToSave);
            int i = 0;
            for (VirtualFile file2 : rootManager.getContentRoots()) {
                result2.add(i, SaveProjectAsTemplateAction.describeRoot(file2, i, macroManager));
                ++i;
            }
        } else {
            PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project);
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            int i = 0;
            for (VirtualFile file3 : rootManager.getContentRoots()) {
                result2.add(i, SaveProjectAsTemplateAction.describeRoot(file3, i, macroManager));
                ++i;
            }
        }
        ArrayList<LocalArchivedTemplate.RootDescription> arrayList = result2;
        if (arrayList == null) {
            SaveProjectAsTemplateAction.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static LocalArchivedTemplate.RootDescription describeRoot(VirtualFile root, int rootIndex, PathMacroManager pathMacroManager) {
        return new LocalArchivedTemplate.RootDescription(root, SaveProjectAsTemplateAction.getRelativePath(pathMacroManager, root), rootIndex);
    }

    private static String getRelativePath(PathMacroManager pathMacroManager, VirtualFile moduleRoot) {
        String path = pathMacroManager.collapsePath(moduleRoot.getPath());
        path = StringUtil.trimStart((String)path, (String)"$PROJECT_DIR$");
        path = StringUtil.trimStart((String)path, (String)"$MODULE_DIR$");
        path = StringUtil.trimStart((String)path, (String)"/");
        return path;
    }

    public static String convertTemplates(String input, Pattern pattern, String template, boolean shouldEscape) {
        int start;
        Matcher matcher = pattern.matcher(input);
        int n = start = matcher.matches() ? matcher.start(1) : -1;
        if (!shouldEscape) {
            if (start == -1) {
                return input;
            }
            return input.substring(0, start) + FILE_HEADER_TEMPLATE_PLACEHOLDER + input.substring(matcher.end(1));
        }
        StringBuilder builder2 = new StringBuilder(input.length() + 10);
        for (int i = 0; i < input.length(); ++i) {
            char c;
            if (start == i) {
                builder2.append(template);
                i = matcher.end(1);
            }
            if ((c = input.charAt(i)) == '$' || c == '#') {
                builder2.append('\\');
            }
            builder2.append(c);
        }
        return builder2.toString();
    }

    private static String getInputFieldsText(Map<String, String> parameters2) {
        Element element = new Element("template");
        for (Map.Entry<String, String> entry : parameters2.entrySet()) {
            Element field = new Element("input-field");
            field.setText(entry.getValue());
            field.setAttribute("default", entry.getKey());
            element.addContent(field);
        }
        return JDOMUtil.writeElement((Element)element);
    }

    private static String getTemplateMetaText(boolean shouldEncode, List<LocalArchivedTemplate.RootDescription> roots) {
        Element element = new Element("template");
        element.setAttribute("unencoded", String.valueOf(!shouldEncode));
        LocalArchivedTemplate.RootDescription.writeRoots(element, roots);
        return JDOMUtil.writeElement((Element)element);
    }

    private static boolean shouldEscape() {
        return !PlatformUtils.isPhpStorm();
    }

    public void update(AnActionEvent e) {
        Project project = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabled(project != null && !project.isDefault());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/SaveProjectAsTemplateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/SaveProjectAsTemplateAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveProject";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyContentIterator
    implements ContentIterator {
        private final ProgressIndicator myIndicator;
        private VirtualFile myRootDir;
        private String myPrefix;
        private final ZipOutputStream myFinalStream;
        private final Project myProject;
        private final Map<String, String> myParameters;
        private final boolean myShouldEscape;

        public MyContentIterator(ProgressIndicator indicator, ZipOutputStream finalStream, Project project, Map<String, String> parameters2, boolean shouldEscape) {
            this.myIndicator = indicator;
            this.myFinalStream = finalStream;
            this.myProject = project;
            this.myParameters = parameters2;
            this.myShouldEscape = shouldEscape;
        }

        public void setRootAndPrefix(VirtualFile root, String prefix) {
            this.myRootDir = root;
            this.myPrefix = prefix;
        }

        public boolean processFile(final VirtualFile virtualFile) {
            if (!virtualFile.isDirectory()) {
                String fileName = virtualFile.getName();
                this.myIndicator.setText2(fileName);
                try {
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)this.myRootDir, (char)'/');
                    if (relativePath == null) {
                        throw new RuntimeException("Can't find relative path for " + virtualFile + " in " + this.myRootDir);
                    }
                    boolean system = ".idea".equals(virtualFile.getParent().getName());
                    if (!(!system || fileName.equals("description.html") || fileName.equals(SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML) || fileName.equals("template-meta.xml") || fileName.equals("misc.xml") || fileName.equals("modules.xml") || fileName.equals("workspace.xml") || fileName.endsWith(".iml"))) {
                        return true;
                    }
                    ZipUtil.addFileToZip((ZipOutputStream)this.myFinalStream, (File)new File(virtualFile.getPath()), (String)(this.myPrefix + "/" + relativePath), null, null, (ZipUtil.FileContentProcessor)new ZipUtil.FileContentProcessor(){

                        public InputStream getContent(File file2) throws IOException {
                            if (virtualFile.getFileType().isBinary() || SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML.equals(virtualFile.getName())) {
                                return STANDARD.getContent(file2);
                            }
                            String result2 = SaveProjectAsTemplateAction.getEncodedContent(virtualFile, myProject, myParameters, SaveProjectAsTemplateAction.getFileHeaderTemplateName(), myShouldEscape);
                            return new ByteArrayInputStream(result2.getBytes(CharsetToolkit.UTF8_CHARSET));
                        }
                    });
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            this.myIndicator.checkCanceled();
            return true;
        }
    }
}

