/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class TimeStampedIndentOptions
extends CommonCodeStyleSettings.IndentOptions {
    private long myTimeStamp;
    private int myOriginalIndentOptionsHash;

    protected TimeStampedIndentOptions(CommonCodeStyleSettings.IndentOptions toCopyFrom, long timeStamp) {
        this.copyFrom(toCopyFrom);
        this.myTimeStamp = timeStamp;
        this.myOriginalIndentOptionsHash = toCopyFrom.hashCode();
    }

    void setTimeStamp(long timeStamp) {
        this.myTimeStamp = timeStamp;
    }

    public void setOriginalIndentOptionsHash(int originalIndentOptionsHash) {
        this.myOriginalIndentOptionsHash = originalIndentOptionsHash;
    }

    public boolean isOutdated(@NotNull Document document, @NotNull CommonCodeStyleSettings.IndentOptions defaultForFile) {
        if (document == null) {
            TimeStampedIndentOptions.$$$reportNull$$$0(0);
        }
        if (defaultForFile == null) {
            TimeStampedIndentOptions.$$$reportNull$$$0(1);
        }
        return document.getModificationStamp() != this.myTimeStamp || defaultForFile.hashCode() != this.myOriginalIndentOptionsHash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "defaultForFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/codeStyle/TimeStampedIndentOptions";
        objectArray[2] = "isOutdated";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

