/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoTooltipManager;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class DependencyMemberInfoModel<T extends PsiElement, M extends MemberInfoBase<T>>
implements MemberInfoModel<T, M> {
    protected MemberDependencyGraph<T, M> myMemberDependencyGraph;
    private final int myProblemLevel;
    private MemberInfoTooltipManager myTooltipManager;

    public DependencyMemberInfoModel(MemberDependencyGraph<T, M> memberDependencyGraph, int problemLevel) {
        this.myMemberDependencyGraph = memberDependencyGraph;
        this.myProblemLevel = problemLevel;
    }

    public void setTooltipProvider(MemberInfoTooltipManager.TooltipProvider<T, M> tooltipProvider) {
        this.myTooltipManager = new MemberInfoTooltipManager<T, M>(tooltipProvider);
    }

    public boolean isAbstractEnabled(M member) {
        return true;
    }

    public boolean isAbstractWhenDisabled(M member) {
        return false;
    }

    public boolean isMemberEnabled(M member) {
        return true;
    }

    public int checkForProblems(@NotNull M memberInfo) {
        if (memberInfo == null) {
            DependencyMemberInfoModel.$$$reportNull$$$0(0);
        }
        if (memberInfo.isChecked()) {
            return 0;
        }
        PsiElement member = memberInfo.getMember();
        if (this.myMemberDependencyGraph.getDependent().contains(member)) {
            return this.myProblemLevel;
        }
        return 0;
    }

    public void setMemberDependencyGraph(MemberDependencyGraph<T, M> memberDependencyGraph) {
        this.myMemberDependencyGraph = memberDependencyGraph;
    }

    public void memberInfoChanged(MemberInfoChange<T, M> event) {
        this.memberInfoChanged(event.getChangedMembers());
    }

    public void memberInfoChanged(Collection<M> changedMembers) {
        if (this.myTooltipManager != null) {
            this.myTooltipManager.invalidate();
        }
        for (MemberInfoBase changedMember : changedMembers) {
            this.myMemberDependencyGraph.memberChanged(changedMember);
        }
    }

    public String getTooltipText(M member) {
        if (this.myTooltipManager != null) {
            return this.myTooltipManager.getTooltip(member);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfo", "com/intellij/refactoring/classMembers/DependencyMemberInfoModel", "checkForProblems"));
    }
}

