/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.lang.LanguageDependentMembersRefactoringSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.MemberDependenciesStorage;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class UsesMemberDependencyGraph<T extends NavigatablePsiElement, C extends PsiElement, M extends MemberInfoBase<T>>
implements MemberDependencyGraph<T, M> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.classMembers.UsesMemberDependencyGraph");
    protected HashSet<T> mySelectedNormal;
    protected HashSet<T> mySelectedAbstract;
    protected HashSet<T> myDependencies = null;
    protected HashMap<T, HashSet<T>> myDependenciesToDependentMap = null;
    private final boolean myRecursive;
    private final MemberDependenciesStorage<T, C> myMemberDependenciesStorage;

    public UsesMemberDependencyGraph(C aClass, C superClass, boolean recursive) {
        this.myRecursive = recursive;
        this.mySelectedNormal = new HashSet();
        this.mySelectedAbstract = new HashSet();
        this.myMemberDependenciesStorage = new MemberDependenciesStorage(aClass, superClass);
    }

    public Set<? extends T> getDependent() {
        if (this.myDependencies == null) {
            this.myDependencies = new HashSet();
            this.myDependenciesToDependentMap = new HashMap();
            this.buildDeps(null, this.mySelectedNormal);
        }
        return this.myDependencies;
    }

    public Set<? extends T> getDependenciesOf(T member) {
        Set<T> dependent = this.getDependent();
        if (!dependent.contains(member)) {
            return null;
        }
        return this.myDependenciesToDependentMap.get(member);
    }

    public String getElementTooltip(T element) {
        Set<T> dependencies = this.getDependenciesOf(element);
        if (dependencies == null || dependencies.size() == 0) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (NavigatablePsiElement dep : dependencies) {
            strings.add(dep.getName());
        }
        if (strings.isEmpty()) {
            return null;
        }
        return RefactoringBundle.message((String)"used.by.0", (Object[])new Object[]{StringUtil.join(strings, (String)", ")});
    }

    private void buildDeps(T sourceElement, Set<T> members) {
        if (this.myRecursive) {
            this.buildDepsRecursively(sourceElement, members);
        } else {
            for (NavigatablePsiElement member : members) {
                Set<NavigatablePsiElement> dependencies = this.myMemberDependenciesStorage.getMemberDependencies(member);
                if (dependencies == null) continue;
                for (NavigatablePsiElement dependency : dependencies) {
                    this.addDependency(dependency, member);
                }
            }
        }
    }

    private void buildDepsRecursively(T sourceElement, @Nullable Set<T> members) {
        if (members != null) {
            for (NavigatablePsiElement member : members) {
                if (this.myDependencies.contains(member)) continue;
                this.addDependency(member, sourceElement);
                if (this.mySelectedAbstract.contains(member)) continue;
                this.buildDepsRecursively(member, this.myMemberDependenciesStorage.getMemberDependencies(member));
            }
        }
    }

    private void addDependency(T member, T sourceElement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(member.toString());
        }
        this.myDependencies.add(member);
        if (sourceElement != null) {
            HashSet<Object> relations = this.myDependenciesToDependentMap.get(member);
            if (relations == null) {
                relations = new HashSet();
                this.myDependenciesToDependentMap.put(member, relations);
            }
            relations.add(sourceElement);
        }
    }

    public void memberChanged(M memberInfo) {
        ClassMembersRefactoringSupport support = (ClassMembersRefactoringSupport)LanguageDependentMembersRefactoringSupport.INSTANCE.forLanguage(((NavigatablePsiElement)memberInfo.getMember()).getLanguage());
        if (support != null && support.isProperMember(memberInfo)) {
            this.myDependencies = null;
            this.myDependenciesToDependentMap = null;
            NavigatablePsiElement member = (NavigatablePsiElement)memberInfo.getMember();
            if (!memberInfo.isChecked()) {
                this.mySelectedNormal.remove(member);
                this.mySelectedAbstract.remove(member);
            } else if (memberInfo.isToAbstract()) {
                this.mySelectedNormal.remove(member);
                this.mySelectedAbstract.add(member);
            } else {
                this.mySelectedNormal.add(member);
                this.mySelectedAbstract.remove(member);
            }
        }
    }
}

