/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportCandidateHolder
implements Comparable<ImportCandidateHolder> {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> myImportable;
    @Nullable
    private final SmartPsiElementPointer<PyImportElement> myImportElement;
    @NotNull
    private final SmartPsiElementPointer<PsiFileSystemItem> myFile;
    @Nullable
    private final QualifiedName myPath;
    @Nullable
    private final String myAsName;

    public ImportCandidateHolder(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file2, @Nullable PyImportElement importElement, @Nullable QualifiedName path, @Nullable String asName) {
        if (importable == null) {
            ImportCandidateHolder.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ImportCandidateHolder.$$$reportNull$$$0(1);
        }
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)importable.getProject());
        this.myFile = pointerManager.createSmartPsiElementPointer((PsiElement)file2);
        this.myImportable = pointerManager.createSmartPsiElementPointer(importable);
        this.myImportElement = importElement != null ? pointerManager.createSmartPsiElementPointer((PsiElement)importElement) : null;
        this.myPath = path;
        this.myAsName = asName;
        assert (importElement != null || path != null);
    }

    public ImportCandidateHolder(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file2, @Nullable PyImportElement importElement, @Nullable QualifiedName path) {
        if (importable == null) {
            ImportCandidateHolder.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ImportCandidateHolder.$$$reportNull$$$0(3);
        }
        this(importable, file2, importElement, path, null);
    }

    @Nullable
    public PsiElement getImportable() {
        return this.myImportable.getElement();
    }

    @Nullable
    public PyImportElement getImportElement() {
        return this.myImportElement != null ? (PyImportElement)this.myImportElement.getElement() : null;
    }

    @Nullable
    public PsiFileSystemItem getFile() {
        return (PsiFileSystemItem)this.myFile.getElement();
    }

    @Nullable
    public QualifiedName getPath() {
        return this.myPath;
    }

    @NotNull
    public static String getQualifiedName(@NotNull String name, @Nullable QualifiedName importPath, @Nullable PyImportElement source) {
        if (name == null) {
            ImportCandidateHolder.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder();
        if (source != null) {
            PsiElement parent = source.getParent();
            if (parent instanceof PyFromImportStatement) {
                sb.append(name);
            } else {
                sb.append(source.getVisibleName()).append(".").append(name);
            }
        } else {
            if (importPath != null && importPath.getComponentCount() > 0) {
                sb.append(importPath).append(".");
            }
            sb.append(name);
        }
        String string = sb.toString();
        if (string == null) {
            ImportCandidateHolder.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getPresentableText(@NotNull String myName) {
        List supers;
        if (myName == null) {
            ImportCandidateHolder.$$$reportNull$$$0(6);
        }
        PyImportElement importElement = this.getImportElement();
        PsiElement importable = this.getImportable();
        StringBuilder sb = new StringBuilder(ImportCandidateHolder.getQualifiedName(myName, this.myPath, importElement));
        PsiElement parent = null;
        if (importElement != null) {
            parent = importElement.getParent();
        }
        if (importable instanceof PyFunction) {
            sb.append("()");
        } else if (importable instanceof PyClass && !(supers = ContainerUtil.mapNotNull((Object[])((PyClass)importable).getSuperClasses(null), cls -> PyUtil.isObjectClass(cls) ? null : cls.getName())).isEmpty()) {
            sb.append("(");
            StringUtil.join((Collection)supers, (String)", ", (StringBuilder)sb);
            sb.append(")");
        }
        if (parent instanceof PyFromImportStatement) {
            sb.append(" from ");
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)parent;
            sb.append(StringUtil.repeat((String)".", (int)fromImportStatement.getRelativeLevel()));
            PyReferenceExpression source = fromImportStatement.getImportSource();
            if (source != null) {
                sb.append(source.asQualifiedName());
            }
        }
        String string = sb.toString();
        if (string == null) {
            ImportCandidateHolder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull ImportCandidateHolder other) {
        int lengthDiff;
        if (other == null) {
            ImportCandidateHolder.$$$reportNull$$$0(8);
        }
        int lRelevance = this.getRelevance();
        int rRelevance = other.getRelevance();
        if (rRelevance != lRelevance) {
            return rRelevance - lRelevance;
        }
        if (this.myPath != null && other.myPath != null && (lengthDiff = this.myPath.getComponentCount() - other.myPath.getComponentCount()) != 0) {
            return lengthDiff;
        }
        return Comparing.compare((Comparable)this.myPath, (Comparable)other.myPath);
    }

    int getRelevance() {
        VirtualFile vFile;
        if (this.myImportElement != null) {
            return 4;
        }
        Project project = this.myImportable.getProject();
        PsiFile psiFile = this.myImportable.getContainingFile();
        VirtualFile virtualFile = vFile = psiFile == null ? null : psiFile.getVirtualFile();
        if (vFile == null) {
            return 0;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module2 = fileIndex.getModuleForFile(vFile);
        if (module2 != null) {
            return 3;
        }
        if (vFile.getParent().getName().equals("Lib")) {
            return 2;
        }
        if (vFile.getParent().getName().equals("test")) {
            return 0;
        }
        return 1;
    }

    @Nullable
    public String getAsName() {
        return this.myAsName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

