/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.fstrings.PyFStringAwareRecursiveVisitor;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMakeFunctionFromMethodQuickFix;
import com.jetbrains.python.inspections.quickfix.PyMakeMethodStaticQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodMayBeStaticInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.method.may.be.static", new Object[0]);
        if (string == null) {
            PyMethodMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyMethodMayBeStaticInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyMethodMayBeStaticInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyMethodMayBeStaticInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static boolean isTestElement(@NotNull PyFunction node) {
        if (node == null) {
            PyMethodMayBeStaticInspection.$$$reportNull$$$0(4);
        }
        String methodName = node.getName();
        PyClass pyClass = node.getContainingClass();
        String className = pyClass == null ? null : pyClass.getName();
        return methodName != null && className != null && methodName.toLowerCase(Locale.getDefault()).startsWith("test") && className.toLowerCase(Locale.getDefault()).startsWith("test");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMethodMayBeStaticInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMethodMayBeStaticInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTestElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            String name;
            if (PyNames.getBuiltinMethods(LanguageLevel.forElement(node)).containsKey((Object)node.getName())) {
                return;
            }
            PyClass containingClass = node.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiElement firstSuper = (PsiElement)PySuperMethodsSearch.search(node, this.myTypeEvalContext).findFirst();
            if (firstSuper != null) {
                return;
            }
            PyFunction firstOverride = (PyFunction)PyOverridingMethodsSearch.search(node, true).findFirst();
            if (firstOverride != null) {
                return;
            }
            PyDecoratorList decoratorList = node.getDecoratorList();
            if (decoratorList != null) {
                return;
            }
            if (node.getModifier() != null) {
                return;
            }
            Property property = containingClass.findPropertyByCallable(node);
            if (property != null) {
                return;
            }
            List<PyAssignmentStatement> attributes = node.findAttributes();
            if (!attributes.isEmpty()) {
                return;
            }
            if (PyMethodMayBeStaticInspection.isTestElement(node)) {
                return;
            }
            if (PyUtil.isEmptyFunction(node)) {
                return;
            }
            PyParameter[] parameters2 = node.getParameterList().getParameters();
            final String selfName = parameters2.length > 0 ? ((name = parameters2[0].getName()) != null ? name : parameters2[0].getText()) : "self";
            final boolean[] mayBeStatic = new boolean[]{true};
            PyFStringAwareRecursiveVisitor visitor2 = new PyFStringAwareRecursiveVisitor(){

                @Override
                public void visitPyRaiseStatement(PyRaiseStatement node) {
                    super.visitPyRaiseStatement(node);
                    PyExpression[] expressions = node.getExpressions();
                    if (expressions.length == 1) {
                        PyExpression expression = expressions[0];
                        if (expression instanceof PyCallExpression) {
                            PyExpression callee = ((PyCallExpression)expression).getCallee();
                            if (callee != null && "NotImplementedError".equals(callee.getText())) {
                                mayBeStatic[0] = false;
                            }
                        } else if ("NotImplementedError".equals(expression.getText())) {
                            mayBeStatic[0] = false;
                        }
                    }
                }

                @Override
                public void visitPyReferenceExpression(PyReferenceExpression node) {
                    if (node.isQualified()) {
                        super.visitPyReferenceExpression(node);
                    } else if (selfName.equals(node.getName())) {
                        mayBeStatic[0] = false;
                    }
                }

                @Override
                public void visitPyCallExpression(PyCallExpression node) {
                    super.visitPyCallExpression(node);
                    if (!LanguageLevel.forElement((PsiElement)node).isPython2() && node.isCalleeText("super")) {
                        mayBeStatic[0] = false;
                    }
                }
            };
            node.accept(visitor2);
            PsiElement identifier = node.getNameIdentifier();
            if (mayBeStatic[0] && identifier != null) {
                this.registerProblem(identifier, PyBundle.message("INSP.method.may.be.static", new Object[0]), ProblemHighlightType.WEAK_WARNING, null, new PyMakeMethodStaticQuickFix(), new PyMakeFunctionFromMethodQuickFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodMayBeStaticInspection$Visitor", "<init>"));
        }
    }
}

