/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.psi.LanguageLevel;

public class PythonHighlightingLexer
extends PythonLexer {
    private final LanguageLevel myLanguageLevel;
    private state myState = state.init;
    private boolean hasUnicodeImport = false;
    private int myImportOffset = -1;

    public PythonHighlightingLexer(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
        this.hasUnicodeImport = false;
    }

    public static IElementType convertStringType(IElementType tokenType, String tokenText, LanguageLevel languageLevel, boolean unicodeImport) {
        if (tokenType == PyTokenTypes.SINGLE_QUOTED_STRING && (languageLevel.isPy3K() ? !tokenText.toLowerCase().startsWith("b") : unicodeImport && !tokenText.toLowerCase().startsWith("b") || tokenText.toLowerCase().startsWith("u"))) {
            return PyTokenTypes.SINGLE_QUOTED_UNICODE;
        }
        if (tokenType == PyTokenTypes.TRIPLE_QUOTED_STRING && (languageLevel.isPy3K() ? !tokenText.toLowerCase().startsWith("b") : unicodeImport && !tokenText.toLowerCase().startsWith("b") || tokenText.toLowerCase().startsWith("u"))) {
            return PyTokenTypes.TRIPLE_QUOTED_UNICODE;
        }
        return tokenType;
    }

    public IElementType convertStringType(IElementType tokenType, String tokenText) {
        return PythonHighlightingLexer.convertStringType(tokenType, tokenText, this.myLanguageLevel, this.hasUnicodeImport);
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if (PyTokenTypes.STRING_NODES.contains(tokenType)) {
            return this.convertStringType(tokenType, this.getTokenText());
        }
        if (tokenType == PyTokenTypes.IDENTIFIER) {
            String tokenText = this.getTokenText();
            if (this.myLanguageLevel.hasWithStatement()) {
                if (tokenText.equals("with")) {
                    return PyTokenTypes.WITH_KEYWORD;
                }
                if (tokenText.equals("as")) {
                    return PyTokenTypes.AS_KEYWORD;
                }
            }
            if (this.myLanguageLevel.hasPrintStatement() && tokenText.equals("print")) {
                return PyTokenTypes.PRINT_KEYWORD;
            }
            if (this.myLanguageLevel.isPy3K()) {
                if (tokenText.equals("None")) {
                    return PyTokenTypes.NONE_KEYWORD;
                }
                if (tokenText.equals("True")) {
                    return PyTokenTypes.TRUE_KEYWORD;
                }
                if (tokenText.equals("False")) {
                    return PyTokenTypes.FALSE_KEYWORD;
                }
                if (tokenText.equals("nonlocal")) {
                    return PyTokenTypes.NONLOCAL_KEYWORD;
                }
                if (tokenText.equals("__debug__")) {
                    return PyTokenTypes.DEBUG_KEYWORD;
                }
                if (this.myLanguageLevel.isAtLeast(LanguageLevel.PYTHON37)) {
                    if (tokenText.equals("async")) {
                        return PyTokenTypes.ASYNC_KEYWORD;
                    }
                    if (tokenText.equals("await")) {
                        return PyTokenTypes.AWAIT_KEYWORD;
                    }
                }
            } else if (tokenText.equals("exec")) {
                return PyTokenTypes.EXEC_KEYWORD;
            }
        }
        return tokenType;
    }

    public void advance() {
        IElementType type = super.getTokenType();
        switch (this.myState) {
            case init: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type) || PyTokenTypes.END_OF_LINE_COMMENT == type || PyTokenTypes.DOCSTRING == type) break;
                if (type == PyTokenTypes.FROM_KEYWORD) {
                    this.myState = state.pending_future;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_future: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IDENTIFIER && "__future__".equals(super.getTokenText())) {
                    this.myState = state.pending_import;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_import: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IMPORT_KEYWORD) {
                    this.myState = state.pending_lpar;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_lpar: {
                if (type == PyTokenTypes.LPAR) {
                    this.myState = state.pending_id;
                    break;
                }
            }
            case pending_id: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IDENTIFIER) {
                    this.myState = state.pending_comma;
                    if (!"unicode_literals".equals(super.getTokenText())) break;
                    this.hasUnicodeImport = true;
                    this.myImportOffset = this.getTokenEnd();
                    break;
                }
                this.myState = state.init;
                break;
            }
            case pending_comma: {
                if (type == PyTokenTypes.RPAR || type == PyTokenTypes.BACKSLASH) break;
                if (PyTokenTypes.LINE_BREAK == type) {
                    this.myState = state.init;
                }
                if (PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type) || type != PyTokenTypes.COMMA) break;
                this.myState = state.pending_id;
                break;
            }
        }
        super.advance();
    }

    public int getImportOffset() {
        return this.myImportOffset;
    }

    public void clearState(int position) {
        this.myState = state.init;
        this.myImportOffset = position;
        this.hasUnicodeImport = false;
    }

    private static enum state {
        init,
        pending_future,
        pending_import,
        pending_lpar,
        pending_id,
        pending_comma,
        stop;

    }
}

