/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.FollowingCommentBinder;
import com.jetbrains.python.parsing.LeadingCommentsBinder;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.ParsingScope;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementType;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class StatementParsing
extends Parsing
implements ITokenTypeRemapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.parsing.StatementParsing");
    @NonNls
    protected static final String TOK_FUTURE_IMPORT = "__future__";
    @NonNls
    protected static final String TOK_WITH_STATEMENT = "with_statement";
    @NonNls
    protected static final String TOK_NESTED_SCOPES = "nested_scopes";
    @NonNls
    protected static final String TOK_PRINT_FUNCTION = "print_function";
    @NonNls
    protected static final String TOK_WITH = "with";
    @NonNls
    protected static final String TOK_AS = "as";
    @NonNls
    protected static final String TOK_PRINT = "print";
    @NonNls
    protected static final String TOK_NONE = "None";
    @NonNls
    protected static final String TOK_TRUE = "True";
    @NonNls
    protected static final String TOK_DEBUG = "__debug__";
    @NonNls
    protected static final String TOK_FALSE = "False";
    @NonNls
    protected static final String TOK_NONLOCAL = "nonlocal";
    @NonNls
    protected static final String TOK_EXEC = "exec";
    @NonNls
    public static final String TOK_ASYNC = "async";
    @NonNls
    protected static final String TOK_AWAIT = "await";
    private static final String EXPRESSION_EXPECTED = "Expression expected";
    public static final String IDENTIFIER_EXPECTED = "Identifier expected";
    private Phase myFutureImportPhase = Phase.NONE;
    private boolean myExpectAsKeyword = false;
    protected Set<FUTURE> myFutureFlags = EnumSet.noneOf(FUTURE.class);

    public StatementParsing(ParsingContext context, @Nullable FUTURE futureFlag) {
        super(context);
        if (futureFlag != null) {
            this.myFutureFlags.add(futureFlag);
        }
    }

    private void setExpectAsKeyword(boolean expectAsKeyword) {
        this.myExpectAsKeyword = expectAsKeyword;
        this.myBuilder.setTokenTypeRemapper((ITokenTypeRemapper)this);
    }

    public void parseStatement() {
        while (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            this.myBuilder.advanceLexer();
        }
        IElementType firstToken = this.myBuilder.getTokenType();
        if (firstToken == null) {
            return;
        }
        if (firstToken == PyTokenTypes.WHILE_KEYWORD) {
            this.parseWhileStatement();
            return;
        }
        if (firstToken == PyTokenTypes.IF_KEYWORD) {
            this.parseIfStatement(PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.ELSE_KEYWORD, PyElementTypes.IF_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.FOR_KEYWORD) {
            this.parseForStatement(this.myBuilder.mark());
            return;
        }
        if (firstToken == PyTokenTypes.TRY_KEYWORD) {
            this.parseTryStatement();
            return;
        }
        if (firstToken == PyTokenTypes.DEF_KEYWORD) {
            this.getFunctionParser().parseFunctionDeclaration(this.myBuilder.mark(), false);
            return;
        }
        if (firstToken == PyTokenTypes.AT) {
            this.getFunctionParser().parseDecoratedDeclaration();
            return;
        }
        if (firstToken == PyTokenTypes.CLASS_KEYWORD) {
            this.parseClassDeclaration();
            return;
        }
        if (firstToken == PyTokenTypes.WITH_KEYWORD) {
            this.parseWithStatement(this.myBuilder.mark());
            return;
        }
        if (firstToken == PyTokenTypes.ASYNC_KEYWORD) {
            this.parseAsyncStatement(false);
            return;
        }
        if (this.atToken(PyTokenTypes.IDENTIFIER, TOK_ASYNC) && this.parseAsyncStatement(true)) {
            return;
        }
        this.parseSimpleStatement();
    }

    protected void parseSimpleStatement() {
        this.parseSimpleStatement(true);
    }

    protected void parseSimpleStatement(boolean checkLanguageLevel) {
        PsiBuilder builder2 = this.myContext.getBuilder();
        IElementType firstToken = builder2.getTokenType();
        if (firstToken == null) {
            return;
        }
        if (firstToken == PyTokenTypes.PRINT_KEYWORD && this.hasPrintStatement()) {
            this.parsePrintStatement(builder2);
            return;
        }
        if (firstToken == PyTokenTypes.ASSERT_KEYWORD) {
            this.parseAssertStatement();
            return;
        }
        if (firstToken == PyTokenTypes.BREAK_KEYWORD) {
            this.parseKeywordStatement(builder2, PyElementTypes.BREAK_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.CONTINUE_KEYWORD) {
            this.parseKeywordStatement(builder2, PyElementTypes.CONTINUE_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.DEL_KEYWORD) {
            this.parseDelStatement();
            return;
        }
        if (firstToken == PyTokenTypes.EXEC_KEYWORD) {
            this.parseExecStatement();
            return;
        }
        if (firstToken == PyTokenTypes.GLOBAL_KEYWORD) {
            this.parseNameDefiningStatement(PyElementTypes.GLOBAL_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.NONLOCAL_KEYWORD) {
            this.parseNameDefiningStatement(PyElementTypes.NONLOCAL_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.IMPORT_KEYWORD) {
            this.parseImportStatement((IElementType)PyElementTypes.IMPORT_STATEMENT, (IElementType)PyElementTypes.IMPORT_ELEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.FROM_KEYWORD) {
            this.parseFromImportStatement();
            return;
        }
        if (firstToken == PyTokenTypes.PASS_KEYWORD) {
            this.parseKeywordStatement(builder2, PyElementTypes.PASS_STATEMENT);
            return;
        }
        if (firstToken == PyTokenTypes.RETURN_KEYWORD) {
            this.parseReturnStatement(builder2);
            return;
        }
        if (firstToken == PyTokenTypes.RAISE_KEYWORD) {
            this.parseRaiseStatement();
            return;
        }
        PsiBuilder.Marker exprStatement = builder2.mark();
        if (builder2.getTokenType() == PyTokenTypes.YIELD_KEYWORD) {
            this.getExpressionParser().parseYieldOrTupleExpression(false);
            this.checkEndOfStatement();
            exprStatement.done((IElementType)PyElementTypes.EXPRESSION_STATEMENT);
            return;
        }
        if (this.getExpressionParser().parseExpressionOptional()) {
            PyElementType statementType;
            block26: {
                statementType = PyElementTypes.EXPRESSION_STATEMENT;
                if (PyTokenTypes.AUG_ASSIGN_OPERATIONS.contains(builder2.getTokenType())) {
                    statementType = PyElementTypes.AUG_ASSIGNMENT_STATEMENT;
                    builder2.advanceLexer();
                    if (!this.getExpressionParser().parseYieldOrTupleExpression(false)) {
                        builder2.error(EXPRESSION_EXPECTED);
                    }
                } else if (this.atToken(PyTokenTypes.EQ) || this.atToken(PyTokenTypes.COLON) && checkLanguageLevel && this.myContext.getLanguageLevel().isPy3K()) {
                    exprStatement.rollbackTo();
                    exprStatement = builder2.mark();
                    this.getExpressionParser().parseExpression(false, true);
                    LOG.assertTrue(builder2.getTokenType() == PyTokenTypes.EQ || builder2.getTokenType() == PyTokenTypes.COLON, (Object)builder2.getTokenType());
                    if (builder2.getTokenType() == PyTokenTypes.COLON) {
                        statementType = PyElementTypes.TYPE_DECLARATION_STATEMENT;
                        this.getFunctionParser().parseParameterAnnotation();
                    }
                    if (builder2.getTokenType() == PyTokenTypes.EQ) {
                        PsiBuilder.Marker maybeExprMarker;
                        statementType = PyElementTypes.ASSIGNMENT_STATEMENT;
                        builder2.advanceLexer();
                        while (true) {
                            boolean isYieldExpr;
                            maybeExprMarker = builder2.mark();
                            boolean bl = isYieldExpr = builder2.getTokenType() == PyTokenTypes.YIELD_KEYWORD;
                            if (!this.getExpressionParser().parseYieldOrTupleExpression(false)) {
                                maybeExprMarker.drop();
                                builder2.error(EXPRESSION_EXPECTED);
                                break block26;
                            }
                            if (builder2.getTokenType() != PyTokenTypes.EQ) break;
                            if (isYieldExpr) {
                                maybeExprMarker.drop();
                                builder2.error("Cannot assign to 'yield' expression");
                            } else {
                                maybeExprMarker.rollbackTo();
                                this.getExpressionParser().parseExpression(false, true);
                                LOG.assertTrue(builder2.getTokenType() == PyTokenTypes.EQ, (Object)builder2.getTokenType());
                            }
                            builder2.advanceLexer();
                        }
                        maybeExprMarker.drop();
                    }
                }
            }
            this.checkEndOfStatement();
            exprStatement.done((IElementType)statementType);
            return;
        }
        exprStatement.drop();
        builder2.advanceLexer();
        this.reportParseStatementError(builder2, firstToken);
    }

    protected void reportParseStatementError(PsiBuilder builder2, IElementType firstToken) {
        if (firstToken == PyTokenTypes.INCONSISTENT_DEDENT) {
            builder2.error("Unindent does not match any outer indentation level");
        } else if (firstToken == PyTokenTypes.INDENT) {
            builder2.error("Unexpected indent");
        } else {
            builder2.error("Statement expected, found " + firstToken.toString());
        }
    }

    protected boolean hasPrintStatement() {
        return this.myContext.getLanguageLevel().hasPrintStatement() && !this.myFutureFlags.contains((Object)FUTURE.PRINT_FUNCTION);
    }

    protected boolean hasWithStatement() {
        return this.myContext.getLanguageLevel().hasWithStatement() || this.myFutureFlags.contains((Object)FUTURE.WITH_STATEMENT);
    }

    protected void checkEndOfStatement() {
        PsiBuilder builder2 = this.myContext.getBuilder();
        ParsingScope scope = this.getParsingContext().getScope();
        if (builder2.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            builder2.advanceLexer();
            scope.setAfterSemicolon(false);
        } else if (builder2.getTokenType() == PyTokenTypes.SEMICOLON) {
            if (!scope.isSuite()) {
                builder2.advanceLexer();
                scope.setAfterSemicolon(true);
                if (builder2.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
                    builder2.advanceLexer();
                    scope.setAfterSemicolon(false);
                }
            }
        } else if (!builder2.eof()) {
            builder2.error("End of statement expected");
        }
    }

    private void parsePrintStatement(PsiBuilder builder2) {
        LOG.assertTrue(builder2.getTokenType() == PyTokenTypes.PRINT_KEYWORD);
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        if (builder2.getTokenType() == PyTokenTypes.GTGT) {
            PsiBuilder.Marker target2 = builder2.mark();
            builder2.advanceLexer();
            this.getExpressionParser().parseSingleExpression(false);
            target2.done((IElementType)PyElementTypes.PRINT_TARGET);
        } else {
            this.getExpressionParser().parseSingleExpression(false);
        }
        while (builder2.getTokenType() == PyTokenTypes.COMMA) {
            builder2.advanceLexer();
            if (this.getEndOfStatementsTokens().contains(builder2.getTokenType())) break;
            this.getExpressionParser().parseSingleExpression(false);
        }
        this.checkEndOfStatement();
        statement.done((IElementType)PyElementTypes.PRINT_STATEMENT);
    }

    protected void parseKeywordStatement(PsiBuilder builder2, IElementType statementType) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        this.checkEndOfStatement();
        statement.done(statementType);
    }

    private void parseReturnStatement(PsiBuilder builder2) {
        LOG.assertTrue(builder2.getTokenType() == PyTokenTypes.RETURN_KEYWORD);
        PsiBuilder.Marker returnStatement = builder2.mark();
        builder2.advanceLexer();
        if (builder2.getTokenType() != null && !this.getEndOfStatementsTokens().contains(builder2.getTokenType())) {
            this.getExpressionParser().parseExpression();
        }
        this.checkEndOfStatement();
        returnStatement.done((IElementType)PyElementTypes.RETURN_STATEMENT);
    }

    private void parseDelStatement() {
        this.assertCurrentToken(PyTokenTypes.DEL_KEYWORD);
        PsiBuilder.Marker delStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseSingleExpression(false)) {
            this.myBuilder.error(EXPRESSION_EXPECTED);
        }
        while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            this.myBuilder.advanceLexer();
            if (this.getEndOfStatementsTokens().contains(this.myBuilder.getTokenType()) || this.getExpressionParser().parseSingleExpression(false)) continue;
            this.myBuilder.error(EXPRESSION_EXPECTED);
        }
        this.checkEndOfStatement();
        delStatement.done((IElementType)PyElementTypes.DEL_STATEMENT);
    }

    private void parseRaiseStatement() {
        this.assertCurrentToken(PyTokenTypes.RAISE_KEYWORD);
        PsiBuilder.Marker raiseStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getEndOfStatementsTokens().contains(this.myBuilder.getTokenType())) {
            this.getExpressionParser().parseSingleExpression(false);
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                this.getExpressionParser().parseSingleExpression(false);
                if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                    this.myBuilder.advanceLexer();
                    this.getExpressionParser().parseSingleExpression(false);
                }
            } else if (this.myBuilder.getTokenType() == PyTokenTypes.FROM_KEYWORD) {
                this.myBuilder.advanceLexer();
                if (!this.getExpressionParser().parseSingleExpression(false)) {
                    this.myBuilder.error(EXPRESSION_EXPECTED);
                }
            }
        }
        this.checkEndOfStatement();
        raiseStatement.done((IElementType)PyElementTypes.RAISE_STATEMENT);
    }

    private void parseAssertStatement() {
        this.assertCurrentToken(PyTokenTypes.ASSERT_KEYWORD);
        PsiBuilder.Marker assertStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.getExpressionParser().parseSingleExpression(false)) {
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                if (!this.getExpressionParser().parseSingleExpression(false)) {
                    this.myContext.getBuilder().error(EXPRESSION_EXPECTED);
                }
            }
            this.checkEndOfStatement();
        } else {
            this.myContext.getBuilder().error(EXPRESSION_EXPECTED);
        }
        assertStatement.done((IElementType)PyElementTypes.ASSERT_STATEMENT);
    }

    protected void parseImportStatement(IElementType statementType, IElementType elementType) {
        PsiBuilder builder2 = this.myContext.getBuilder();
        PsiBuilder.Marker importStatement = builder2.mark();
        builder2.advanceLexer();
        this.parseImportElements(elementType, true, false, false);
        this.checkEndOfStatement();
        importStatement.done(statementType);
    }

    private void parseFromImportStatement() {
        PsiBuilder builder2 = this.myContext.getBuilder();
        this.assertCurrentToken(PyTokenTypes.FROM_KEYWORD);
        this.myFutureImportPhase = Phase.FROM;
        PsiBuilder.Marker fromImportStatement = builder2.mark();
        builder2.advanceLexer();
        boolean from_future = false;
        boolean had_dots = this.parseRelativeImportDots();
        IElementType statementType = PyElementTypes.FROM_IMPORT_STATEMENT;
        if (had_dots && this.parseOptionalDottedName() || this.parseDottedName()) {
            ImportTypes types = this.checkFromImportKeyword();
            statementType = types.statement;
            IElementType elementType = types.element;
            if (this.myFutureImportPhase == Phase.FUTURE) {
                this.myFutureImportPhase = Phase.IMPORT;
                from_future = true;
            }
            if (builder2.getTokenType() == PyTokenTypes.MULT) {
                PsiBuilder.Marker star_import_mark = builder2.mark();
                builder2.advanceLexer();
                star_import_mark.done(types.starElement);
            } else if (builder2.getTokenType() == PyTokenTypes.LPAR) {
                builder2.advanceLexer();
                this.parseImportElements(elementType, false, true, from_future);
                this.checkMatches(PyTokenTypes.RPAR, ") expected");
            } else {
                this.parseImportElements(elementType, false, false, from_future);
            }
        } else if (had_dots) {
            ImportTypes types = this.checkFromImportKeyword();
            statementType = types.statement;
            this.parseImportElements(types.element, false, false, from_future);
        }
        this.checkEndOfStatement();
        fromImportStatement.done(statementType);
        this.myFutureImportPhase = Phase.NONE;
    }

    protected ImportTypes checkFromImportKeyword() {
        this.checkMatches(PyTokenTypes.IMPORT_KEYWORD, "'import' expected");
        return new ImportTypes((IElementType)PyElementTypes.FROM_IMPORT_STATEMENT, (IElementType)PyElementTypes.IMPORT_ELEMENT, (IElementType)PyElementTypes.STAR_IMPORT_ELEMENT);
    }

    private boolean parseRelativeImportDots() {
        PsiBuilder builder2 = this.myContext.getBuilder();
        boolean had_dots = false;
        while (builder2.getTokenType() == PyTokenTypes.DOT) {
            had_dots = true;
            builder2.advanceLexer();
        }
        return had_dots;
    }

    private void parseImportElements(IElementType elementType, boolean is_module_import, boolean in_parens, boolean from_future) {
        PsiBuilder builder2 = this.myContext.getBuilder();
        do {
            PsiBuilder.Marker asMarker = builder2.mark();
            if (is_module_import) {
                if (!this.parseDottedNameAsAware(true, false)) {
                    asMarker.drop();
                    break;
                }
            } else {
                String token_text = this.parseIdentifier(this.getReferenceType());
                if (from_future) {
                    if (TOK_WITH_STATEMENT.equals(token_text)) {
                        this.myFutureFlags.add(FUTURE.WITH_STATEMENT);
                    } else if (TOK_NESTED_SCOPES.equals(token_text)) {
                        this.myFutureFlags.add(FUTURE.NESTED_SCOPES);
                    } else if (TOK_PRINT_FUNCTION.equals(token_text)) {
                        this.myFutureFlags.add(FUTURE.PRINT_FUNCTION);
                    }
                }
            }
            this.setExpectAsKeyword(true);
            if (builder2.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                builder2.advanceLexer();
                this.setExpectAsKeyword(false);
                this.parseIdentifier((IElementType)PyElementTypes.TARGET_EXPRESSION);
            }
            asMarker.done(elementType);
            this.setExpectAsKeyword(false);
            if (builder2.getTokenType() != PyTokenTypes.COMMA) break;
            builder2.advanceLexer();
        } while (!in_parens || builder2.getTokenType() != PyTokenTypes.RPAR);
    }

    @Nullable
    private String parseIdentifier(IElementType elementType) {
        PsiBuilder.Marker idMarker = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            String id_text = this.myBuilder.getTokenText();
            this.myBuilder.advanceLexer();
            idMarker.done(elementType);
            return id_text;
        }
        this.myBuilder.error(IDENTIFIER_EXPECTED);
        idMarker.drop();
        return null;
    }

    public boolean parseOptionalDottedName() {
        return this.parseDottedNameAsAware(false, true);
    }

    public boolean parseDottedName() {
        return this.parseDottedNameAsAware(false, false);
    }

    protected boolean parseDottedNameAsAware(boolean expect_as, boolean optional) {
        if (this.myBuilder.getTokenType() != PyTokenTypes.IDENTIFIER) {
            if (optional) {
                return true;
            }
            this.myBuilder.error(IDENTIFIER_EXPECTED);
            return false;
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        marker.done(this.getReferenceType());
        boolean old_expect_AS_kwd = this.myExpectAsKeyword;
        this.setExpectAsKeyword(expect_as);
        while (this.myBuilder.getTokenType() == PyTokenTypes.DOT) {
            marker = marker.precede();
            this.myBuilder.advanceLexer();
            this.checkMatches(PyTokenTypes.IDENTIFIER, IDENTIFIER_EXPECTED);
            marker.done(this.getReferenceType());
        }
        this.setExpectAsKeyword(old_expect_AS_kwd);
        return true;
    }

    private void parseNameDefiningStatement(PyElementType elementType) {
        PsiBuilder.Marker globalStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.parseIdentifier((IElementType)PyElementTypes.TARGET_EXPRESSION);
        while (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
            this.myBuilder.advanceLexer();
            this.parseIdentifier((IElementType)PyElementTypes.TARGET_EXPRESSION);
        }
        this.checkEndOfStatement();
        globalStatement.done((IElementType)elementType);
    }

    private void parseExecStatement() {
        this.assertCurrentToken(PyTokenTypes.EXEC_KEYWORD);
        PsiBuilder.Marker execStatement = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getExpressionParser().parseExpression(true, false);
        if (this.myBuilder.getTokenType() == PyTokenTypes.IN_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.getExpressionParser().parseSingleExpression(false);
            if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
                this.getExpressionParser().parseSingleExpression(false);
            }
        }
        this.checkEndOfStatement();
        execStatement.done((IElementType)PyElementTypes.EXEC_STATEMENT);
    }

    protected void parseIfStatement(PyElementType ifKeyword, PyElementType elifKeyword, PyElementType elseKeyword, PyElementType elementType) {
        this.assertCurrentToken(ifKeyword);
        PsiBuilder.Marker ifStatement = this.myBuilder.mark();
        PsiBuilder.Marker ifPart = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseSingleExpression(false)) {
            this.myBuilder.error("expression expected");
        }
        this.parseColonAndSuite();
        ifPart.done((IElementType)PyElementTypes.IF_PART_IF);
        PsiBuilder.Marker elifPart = this.myBuilder.mark();
        while (this.myBuilder.getTokenType() == elifKeyword) {
            this.myBuilder.advanceLexer();
            if (!this.getExpressionParser().parseSingleExpression(false)) {
                this.myBuilder.error("expression expected");
            }
            this.parseColonAndSuite();
            elifPart.done((IElementType)PyElementTypes.IF_PART_ELIF);
            elifPart = this.myBuilder.mark();
        }
        elifPart.drop();
        PsiBuilder.Marker elsePart = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == elseKeyword) {
            this.myBuilder.advanceLexer();
            this.parseColonAndSuite();
            elsePart.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            elsePart.drop();
        }
        ifStatement.done((IElementType)elementType);
    }

    private boolean expectColon() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.COLON) {
            this.myBuilder.advanceLexer();
            return true;
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            this.myBuilder.error("Colon expected");
            return true;
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        while (!this.atAnyOfTokens(null, PyTokenTypes.DEDENT, PyTokenTypes.STATEMENT_BREAK, PyTokenTypes.COLON)) {
            this.myBuilder.advanceLexer();
        }
        boolean result2 = this.matchToken(PyTokenTypes.COLON);
        if (!result2 && this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
            this.myBuilder.advanceLexer();
        }
        marker.error("Colon expected");
        return result2;
    }

    private void parseForStatement(PsiBuilder.Marker endMarker) {
        this.assertCurrentToken(PyTokenTypes.FOR_KEYWORD);
        this.parseForPart();
        PsiBuilder.Marker elsePart = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.parseColonAndSuite();
            elsePart.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            elsePart.drop();
        }
        endMarker.done((IElementType)PyElementTypes.FOR_STATEMENT);
    }

    protected void parseForPart() {
        PsiBuilder.Marker forPart = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.getExpressionParser().parseExpression(true, true);
        this.checkMatches(PyTokenTypes.IN_KEYWORD, "'in' expected");
        this.getExpressionParser().parseExpression();
        this.parseColonAndSuite();
        forPart.done((IElementType)PyElementTypes.FOR_PART);
    }

    private void parseWhileStatement() {
        this.assertCurrentToken(PyTokenTypes.WHILE_KEYWORD);
        PsiBuilder.Marker statement = this.myBuilder.mark();
        PsiBuilder.Marker whilePart = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (!this.getExpressionParser().parseSingleExpression(false)) {
            this.myBuilder.error(EXPRESSION_EXPECTED);
        }
        this.parseColonAndSuite();
        whilePart.done((IElementType)PyElementTypes.WHILE_PART);
        PsiBuilder.Marker elsePart = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.parseColonAndSuite();
            elsePart.done((IElementType)PyElementTypes.ELSE_PART);
        } else {
            elsePart.drop();
        }
        statement.done((IElementType)PyElementTypes.WHILE_STATEMENT);
    }

    private void parseTryStatement() {
        this.assertCurrentToken(PyTokenTypes.TRY_KEYWORD);
        PsiBuilder.Marker statement = this.myBuilder.mark();
        PsiBuilder.Marker tryPart = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        this.parseColonAndSuite();
        tryPart.done((IElementType)PyElementTypes.TRY_PART);
        boolean haveExceptClause = false;
        if (this.myBuilder.getTokenType() == PyTokenTypes.EXCEPT_KEYWORD) {
            haveExceptClause = true;
            while (this.myBuilder.getTokenType() == PyTokenTypes.EXCEPT_KEYWORD) {
                PsiBuilder.Marker exceptBlock = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() != PyTokenTypes.COLON) {
                    if (!this.getExpressionParser().parseSingleExpression(false)) {
                        this.myBuilder.error(EXPRESSION_EXPECTED);
                    }
                    this.setExpectAsKeyword(true);
                    if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA || this.myBuilder.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                        this.myBuilder.advanceLexer();
                        if (!this.getExpressionParser().parseSingleExpression(true)) {
                            this.myBuilder.error(EXPRESSION_EXPECTED);
                        }
                    }
                }
                this.parseColonAndSuite();
                exceptBlock.done(PyElementTypes.EXCEPT_PART);
            }
            PsiBuilder.Marker elsePart = this.myBuilder.mark();
            if (this.myBuilder.getTokenType() == PyTokenTypes.ELSE_KEYWORD) {
                this.myBuilder.advanceLexer();
                this.parseColonAndSuite();
                elsePart.done((IElementType)PyElementTypes.ELSE_PART);
            } else {
                elsePart.drop();
            }
        }
        PsiBuilder.Marker finallyPart = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == PyTokenTypes.FINALLY_KEYWORD) {
            this.myBuilder.advanceLexer();
            this.parseColonAndSuite();
            finallyPart.done((IElementType)PyElementTypes.FINALLY_PART);
        } else {
            finallyPart.drop();
            if (!haveExceptClause) {
                this.myBuilder.error("'except' or 'finally' expected");
            }
        }
        statement.done((IElementType)PyElementTypes.TRY_EXCEPT_STATEMENT);
    }

    private void parseColonAndSuite() {
        if (this.expectColon()) {
            this.parseSuite();
        } else {
            PsiBuilder.Marker mark = this.myBuilder.mark();
            mark.done((IElementType)PyElementTypes.STATEMENT_LIST);
        }
    }

    private void parseWithStatement(PsiBuilder.Marker endMarker) {
        this.assertCurrentToken(PyTokenTypes.WITH_KEYWORD);
        this.myBuilder.advanceLexer();
        do {
            PsiBuilder.Marker withItem = this.myBuilder.mark();
            this.getExpressionParser().parseExpression();
            this.setExpectAsKeyword(true);
            if (this.myBuilder.getTokenType() == PyTokenTypes.AS_KEYWORD) {
                this.myBuilder.advanceLexer();
                if (!this.getExpressionParser().parseSingleExpression(true)) {
                    this.myBuilder.error(IDENTIFIER_EXPECTED);
                }
            }
            withItem.done((IElementType)PyElementTypes.WITH_ITEM);
        } while (this.matchToken(PyTokenTypes.COMMA));
        this.parseColonAndSuite();
        endMarker.done((IElementType)PyElementTypes.WITH_STATEMENT);
    }

    private void parseClassDeclaration() {
        PsiBuilder.Marker classMarker = this.myBuilder.mark();
        this.parseClassDeclaration(classMarker);
    }

    public void parseClassDeclaration(PsiBuilder.Marker classMarker) {
        this.assertCurrentToken(PyTokenTypes.CLASS_KEYWORD);
        this.myBuilder.advanceLexer();
        this.parseIdentifierOrSkip(PyTokenTypes.LPAR, PyTokenTypes.COLON);
        if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
            this.getExpressionParser().parseArgumentList();
        } else {
            PsiBuilder.Marker inheritMarker = this.myBuilder.mark();
            inheritMarker.done((IElementType)PyElementTypes.ARGUMENT_LIST);
        }
        ParsingContext context = this.getParsingContext();
        context.pushScope(context.getScope().withClass());
        this.parseColonAndSuite();
        context.popScope();
        classMarker.done(PyElementTypes.CLASS_DECLARATION);
    }

    private boolean parseAsyncStatement(boolean falseAsync) {
        if (!falseAsync) {
            this.assertCurrentToken(PyTokenTypes.ASYNC_KEYWORD);
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.advanceAsync(falseAsync);
        IElementType token = this.myBuilder.getTokenType();
        if (token == PyTokenTypes.DEF_KEYWORD) {
            this.getFunctionParser().parseFunctionDeclaration(marker, true);
            return true;
        }
        if (token == PyTokenTypes.WITH_KEYWORD) {
            this.parseWithStatement(marker);
            return true;
        }
        if (token == PyTokenTypes.FOR_KEYWORD) {
            this.parseForStatement(marker);
            return true;
        }
        if (falseAsync) {
            marker.rollbackTo();
        } else {
            marker.drop();
            this.myBuilder.error("'def' or 'with' or 'for' expected");
        }
        return false;
    }

    public void parseSuite() {
        this.parseSuite(null, null);
    }

    public void parseSuite(@Nullable PsiBuilder.Marker endMarker, @Nullable IElementType elType) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK) {
            boolean indentFound;
            this.myBuilder.advanceLexer();
            PsiBuilder.Marker marker = this.myBuilder.mark();
            boolean bl = indentFound = this.myBuilder.getTokenType() == PyTokenTypes.INDENT;
            if (indentFound) {
                this.myBuilder.advanceLexer();
                if (this.myBuilder.eof()) {
                    this.myBuilder.error("Indented block expected");
                } else {
                    while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != PyTokenTypes.DEDENT) {
                        this.parseStatement();
                    }
                }
            } else {
                this.myBuilder.error("Indent expected");
            }
            marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
            marker.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)LeadingCommentsBinder.INSTANCE, (WhitespacesAndCommentsBinder)FollowingCommentBinder.INSTANCE);
            if (endMarker != null) {
                endMarker.done(elType);
            }
            if (indentFound && !this.myBuilder.eof()) {
                this.checkMatches(PyTokenTypes.DEDENT, "Dedent expected");
            }
        } else {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            if (this.myBuilder.eof()) {
                this.myBuilder.error("Statement expected");
            } else {
                ParsingContext context = this.getParsingContext();
                context.pushScope(context.getScope().withSuite());
                this.parseSimpleStatement();
                context.popScope();
                while (this.matchToken(PyTokenTypes.SEMICOLON) && !this.matchToken(PyTokenTypes.STATEMENT_BREAK)) {
                    context.pushScope(context.getScope().withSuite());
                    this.parseSimpleStatement();
                    context.popScope();
                }
            }
            marker.done((IElementType)PyElementTypes.STATEMENT_LIST);
            if (endMarker != null) {
                endMarker.done(elType);
            }
        }
    }

    public IElementType filter(IElementType source, int start, int end, CharSequence text2) {
        return this.filter(source, start, end, text2, true);
    }

    protected IElementType filter(IElementType source, int start, int end, CharSequence text2, boolean checkLanguageLevel) {
        if ((this.myExpectAsKeyword || this.hasWithStatement()) && source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text2, start, end, TOK_AS)) {
            return PyTokenTypes.AS_KEYWORD;
        }
        if (this.myFutureImportPhase == Phase.FROM && source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text2, start, end, TOK_FUTURE_IMPORT)) {
            this.myFutureImportPhase = Phase.FUTURE;
            return source;
        }
        if (this.hasWithStatement() && source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text2, start, end, TOK_WITH)) {
            return PyTokenTypes.WITH_KEYWORD;
        }
        if (this.hasPrintStatement() && source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text2, start, end, TOK_PRINT)) {
            return PyTokenTypes.PRINT_KEYWORD;
        }
        if ((this.myContext.getLanguageLevel().isPy3K() || !checkLanguageLevel) && source == PyTokenTypes.IDENTIFIER) {
            if (StatementParsing.isWordAtPosition(text2, start, end, TOK_NONE)) {
                return PyTokenTypes.NONE_KEYWORD;
            }
            if (StatementParsing.isWordAtPosition(text2, start, end, TOK_TRUE)) {
                return PyTokenTypes.TRUE_KEYWORD;
            }
            if (StatementParsing.isWordAtPosition(text2, start, end, TOK_FALSE)) {
                return PyTokenTypes.FALSE_KEYWORD;
            }
            if (StatementParsing.isWordAtPosition(text2, start, end, TOK_DEBUG)) {
                return PyTokenTypes.DEBUG_KEYWORD;
            }
            if (StatementParsing.isWordAtPosition(text2, start, end, TOK_NONLOCAL)) {
                return PyTokenTypes.NONLOCAL_KEYWORD;
            }
            LanguageLevel languageLevel = this.myContext.getLanguageLevel();
            if (languageLevel.isAtLeast(LanguageLevel.PYTHON35) || !checkLanguageLevel) {
                if (StatementParsing.isWordAtPosition(text2, start, end, TOK_ASYNC) && (languageLevel.isAtLeast(LanguageLevel.PYTHON37) || this.myContext.getScope().isAsync() || this.myBuilder.lookAhead(1) == PyTokenTypes.DEF_KEYWORD)) {
                    return PyTokenTypes.ASYNC_KEYWORD;
                }
                if (StatementParsing.isWordAtPosition(text2, start, end, TOK_AWAIT) && (languageLevel.isAtLeast(LanguageLevel.PYTHON37) || this.myContext.getScope().isAsync())) {
                    return PyTokenTypes.AWAIT_KEYWORD;
                }
            }
        } else if ((this.myContext.getLanguageLevel().isPython2() || !checkLanguageLevel) && source == PyTokenTypes.IDENTIFIER && StatementParsing.isWordAtPosition(text2, start, end, TOK_EXEC)) {
            return PyTokenTypes.EXEC_KEYWORD;
        }
        return source;
    }

    protected TokenSet getEndOfStatementsTokens() {
        return PyTokenTypes.END_OF_STATEMENT;
    }

    private static boolean isWordAtPosition(CharSequence text2, int start, int end, String tokenText) {
        return CharArrayUtil.regionMatches((CharSequence)text2, (int)start, (int)end, (CharSequence)tokenText) && end - start == tokenText.length();
    }

    public static class ImportTypes {
        public final IElementType statement;
        public final IElementType element;
        public IElementType starElement;

        public ImportTypes(IElementType statement, IElementType element, IElementType starElement) {
            this.statement = statement;
            this.element = element;
            this.starElement = starElement;
        }
    }

    public static enum FUTURE {
        ABSOLUTE_IMPORT,
        DIVISION,
        GENERATORS,
        NESTED_SCOPES,
        WITH_STATEMENT,
        PRINT_FUNCTION;

    }

    protected static enum Phase {
        NONE,
        FROM,
        FUTURE,
        IMPORT;

    }
}

