/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyComprehensionComponent;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyComprehensionIfComponent;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyElementImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyComprehensionElementImpl
extends PyElementImpl
implements PyComprehensionElement {
    public PyComprehensionElementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @Nullable
    public PyExpression getResultExpression() {
        ASTNode[] exprs = this.getNode().getChildren(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens());
        return exprs.length == 0 ? null : (PyExpression)exprs[0].getPsi();
    }

    @Override
    public List<PyComprehensionForComponent> getForComponents() {
        final ArrayList<PyComprehensionForComponent> list2 = new ArrayList<PyComprehensionForComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitForComponent(PyComprehensionForComponent component) {
                list2.add(component);
            }
        });
        return list2;
    }

    private void visitComponents(ComprehensionElementVisitor visitor2) {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            ASTNode next = PyComprehensionElementImpl.getNextExpression(node);
            if (next == null) break;
            if (type == PyTokenTypes.FOR_KEYWORD) {
                ASTNode next2 = PyComprehensionElementImpl.getNextExpression(next);
                if (next2 == null) break;
                final PyExpression variable = (PyExpression)next.getPsi();
                final PyExpression iterated = (PyExpression)next2.getPsi();
                final boolean isAsync = Optional.ofNullable(node.getTreePrev()).map(ASTNode::getTreePrev).map(asyncNode -> asyncNode.getElementType() == PyTokenTypes.ASYNC_KEYWORD).orElse(false);
                visitor2.visitForComponent(new PyComprehensionForComponent(){

                    @Override
                    public PyExpression getIteratorVariable() {
                        return variable;
                    }

                    @Override
                    public PyExpression getIteratedList() {
                        return iterated;
                    }

                    @Override
                    public boolean isAsync() {
                        return isAsync;
                    }
                });
                continue;
            }
            if (type != PyTokenTypes.IF_KEYWORD) continue;
            final PyExpression test = (PyExpression)next.getPsi();
            visitor2.visitIfComponent(new PyComprehensionIfComponent(){

                @Override
                public PyExpression getTest() {
                    return test;
                }
            });
        }
    }

    @Override
    public List<PyComprehensionIfComponent> getIfComponents() {
        final ArrayList<PyComprehensionIfComponent> list2 = new ArrayList<PyComprehensionIfComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitIfComponent(PyComprehensionIfComponent component) {
                list2.add(component);
            }
        });
        return list2;
    }

    @Override
    public List<PyComprehensionComponent> getComponents() {
        final ArrayList<PyComprehensionComponent> list2 = new ArrayList<PyComprehensionComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitForComponent(PyComprehensionForComponent component) {
                list2.add(component);
            }

            @Override
            void visitIfComponent(PyComprehensionIfComponent component) {
                list2.add(component);
            }
        });
        return list2;
    }

    @Nullable
    private static ASTNode getNextExpression(ASTNode after2) {
        ASTNode node = after2;
        while ((node = node.getTreeNext()) != null && !PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens().contains(node.getElementType())) {
        }
        return node;
    }

    @Override
    @NotNull
    public List<PsiNamedElement> getNamedElements() {
        List<PyComprehensionForComponent> fors = this.getForComponents();
        PyExpression[] for_targets = new PyExpression[fors.size()];
        int i = 0;
        for (PyComprehensionForComponent for_comp : fors) {
            for_targets[i] = for_comp.getIteratorVariable();
            ++i;
        }
        List<PyExpression> expressions = PyUtil.flattenedParensAndLists(for_targets);
        ArrayList results = Lists.newArrayList();
        for (PyExpression expression : expressions) {
            if (!(expression instanceof PsiNamedElement)) continue;
            results.add((PsiNamedElement)expression);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            PyComprehensionElementImpl.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public PsiNamedElement getNamedElement(@NotNull String the_name) {
        if (the_name == null) {
            PyComprehensionElementImpl.$$$reportNull$$$0(1);
        }
        return PyUtil.IterHelper.findName(this.getNamedElements(), the_name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyComprehensionElementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "the_name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyComprehensionElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    abstract class ComprehensionElementVisitor {
        ComprehensionElementVisitor() {
        }

        void visitIfComponent(PyComprehensionIfComponent component) {
        }

        void visitForComponent(PyComprehensionForComponent component) {
        }
    }
}

