/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.jetbrains.annotations.Nullable;

public final class RegExpDocumentationProvider
extends AbstractDocumentationProvider {
    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String description;
        RegExpProperty prop;
        ASTNode node;
        if (element instanceof RegExpProperty && (node = (prop = (RegExpProperty)element).getCategoryNode()) != null && (description = RegExpLanguageHosts.getInstance().getPropertyDescription(node.getPsi(), node.getText())) != null) {
            if (prop.isNegated()) {
                return "Property block stands for characters not matching " + description;
            }
            return "Property block stands for " + description;
        }
        return null;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof RegExpGroup) {
            RegExpGroup group = (RegExpGroup)element;
            return StringUtil.escapeXml((String)group.getUnescapedText());
        }
        return null;
    }
}

