/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.plantuml;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/extensions/plantuml/PlantUMLProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFenceCacheableProvider;", "()V", "cacheCollector", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCacheCollector;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCacheCollector;)V", "cacheDiagram", "", "newDiagramPath", "", "text", "generateDiagram", "", "diagramPath", "generateHtml", "isApplicable", "", "language", "Companion", "intellij.markdown"})
public final class PlantUMLProvider
implements MarkdownCodeFenceCacheableProvider {
    private MarkdownCodeFencePluginCacheCollector cacheCollector;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String generateHtml(@NotNull String text) {
        File newDiagramFile;
        block0: {
            MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            newDiagramFile = new File(this.getCacheRootPath() + File.separator + MarkdownUtil.md5((markdownCodeFencePluginCacheCollector = this.cacheCollector) != null && (markdownCodeFencePluginCacheCollector = markdownCodeFencePluginCacheCollector.getFile()) != null ? markdownCodeFencePluginCacheCollector.getPath() : null, "markdown-md5-file-path") + File.separator + MarkdownUtil.md5(text, "plantUML-diagram") + ".png");
            String string = newDiagramFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newDiagramFile.absolutePath");
            this.cacheDiagram(string, text);
            MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector2 = this.cacheCollector;
            if (markdownCodeFencePluginCacheCollector2 == null) break block0;
            markdownCodeFencePluginCacheCollector2.addAliveCachedFile(newDiagramFile);
        }
        return "<img src=\"" + newDiagramFile.toURI() + "\"/>";
    }

    private final void cacheDiagram(String newDiagramPath, String text) {
        if (!FileUtil.exists((String)newDiagramPath)) {
            this.generateDiagram(text, newDiagramPath);
        }
    }

    private final void generateDiagram(CharSequence text, String diagramPath) throws IOException {
        String string;
        String string2 = string = ((Object)text).toString();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String innerText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)innerText, (String)"@startuml", (boolean)false, (int)2, null)) {
            innerText = "@startuml\n" + innerText;
        }
        if (!StringsKt.endsWith$default((String)innerText, (String)"@enduml", (boolean)false, (int)2, null)) {
            innerText = innerText + "\n@enduml";
        }
        FileUtil.createParentDirs((File)new File(diagramPath));
        PlantUMLProvider.Companion.storeDiagram(innerText, diagramPath);
    }

    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)"puml") || Intrinsics.areEqual((Object)language, (Object)"plantuml");
    }

    public PlantUMLProvider(@Nullable MarkdownCodeFencePluginCacheCollector cacheCollector) {
        this.cacheCollector = cacheCollector;
    }

    public PlantUMLProvider() {
        this(null);
    }

    @Override
    @NotNull
    public String getCacheRootPath() {
        return MarkdownCodeFenceCacheableProvider.DefaultImpls.getCacheRootPath(this);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/extensions/plantuml/PlantUMLProvider$Companion;", "", "()V", "storeDiagram", "", "source", "", "fileName", "intellij.markdown"})
    public static final class Companion {
        private final void storeDiagram(String source, String fileName) throws IOException {
            SourceStringReader reader = new SourceStringReader(source);
            FileOutputStream fos = new FileOutputStream(fileName);
            reader.outputImage((OutputStream)fos, new FileFormatOption(FileFormat.PNG));
            fos.close();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

