/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public class MarkdownPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    private static final long PARSING_CALL_TIMEOUT_MS = 50L;
    private static final long RENDERING_DELAY_MS = 20L;
    static final NotNullLazyValue<PolicyFactory> SANITIZER_VALUE = new NotNullLazyValue<PolicyFactory>(){

        @NotNull
        protected PolicyFactory compute() {
            PolicyFactory policyFactory = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"file", "http", "https"}).allowElements(new String[]{"img"}).allowAttributes(new String[]{"alt", "src", "title"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "height", "width"}).onElements(new String[]{"img"}).toFactory()).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"http", "https"}).allowElements(new String[]{"input"}).allowAttributes(new String[]{"type", "class", "checked", "disabled"}).onElements(new String[]{"input"}).toFactory()).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"http", "https"}).allowElements(new String[]{"li"}).allowAttributes(new String[]{"class"}).onElements(new String[]{"li"}).toFactory()).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"file", "http", "https", "mailto"}).allowElements(new String[]{"a"}).allowAttributes(new String[]{"href", "title"}).onElements(new String[]{"a"}).toFactory()).and(Sanitizers.TABLES).and(new HtmlPolicyBuilder().allowElements(new String[]{"body", "pre"}).allowAttributes(new String[]{HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME()}).globally().toFactory()).and(new HtmlPolicyBuilder().allowElements(new String[]{"hr"}).toFactory()).and(new HtmlPolicyBuilder().allowElements(new String[]{"code", "tr"}).allowAttributes(new String[]{"class"}).onElements(new String[]{"code", "tr"}).toFactory());
            if (policyFactory == null) {
                1.$$$reportNull$$$0(0);
            }
            return policyFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$1", "compute"));
        }
    };
    @NotNull
    private final JPanel myHtmlPanelWrapper;
    @NotNull
    private MarkdownHtmlPanel myPanel;
    @Nullable
    private MarkdownHtmlPanelProvider.ProviderInfo myLastPanelProviderInfo;
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Document myDocument;
    @NotNull
    private final Alarm myPooledAlarm;
    @NotNull
    private final Alarm mySwingAlarm;
    private final Object REQUESTS_LOCK;
    @Nullable
    private Runnable myLastScrollRequest;
    @Nullable
    private Runnable myLastHtmlOrRefreshRequest;
    private volatile int myLastScrollOffset;
    @NotNull
    private String myLastRenderedHtml;

    public MarkdownPreviewFileEditor(@NotNull VirtualFile file) {
        if (file == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(0);
        }
        this.myLastPanelProviderInfo = null;
        this.myPooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySwingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.REQUESTS_LOCK = new Object();
        this.myLastScrollRequest = null;
        this.myLastHtmlOrRefreshRequest = null;
        this.myLastRenderedHtml = "";
        this.myFile = file;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        if (this.myDocument != null) {
            this.myDocument.addDocumentListener(new DocumentListener(){

                public void beforeDocumentChange(DocumentEvent e) {
                    MarkdownPreviewFileEditor.this.myPooledAlarm.cancelAllRequests();
                }

                public void documentChanged(DocumentEvent e) {
                    MarkdownPreviewFileEditor.this.myPooledAlarm.addRequest(() -> MarkdownPreviewFileEditor.this.updateHtml(true), 50L);
                }
            }, (Disposable)this);
        }
        this.myHtmlPanelWrapper = new JPanel(new BorderLayout());
        MarkdownApplicationSettings settings = MarkdownApplicationSettings.getInstance();
        this.myPanel = MarkdownPreviewFileEditor.detachOldPanelAndCreateAndAttachNewOne(this.myHtmlPanelWrapper, null, this.retrievePanelProvider(settings));
        MarkdownPreviewFileEditor.updatePanelCssSettings(this.myPanel, settings.getMarkdownCssSettings());
        MessageBusConnection settingsConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        MyUpdatePanelOnSettingsChangedListener settingsChangedListener = new MyUpdatePanelOnSettingsChangedListener();
        settingsConnection.subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToSrcOffset(int offset) {
        if (!this.myPooledAlarm.isEmpty()) {
            this.myLastScrollOffset = offset;
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastScrollRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastScrollRequest);
            }
            this.myLastScrollRequest = () -> {
                this.myLastScrollOffset = offset;
                this.myPanel.scrollToMarkdownSrcOffset(this.myLastScrollOffset);
                Object object = this.REQUESTS_LOCK;
                synchronized (object) {
                    this.myLastScrollRequest = null;
                }
            };
            this.mySwingAlarm.addRequest(this.myLastScrollRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myHtmlPanelWrapper;
        if (jPanel == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getComponent();
    }

    @NotNull
    public String getName() {
        if ("Markdown HTML Preview" == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return "Markdown HTML Preview";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.myPooledAlarm.cancelAllRequests();
        this.myPooledAlarm.addRequest(() -> this.updateHtml(true), 0);
    }

    @Nullable(value="Null means leave current panel")
    private MarkdownHtmlPanelProvider retrievePanelProvider(@NotNull MarkdownApplicationSettings settings) {
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo;
        if (settings == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(4);
        }
        if ((providerInfo = settings.getMarkdownPreviewSettings().getHtmlPanelProviderInfo()).equals(this.myLastPanelProviderInfo)) {
            return null;
        }
        MarkdownHtmlPanelProvider provider = MarkdownHtmlPanelProvider.createFromInfo(providerInfo);
        if (provider.isAvailable() != MarkdownHtmlPanelProvider.AvailabilityInfo.AVAILABLE) {
            settings.setMarkdownPreviewSettings(new MarkdownPreviewSettings(settings.getMarkdownPreviewSettings().getSplitEditorLayout(), MarkdownPreviewSettings.DEFAULT.getHtmlPanelProviderInfo(), settings.getMarkdownPreviewSettings().isUseGrayscaleRendering(), settings.getMarkdownPreviewSettings().isAutoScrollPreview()));
            Messages.showMessageDialog((Component)this.myHtmlPanelWrapper, (String)("Tried to use preview panel provider (" + providerInfo.getName() + "), but it is unavailable. Reverting to default."), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            provider = MarkdownHtmlPanelProvider.getProviders()[0];
        }
        this.myLastPanelProviderInfo = settings.getMarkdownPreviewSettings().getHtmlPanelProviderInfo();
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtml(boolean preserveScrollOffset) {
        if (!this.myFile.isValid() || this.myDocument == null || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        String html = MarkdownUtil.generateMarkdownHtml(this.myFile, this.myDocument.getText());
        if (!this.myFile.isValid() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastHtmlOrRefreshRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastHtmlOrRefreshRequest);
            }
            this.myLastHtmlOrRefreshRequest = () -> {
                String currentHtml = "<html><head></head>" + ((PolicyFactory)SANITIZER_VALUE.getValue()).sanitize(html) + "</html>";
                if (!currentHtml.equals(this.myLastRenderedHtml)) {
                    this.myLastRenderedHtml = currentHtml;
                    this.myPanel.setHtml(this.myLastRenderedHtml);
                    if (preserveScrollOffset) {
                        this.scrollToSrcOffset(this.myLastScrollOffset);
                    }
                }
                this.myPanel.render();
                Object object = this.REQUESTS_LOCK;
                synchronized (object) {
                    this.myLastHtmlOrRefreshRequest = null;
                }
            };
            this.mySwingAlarm.addRequest(this.myLastHtmlOrRefreshRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myPanel);
    }

    @Contract(value="_, null, null -> fail")
    @NotNull
    private static MarkdownHtmlPanel detachOldPanelAndCreateAndAttachNewOne(@NotNull JPanel panelWrapper, @Nullable MarkdownHtmlPanel oldPanel, @Nullable MarkdownHtmlPanelProvider newPanelProvider) {
        if (panelWrapper == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (oldPanel == null && newPanelProvider == null) {
            throw new IllegalArgumentException("Either create new one or leave the old");
        }
        if (newPanelProvider == null) {
            MarkdownHtmlPanel markdownHtmlPanel = oldPanel;
            if (markdownHtmlPanel == null) {
                MarkdownPreviewFileEditor.$$$reportNull$$$0(8);
            }
            return markdownHtmlPanel;
        }
        if (oldPanel != null) {
            panelWrapper.remove(oldPanel.getComponent());
            Disposer.dispose((Disposable)oldPanel);
        }
        MarkdownHtmlPanel newPanel = newPanelProvider.createHtmlPanel();
        panelWrapper.add((Component)newPanel.getComponent(), "Center");
        panelWrapper.repaint();
        MarkdownHtmlPanel markdownHtmlPanel = newPanel;
        if (markdownHtmlPanel == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(9);
        }
        return markdownHtmlPanel;
    }

    private static void updatePanelCssSettings(@NotNull MarkdownHtmlPanel panel, @NotNull MarkdownCssSettings cssSettings) {
        if (panel == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(10);
        }
        if (cssSettings == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String inlineCss = cssSettings.isTextEnabled() ? cssSettings.getStylesheetText() : null;
        String customCssURI = cssSettings.isUriEnabled() ? cssSettings.getStylesheetUri() : MarkdownCssSettings.getDefaultCssSettings(UIUtil.isUnderDarcula()).getStylesheetUri();
        panel.setCSS(inlineCss, customCssURI);
        panel.render();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panelWrapper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "detachOldPanelAndCreateAndAttachNewOne";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "retrievePanelProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detachOldPanelAndCreateAndAttachNewOne";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updatePanelCssSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyUpdatePanelOnSettingsChangedListener
    implements MarkdownApplicationSettings.SettingsChangedListener {
        private MyUpdatePanelOnSettingsChangedListener() {
        }

        @Override
        public void beforeSettingsChanged(@NotNull MarkdownApplicationSettings settings) {
            if (settings == null) {
                MyUpdatePanelOnSettingsChangedListener.$$$reportNull$$$0(0);
            }
            MarkdownHtmlPanelProvider newPanelProvider = MarkdownPreviewFileEditor.this.retrievePanelProvider(settings);
            MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                if (settings == null) {
                    MyUpdatePanelOnSettingsChangedListener.$$$reportNull$$$0(1);
                }
                MarkdownPreviewFileEditor.this.myPanel = MarkdownPreviewFileEditor.detachOldPanelAndCreateAndAttachNewOne(MarkdownPreviewFileEditor.this.myHtmlPanelWrapper, MarkdownPreviewFileEditor.this.myPanel, newPanelProvider);
                MarkdownPreviewFileEditor.this.myPanel.setHtml(MarkdownPreviewFileEditor.this.myLastRenderedHtml);
                MarkdownPreviewFileEditor.updatePanelCssSettings(MarkdownPreviewFileEditor.this.myPanel, settings.getMarkdownCssSettings());
            }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$MyUpdatePanelOnSettingsChangedListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSettingsChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$beforeSettingsChanged$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

