/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.rest.editor.RestPreviewProvider;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rest/RestPythonPreviewProvider;", "Lcom/jetbrains/rest/editor/RestPreviewProvider;", "()V", "toHtml", "Lkotlin/Pair;", "", "text", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.reStructuredText"})
public final class RestPythonPreviewProvider
extends RestPreviewProvider {
    @Nullable
    public Pair<String, String> toHtml(@NotNull String text, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        ProcessOutput output;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Module module = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(virtualFile);
        if (module == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ProjectFileIndex.SERVICE\u2026rtualFile) ?: return null");
        Module module2 = module;
        Sdk sdk = PythonSdkType.findPythonSdk((Module)module2);
        if (sdk == null) {
            return new Pair((Object)"", (Object)"No Python interpreter configured for the project.");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"PythonSdkType.findPython\u2026igured for the project.\")");
        Sdk sdk2 = sdk;
        GeneralCommandLine generalCommandLine = PythonHelper.REST_RUNNER.newCommandLine(sdk2, (List)Lists.newArrayList((Object[])new String[]{"rst2html"}));
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"REST_RUNNER.newCommandLi\u2026newArrayList(\"rst2html\"))");
        GeneralCommandLine commandLine = generalCommandLine;
        VirtualFile virtualFile2 = virtualFile.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"virtualFile.parent");
        String string = virtualFile2.getPath();
        String string2 = text;
        Charset charset = CharsetToolkit.UTF8_CHARSET;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"CharsetToolkit.UTF8_CHARSET");
        Charset charset2 = charset;
        int n = 5000;
        Map map = null;
        String string3 = string;
        GeneralCommandLine generalCommandLine2 = commandLine;
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        ProcessOutput processOutput = output = PySdkUtil.getProcessOutput((GeneralCommandLine)generalCommandLine2, (String)string3, map, (int)n, (byte[])byArray2, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"output");
        return processOutput.isCancelled() || output.isTimeout() ? new Pair((Object)"", (Object)"Failed to generate html.") : new Pair((Object)output.getStdout(), (Object)("<h3>Error output:</h3>" + output.getStderr()));
    }
}

