/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiTaskExecutor;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubParseException;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004IJKLBo\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00128\b\u0002\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010+\u001a\u00020,2\n\u0010-\u001a\u00060\u0014R\u00020\u0000H\u0002J\b\u0010.\u001a\u00020\u0012H\u0014J\n\u0010/\u001a\u0004\u0018\u000100H\u0014J\b\u00101\u001a\u00020\u0012H\u0014J\b\u00102\u001a\u00020,H\u0014J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020#04H\u0014J\u0006\u00105\u001a\u00020\bJ\b\u00106\u001a\u000200H\u0016J\u0006\u00107\u001a\u00020\u000bJ\u0006\u00108\u001a\u00020\bJ\u001c\u00109\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010#0:j\u0002`;2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020\rH\u0002J \u0010@\u001a\u00020\u00002\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\bH\u0007J\u000e\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020DJ\u001a\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\b2\b\b\u0002\u0010G\u001a\u00020\rH\u0007J\u0014\u0010H\u001a\u00020\u00002\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R>\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0012\u0010)\u001a\u00060*R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Component;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "title", "message", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Lkotlin/jvm/functions/Function2;Ljava/lang/String;Ljava/lang/String;)V", "centerPanel", "Lcom/intellij/ui/components/panels/Wrapper;", "currentUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$CredentialsUI;", "login", "passwordUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$LoginPasswordCredentialsUI;", "progressExtension", "Lcom/intellij/ui/components/fields/ExtendableTextComponent$Extension;", "progressIcon", "Lcom/intellij/ui/AnimatedIcon$Default;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "southAdditionalPanel", "token", "tokenAcquisitionError", "Lcom/intellij/openapi/ui/ValidationInfo;", "tokenNote", "getTokenNote", "()Ljava/lang/String;", "setTokenNote", "(Ljava/lang/String;)V", "tokenUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$TokenCredentialsUI;", "applyUi", "", "ui", "createCenterPanel", "createNorthPanel", "Ljavax/swing/JComponent;", "createSouthAdditionalPanel", "doOKAction", "doValidateAll", "", "getLogin", "getPreferredFocusedComponent", "getServer", "getToken", "serverPathValidator", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "textField", "Ljavax/swing/JTextField;", "setBusy", "busy", "withCredentials", "password", "withError", "exception", "", "withServer", "path", "editable", "withToken", "CredentialsUI", "LoginNotUniqueException", "LoginPasswordCredentialsUI", "TokenCredentialsUI", "intellij.vcs.github"})
public final class GithubLoginDialog
extends DialogWrapper {
    private final ExtendableTextField serverTextField;
    private Wrapper centerPanel;
    private Wrapper southAdditionalPanel;
    private LoginPasswordCredentialsUI passwordUi;
    private TokenCredentialsUI tokenUi;
    private CredentialsUI currentUi;
    private ProgressIndicator progressIndicator;
    private final AnimatedIcon.Default progressIcon;
    private final ExtendableTextComponent.Extension progressExtension;
    private String login;
    private String token;
    @NotNull
    private String tokenNote;
    private ValidationInfo tokenAcquisitionError;
    private final Project project;
    private final Function2<String, GithubServerPath, Boolean> isAccountUnique;
    private final String message;

    @NotNull
    public final String getTokenNote() {
        return this.tokenNote;
    }

    public final void setTokenNote(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.tokenNote = string;
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withServer(@NotNull String path, boolean editable) {
        ExtendableTextField extendableTextField;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ExtendableTextField $receiver = extendableTextField = this.serverTextField;
        $receiver.setText(path);
        $receiver.setEditable(editable);
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ GithubLoginDialog withServer$default(GithubLoginDialog githubLoginDialog, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return githubLoginDialog.withServer(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withServer(@NotNull String path) {
        return GithubLoginDialog.withServer$default(this, path, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withCredentials(@Nullable String login2, @Nullable String password) {
        if (login2 != null) {
            this.passwordUi.setLogin(login2);
        }
        if (password != null) {
            this.passwordUi.setPassword(password);
        }
        this.applyUi(this.passwordUi);
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ GithubLoginDialog withCredentials$default(GithubLoginDialog githubLoginDialog, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return githubLoginDialog.withCredentials(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withCredentials(@Nullable String login2) {
        return GithubLoginDialog.withCredentials$default(this, login2, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withCredentials() {
        return GithubLoginDialog.withCredentials$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withToken(@Nullable String token2) {
        if (token2 != null) {
            this.tokenUi.setToken(token2);
        }
        this.applyUi(this.tokenUi);
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ GithubLoginDialog withToken$default(GithubLoginDialog githubLoginDialog, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return githubLoginDialog.withToken(string);
    }

    @JvmOverloads
    @NotNull
    public final GithubLoginDialog withToken() {
        return GithubLoginDialog.withToken$default(this, null, 1, null);
    }

    @NotNull
    public final GithubLoginDialog withError(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.tokenAcquisitionError = credentialsUI.handleAcquireError(exception);
        this.startTrackingValidation();
        return this;
    }

    @NotNull
    public final GithubServerPath getServer() {
        GithubServerPath githubServerPath = GithubServerPath.from(this.serverTextField.getText());
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.from(serverTextField.text)");
        return githubServerPath;
    }

    @NotNull
    public final String getLogin() {
        String string = this.login;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"login");
        }
        return string;
    }

    @NotNull
    public final String getToken() {
        String string = this.token;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"token");
        }
        return string;
    }

    protected void doOKAction() {
        this.setBusy(true);
        this.tokenAcquisitionError = null;
        Object object = ServiceManager.getService(ProgressManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        ProgressManager progressManager = (ProgressManager)object;
        Task.Backgroundable backgroundable = new Task.Backgroundable(this, this.project, "Not Visible"){
            final /* synthetic */ GithubLoginDialog this$0;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void newLogin;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Pair<String, String> pair = GithubLoginDialog.access$getCurrentUi$p(this.this$0).acquireLoginAndToken(indicator);
                String string = (String)pair.component1();
                String newToken = (String)pair.component2();
                GithubLoginDialog.access$setLogin$p(this.this$0, (String)newLogin);
                GithubLoginDialog.access$setToken$p(this.this$0, newToken);
            }

            public void onSuccess() {
                this.this$0.close(0, true);
                GithubLoginDialog.access$setBusy(this.this$0, false);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubLoginDialog.access$startTrackingValidation(this.this$0);
                GithubLoginDialog.access$setTokenAcquisitionError$p(this.this$0, GithubLoginDialog.access$getCurrentUi$p(this.this$0).handleAcquireError(error));
                GithubLoginDialog.access$setBusy(this.this$0, false);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            Intrinsics.throwNpe();
        }
        progressManager.runProcessWithProgressAsynchronously(backgroundable, progressIndicator);
    }

    private final void setBusy(boolean busy) {
        if (busy) {
            if (!this.serverTextField.getExtensions().contains(this.progressExtension)) {
                this.serverTextField.addExtension(this.progressExtension);
            }
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.cancel();
            }
            this.progressIndicator = (ProgressIndicator)new EmptyProgressIndicator(ModalityState.stateForComponent((Component)this.getWindow()));
            Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(this){
                final /* synthetic */ GithubLoginDialog this$0;

                public final void dispose() {
                    block0: {
                        ProgressIndicator progressIndicator = GithubLoginDialog.access$getProgressIndicator$p(this.this$0);
                        if (progressIndicator == null) break block0;
                        progressIndicator.cancel();
                    }
                }
                {
                    this.this$0 = githubLoginDialog;
                }
            });
        } else {
            this.serverTextField.removeExtension(this.progressExtension);
            this.progressIndicator = null;
        }
        this.serverTextField.setEnabled(!busy);
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        credentialsUI.setBusy(busy);
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JTextArea jTextArea;
        String string = this.message;
        if (string != null) {
            JTextArea jTextArea2;
            String string2;
            String it = string2 = string;
            JTextArea $receiver = jTextArea2 = new JTextArea();
            $receiver.setFont(UIUtil.getLabelFont());
            $receiver.setText(it);
            $receiver.setEditable(false);
            $receiver.setFocusable(false);
            $receiver.setOpaque(false);
            $receiver.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
            $receiver.setMargin((Insets)JBUI.emptyInsets());
            jTextArea = jTextArea2;
        } else {
            jTextArea = null;
        }
        return jTextArea;
    }

    @NotNull
    protected Wrapper createSouthAdditionalPanel() {
        return this.southAdditionalPanel;
    }

    @NotNull
    protected Wrapper createCenterPanel() {
        return this.centerPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        return credentialsUI.getPreferredFocus();
    }

    private final void applyUi(CredentialsUI ui) {
        CredentialsUI credentialsUI = this.currentUi = ui;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.centerPanel.setContent((JComponent)credentialsUI.getPanel());
        CredentialsUI credentialsUI2 = this.currentUi;
        if (credentialsUI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.southAdditionalPanel.setContent(credentialsUI2.getSouthPanel());
        this.setErrorText(null);
        CredentialsUI credentialsUI3 = this.currentUi;
        if (credentialsUI3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        credentialsUI3.getPreferredFocus().requestFocus();
        this.tokenAcquisitionError = null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void var3_3;
        void $receiver$iv$iv;
        Object[] objectArray = new Function0[2];
        Function0[] function0Array = new Function0[2];
        function0Array[0] = DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubLoginDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return DialogValidationUtils.INSTANCE.notBlank((JTextField)GithubLoginDialog.access$getServerTextField$p(this.this$0), "Server cannot be empty");
            }
            {
                this.this$0 = githubLoginDialog;
                super(0);
            }
        }, this.serverPathValidator((JTextField)this.serverTextField));
        CredentialsUI credentialsUI = this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        function0Array[1] = credentialsUI.getValidator();
        objectArray[0] = DialogValidationUtils.INSTANCE.chain(function0Array);
        objectArray[1] = (Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubLoginDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return GithubLoginDialog.access$getTokenAcquisitionError$p(this.this$0);
            }
            {
                this.this$0 = githubLoginDialog;
                super(0);
            }
        };
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])objectArray);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ValidationInfo validationInfo;
            Object element$iv$iv = element$iv$iv$iv;
            Function0 it = (Function0)element$iv$iv;
            if ((ValidationInfo)it.invoke() == null) continue;
            ValidationInfo it$iv$iv = validationInfo;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    private final Function0<ValidationInfo> serverPathValidator(JTextField textField) {
        return (Function0)new Function0<ValidationInfo>(textField){
            final /* synthetic */ JTextField $textField;

            @Nullable
            public final ValidationInfo invoke() {
                ValidationInfo validationInfo;
                String text = this.$textField.getText();
                try {
                    GithubServerPath.from(text);
                    validationInfo = null;
                }
                catch (Exception e) {
                    validationInfo = new ValidationInfo(text + " is not a valid server path:\n" + e.getMessage(), (JComponent)this.$textField);
                }
                return validationInfo;
            }
            {
                this.$textField = jTextField;
                super(0);
            }
        };
    }

    @JvmOverloads
    public GithubLoginDialog(@Nullable Project project, @Nullable Component parent, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, @NotNull String title, @Nullable String message) {
        Wrapper wrapper;
        Intrinsics.checkParameterIsNotNull(isAccountUnique, (String)"isAccountUnique");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        super(project, parent, false, DialogWrapper.IdeModalityType.PROJECT);
        this.project = project;
        this.isAccountUnique = isAccountUnique;
        this.message = message;
        this.serverTextField = new ExtendableTextField("github.com");
        this.centerPanel = new Wrapper();
        Wrapper wrapper2 = new Wrapper();
        GithubLoginDialog githubLoginDialog = this;
        Wrapper $receiver = wrapper2;
        JBUI.Borders.emptyRight((int)10);
        githubLoginDialog.southAdditionalPanel = wrapper = wrapper2;
        this.passwordUi = new LoginPasswordCredentialsUI();
        this.tokenUi = new TokenCredentialsUI();
        this.progressIcon = new AnimatedIcon.Default();
        this.progressExtension = new ExtendableTextComponent.Extension(this){
            final /* synthetic */ GithubLoginDialog this$0;

            @NotNull
            public final AnimatedIcon.Default getIcon(boolean it) {
                return GithubLoginDialog.access$getProgressIcon$p(this.this$0);
            }
            {
                this.this$0 = githubLoginDialog;
            }
        };
        this.tokenNote = "IntelliJ Plugin";
        this.setTitle(title);
        this.setOKButtonText("Log In");
        this.applyUi(this.passwordUi);
        this.init();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public final void dispose() {
                block0: {
                    ProgressIndicator progressIndicator = progressIndicator;
                    if (progressIndicator == null) break block0;
                    progressIndicator.cancel();
                }
            }
        });
    }

    @JvmOverloads
    public /* synthetic */ GithubLoginDialog(Project project, Component component, Function2 function2, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            project = null;
        }
        if ((n & 2) != 0) {
            component = null;
        }
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            string = "Log In to Github";
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        this(project, component, (Function2<? super String, ? super GithubServerPath, Boolean>)function2, string, string2);
    }

    @JvmOverloads
    public GithubLoginDialog(@Nullable Project project, @Nullable Component parent, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, @NotNull String title) {
        this(project, parent, isAccountUnique, title, null, 16, null);
    }

    @JvmOverloads
    public GithubLoginDialog(@Nullable Project project, @Nullable Component parent, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique) {
        this(project, parent, isAccountUnique, null, null, 24, null);
    }

    @JvmOverloads
    public GithubLoginDialog(@Nullable Project project, @Nullable Component parent) {
        this(project, parent, null, null, null, 28, null);
    }

    @JvmOverloads
    public GithubLoginDialog(@Nullable Project project) {
        this(project, null, null, null, null, 30, null);
    }

    @JvmOverloads
    public GithubLoginDialog() {
        this(null, null, null, null, null, 31, null);
    }

    public static final /* synthetic */ void access$applyUi(GithubLoginDialog $this, @NotNull CredentialsUI ui) {
        $this.applyUi(ui);
    }

    @NotNull
    public static final /* synthetic */ TokenCredentialsUI access$getTokenUi$p(GithubLoginDialog $this) {
        return $this.tokenUi;
    }

    public static final /* synthetic */ void access$setTokenUi$p(GithubLoginDialog $this, @NotNull TokenCredentialsUI tokenCredentialsUI) {
        $this.tokenUi = tokenCredentialsUI;
    }

    @NotNull
    public static final /* synthetic */ LoginPasswordCredentialsUI access$getPasswordUi$p(GithubLoginDialog $this) {
        return $this.passwordUi;
    }

    public static final /* synthetic */ void access$setPasswordUi$p(GithubLoginDialog $this, @NotNull LoginPasswordCredentialsUI loginPasswordCredentialsUI) {
        $this.passwordUi = loginPasswordCredentialsUI;
    }

    @NotNull
    public static final /* synthetic */ CredentialsUI access$getCurrentUi$p(GithubLoginDialog $this) {
        CredentialsUI credentialsUI = $this.currentUi;
        if (credentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        return credentialsUI;
    }

    public static final /* synthetic */ void access$setCurrentUi$p(GithubLoginDialog $this, @NotNull CredentialsUI credentialsUI) {
        $this.currentUi = credentialsUI;
    }

    @NotNull
    public static final /* synthetic */ String access$getLogin$p(GithubLoginDialog $this) {
        String string = $this.login;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"login");
        }
        return string;
    }

    public static final /* synthetic */ void access$setLogin$p(GithubLoginDialog $this, @NotNull String string) {
        $this.login = string;
    }

    @NotNull
    public static final /* synthetic */ String access$getToken$p(GithubLoginDialog $this) {
        String string = $this.token;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"token");
        }
        return string;
    }

    public static final /* synthetic */ void access$setToken$p(GithubLoginDialog $this, @NotNull String string) {
        $this.token = string;
    }

    public static final /* synthetic */ void access$setBusy(GithubLoginDialog $this, boolean busy) {
        $this.setBusy(busy);
    }

    public static final /* synthetic */ void access$startTrackingValidation(GithubLoginDialog $this) {
        $this.startTrackingValidation();
    }

    @Nullable
    public static final /* synthetic */ ValidationInfo access$getTokenAcquisitionError$p(GithubLoginDialog $this) {
        return $this.tokenAcquisitionError;
    }

    public static final /* synthetic */ void access$setTokenAcquisitionError$p(GithubLoginDialog $this, @Nullable ValidationInfo validationInfo) {
        $this.tokenAcquisitionError = validationInfo;
    }

    public static final /* synthetic */ void access$setProgressIndicator$p(GithubLoginDialog $this, @Nullable ProgressIndicator progressIndicator) {
        $this.progressIndicator = progressIndicator;
    }

    @NotNull
    public static final /* synthetic */ AnimatedIcon.Default access$getProgressIcon$p(GithubLoginDialog $this) {
        return $this.progressIcon;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015j\u0002`\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\fJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$LoginPasswordCredentialsUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$CredentialsUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;", "(Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;)V", "contextHelp", "Ljavax/swing/JEditorPane;", "loginTextField", "Lcom/intellij/ui/components/JBTextField;", "passwordField", "Ljavax/swing/JPasswordField;", "acquireLoginAndToken", "Lkotlin/Pair;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getPanel", "Ljavax/swing/JPanel;", "getPreferredFocus", "getSouthPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "", "busy", "", "setLogin", "login", "setPassword", "password", "intellij.vcs.github"})
    private final class LoginPasswordCredentialsUI
    extends CredentialsUI {
        private final JBTextField loginTextField;
        private final JPasswordField passwordField;
        private final JEditorPane contextHelp;

        public final void setLogin(@NotNull String login2) {
            Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
            this.loginTextField.setText(login2);
        }

        public final void setPassword(@NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            this.passwordField.setText(password);
        }

        @Override
        @NotNull
        public JPanel getPanel() {
            JPanel jPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)GithubLoginDialog.this.serverTextField)).withLabel("Server:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.loginTextField)).withLabel("Login:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.passwordField).withLabel("Password:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.contextHelp)).createPanel();
            Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"grid()\n      .add(panel(\u2026ntextHelp)).createPanel()");
            return jPanel;
        }

        @NotNull
        public JBTextField getPreferredFocus() {
            return this.loginTextField;
        }

        @Override
        @NotNull
        public Function0<ValidationInfo> getValidator() {
            return DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ LoginPasswordCredentialsUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank((JTextField)LoginPasswordCredentialsUI.access$getLoginTextField$p(this.this$0), "Login cannot be empty");
                }
                {
                    this.this$0 = loginPasswordCredentialsUI;
                    super(0);
                }
            }, (Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ LoginPasswordCredentialsUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank(LoginPasswordCredentialsUI.access$getPasswordField$p(this.this$0), "Password cannot be empty");
                }
                {
                    this.this$0 = loginPasswordCredentialsUI;
                    super(0);
                }
            });
        }

        @NotNull
        public BorderLayoutPanel getSouthPanel() {
            BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToCenter((Component)LinkLabel.create((String)"Sign up for Github", (Runnable)getSouthPanel.1.INSTANCE)).addToRight((Component)new JBLabel(AllIcons.Ide.External_link_arrow));
            Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"JBUI.Panels.simplePanel(\u2026Ide.External_link_arrow))");
            return borderLayoutPanel;
        }

        @Override
        @NotNull
        public Pair<String, String> acquireLoginAndToken(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            GithubServerPath server = GithubLoginDialog.this.getServer();
            Function2 function2 = GithubLoginDialog.this.isAccountUnique;
            String string = this.loginTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loginTextField.text");
            if (!((Boolean)function2.invoke((Object)string, (Object)server)).booleanValue()) {
                throw (Throwable)new LoginNotUniqueException(null, 1, null);
            }
            String string2 = this.loginTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"loginTextField.text");
            char[] cArray = this.passwordField.getPassword();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"passwordField.password");
            String token2 = (String)GithubApiTaskExecutor.Companion.execute(indicator, server, string2, cArray, (ThrowableConvertor)new ThrowableConvertor<GithubConnection, String, IOException>(this){
                final /* synthetic */ LoginPasswordCredentialsUI this$0;

                @NotNull
                public final String convert(GithubConnection it) {
                    return GithubApiUtil.getMasterToken(it, this.this$0.GithubLoginDialog.this.getTokenNote());
                }
                {
                    this.this$0 = loginPasswordCredentialsUI;
                }
            });
            return TuplesKt.to((Object)this.loginTextField.getText(), (Object)token2);
        }

        @Override
        @NotNull
        public ValidationInfo handleAcquireError(@NotNull Throwable error) {
            ValidationInfo validationInfo;
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            Throwable throwable = error;
            if (throwable instanceof LoginNotUniqueException) {
                validationInfo = new ValidationInfo("Account already added", (JComponent)this.loginTextField);
            } else if (throwable instanceof UnknownHostException) {
                validationInfo = new ValidationInfo("Server is unreachable", false);
            } else if (throwable instanceof GithubAuthenticationException) {
                validationInfo = new ValidationInfo("Incorrect credentials.", false);
            } else if (throwable instanceof GithubParseException) {
                String string = error.getMessage();
                if (string == null) {
                    string = "Invalid server path";
                }
                validationInfo = new ValidationInfo(string, (JComponent)GithubLoginDialog.this.serverTextField);
            } else {
                validationInfo = new ValidationInfo("Invalid authentication data.\n " + error.getMessage(), false);
            }
            return validationInfo;
        }

        @Override
        public void setBusy(boolean busy) {
            this.loginTextField.setEnabled(!busy);
            this.passwordField.setEnabled(!busy);
            this.contextHelp.setEnabled(!busy);
        }

        public LoginPasswordCredentialsUI() {
            JEditorPane jEditorPane;
            this.loginTextField = new JBTextField();
            this.passwordField = new JPasswordField();
            JEditorPane $receiver = jEditorPane = (this.contextHelp = new JEditorPane());
            $receiver.setEditorKit(UIUtil.getHTMLEditorKit());
            Color color = JBColor.link();
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"JBColor.link()");
            Color linkColor = color;
            EditorKit editorKit = $receiver.getEditorKit();
            if (editorKit == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.text.html.HTMLEditorKit");
            }
            ((HTMLEditorKit)editorKit).getStyleSheet().addRule("a {color: rgb(" + linkColor.getRed() + ", " + linkColor.getGreen() + ", " + linkColor.getBlue() + ")}");
            $receiver.setText("<html>Password is not saved and used only to <br>acquire Github token. <a href=''>Enter token</a></html>");
            $receiver.addHyperlinkListener(new HyperlinkListener($receiver, this){
                final /* synthetic */ JEditorPane receiver$0;
                final /* synthetic */ LoginPasswordCredentialsUI this$0;
                {
                    this.receiver$0 = jEditorPane;
                    this.this$0 = loginPasswordCredentialsUI;
                }

                public final void hyperlinkUpdate(HyperlinkEvent e) {
                    HyperlinkEvent hyperlinkEvent = e;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hyperlinkEvent, (String)"e");
                    if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        GithubLoginDialog.access$applyUi(this.this$0.GithubLoginDialog.this, GithubLoginDialog.access$getTokenUi$p(this.this$0.GithubLoginDialog.this));
                    } else {
                        this.receiver$0.setCursor(Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ENTERED) ? new Cursor(12) : new Cursor(0));
                    }
                }
            });
            $receiver.setEditable(false);
            $receiver.setFocusable(false);
            $receiver.setOpaque(false);
            $receiver.setBorder(null);
            $receiver.setMargin((Insets)JBUI.emptyInsets());
            $receiver.setForeground((Color)JBColor.GRAY);
        }

        @NotNull
        public static final /* synthetic */ JBTextField access$getLoginTextField$p(LoginPasswordCredentialsUI $this) {
            return $this.loginTextField;
        }

        @NotNull
        public static final /* synthetic */ JPasswordField access$getPasswordField$p(LoginPasswordCredentialsUI $this) {
            return $this.passwordField;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0010\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\nR\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$TokenCredentialsUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$CredentialsUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;", "(Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;)V", "switchUiLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "tokenTextField", "Lcom/intellij/ui/components/JBTextField;", "acquireLoginAndToken", "Lkotlin/Pair;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getPanel", "Ljavax/swing/JPanel;", "getPreferredFocus", "getSouthPanel", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "handleAcquireError", "error", "", "setBusy", "", "busy", "", "setToken", "token", "intellij.vcs.github"})
    private final class TokenCredentialsUI
    extends CredentialsUI {
        private final JBTextField tokenTextField;
        private final LinkLabel<?> switchUiLink;

        public final void setToken(@NotNull String token2) {
            Intrinsics.checkParameterIsNotNull((Object)token2, (String)"token");
            this.tokenTextField.setText(token2);
        }

        @Override
        @NotNull
        public JPanel getPanel() {
            JPanel jPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)GithubLoginDialog.this.serverTextField)).withLabel("Server:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.tokenTextField)).withLabel("Token:")).createPanel();
            Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"grid()\n      .add(panel(\u2026(\"Token:\")).createPanel()");
            return jPanel;
        }

        @NotNull
        public JBTextField getPreferredFocus() {
            return this.tokenTextField;
        }

        @Override
        @NotNull
        public Function0<ValidationInfo> getValidator() {
            return (Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ TokenCredentialsUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank((JTextField)TokenCredentialsUI.access$getTokenTextField$p(this.this$0), "Token cannot be empty");
                }
                {
                    this.this$0 = tokenCredentialsUI;
                    super(0);
                }
            };
        }

        @NotNull
        public LinkLabel<?> getSouthPanel() {
            return this.switchUiLink;
        }

        @Override
        @NotNull
        public Pair<String, String> acquireLoginAndToken(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            GithubServerPath githubServerPath = GithubLoginDialog.this.getServer();
            String string = this.tokenTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tokenTextField.text");
            String login2 = (String)GithubApiTaskExecutor.Companion.execute(indicator, githubServerPath, string, acquireLoginAndToken.login.1.INSTANCE);
            Function2 function2 = GithubLoginDialog.this.isAccountUnique;
            String string2 = login2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"login");
            if (!((Boolean)function2.invoke((Object)string2, (Object)GithubLoginDialog.this.getServer())).booleanValue()) {
                throw (Throwable)new LoginNotUniqueException(login2);
            }
            return TuplesKt.to((Object)login2, (Object)this.tokenTextField.getText());
        }

        @Override
        @NotNull
        public ValidationInfo handleAcquireError(@NotNull Throwable error) {
            ValidationInfo validationInfo;
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            Throwable throwable = error;
            if (throwable instanceof LoginNotUniqueException) {
                validationInfo = new ValidationInfo("Account " + ((LoginNotUniqueException)error).getLogin() + " already added", false);
            } else if (throwable instanceof UnknownHostException) {
                validationInfo = new ValidationInfo("Server is unreachable", false);
            } else if (throwable instanceof GithubAuthenticationException) {
                validationInfo = new ValidationInfo("Incorrect credentials.", false);
            } else if (throwable instanceof GithubParseException) {
                String string = error.getMessage();
                if (string == null) {
                    string = "Invalid server path";
                }
                validationInfo = new ValidationInfo(string, (JComponent)GithubLoginDialog.this.serverTextField);
            } else {
                validationInfo = new ValidationInfo("Invalid authentication data.\n " + error.getMessage(), false);
            }
            return validationInfo;
        }

        @Override
        public void setBusy(boolean busy) {
            this.tokenTextField.setEnabled(!busy);
            this.switchUiLink.setEnabled(!busy);
        }

        public TokenCredentialsUI() {
            this.tokenTextField = new JBTextField();
            LinkLabel linkLabel = LinkLabel.create((String)"Log In with Username", (Runnable)new Runnable(this){
                final /* synthetic */ TokenCredentialsUI this$0;

                public final void run() {
                    GithubLoginDialog.access$applyUi(this.this$0.GithubLoginDialog.this, GithubLoginDialog.access$getPasswordUi$p(this.this$0.GithubLoginDialog.this));
                }
                {
                    this.this$0 = tokenCredentialsUI;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)linkLabel, (String)"LinkLabel.create(\"Log In\u2026 { applyUi(passwordUi) })");
            this.switchUiLink = linkLabel;
        }

        @NotNull
        public static final /* synthetic */ JBTextField access$getTokenTextField$p(TokenCredentialsUI $this) {
            return $this.tokenTextField;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\u000bH&J\u0014\u0010\r\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000ej\u0002`\u0010H&J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$CredentialsUI;", "", "(Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;)V", "acquireLoginAndToken", "Lkotlin/Pair;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getPanel", "Ljavax/swing/JPanel;", "getPreferredFocus", "Ljavax/swing/JComponent;", "getSouthPanel", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "", "busy", "", "intellij.vcs.github"})
    private abstract class CredentialsUI {
        @NotNull
        public abstract JPanel getPanel();

        @NotNull
        public abstract JComponent getPreferredFocus();

        @NotNull
        public abstract JComponent getSouthPanel();

        @NotNull
        public abstract Function0<ValidationInfo> getValidator();

        @NotNull
        public abstract Pair<String, String> acquireLoginAndToken(@NotNull ProgressIndicator var1);

        @NotNull
        public abstract ValidationInfo handleAcquireError(@NotNull Throwable var1);

        public abstract void setBusy(boolean var1);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog$LoginNotUniqueException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "login", "", "(Ljava/lang/String;)V", "getLogin", "()Ljava/lang/String;", "intellij.vcs.github"})
    private static final class LoginNotUniqueException
    extends RuntimeException {
        @Nullable
        private final String login;

        @Nullable
        public final String getLogin() {
            return this.login;
        }

        public LoginNotUniqueException(@Nullable String login2) {
            this.login = login2;
        }

        public /* synthetic */ LoginNotUniqueException(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        public LoginNotUniqueException() {
            this(null, 1, null);
        }
    }
}

