/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventProcessorStage;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.SystemLogListener;
import org.apache.solr.cloud.autoscaling.TriggerAction;
import org.apache.solr.cloud.autoscaling.TriggerListener;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScalingHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    public static final String HANDLER_PATH = "/admin/autoscaling";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrCloudManager cloudManager;
    protected final SolrResourceLoader loader;
    protected final AutoScaling.TriggerFactory triggerFactory;
    private final List<Map<String, String>> DEFAULT_ACTIONS = new ArrayList<Map<String, String>>(3);
    private static Set<String> singletonCommands = Stream.of("set-cluster-preferences", "set-cluster-policy").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    private final TimeSource timeSource;
    private static String fullName = SystemLogListener.class.getName();
    private static String solrName = "solr." + SystemLogListener.class.getSimpleName();

    public AutoScalingHandler(SolrCloudManager cloudManager, SolrResourceLoader loader) {
        this.cloudManager = cloudManager;
        this.loader = loader;
        this.triggerFactory = new AutoScaling.TriggerFactoryImpl(loader, cloudManager);
        this.timeSource = cloudManager.getTimeSource();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("name", "compute_plan");
        map.put("class", "solr.ComputePlanAction");
        this.DEFAULT_ACTIONS.add(map);
        map = new HashMap(2);
        map.put("name", "execute_plan");
        map.put("class", "solr.ExecutePlanAction");
        this.DEFAULT_ACTIONS.add(map);
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, final SolrQueryResponse rsp) throws Exception {
        try {
            String httpMethod = (String)req.getContext().get("httpMethod");
            RequestHandlerUtils.setWt(req, "json");
            if ("GET".equals(httpMethod)) {
                List parts;
                String path = (String)req.getContext().get("path");
                if (path == null) {
                    path = "/cluster/autoscaling";
                }
                if (((String)(parts = StrUtils.splitSmart((String)path, (char)'/')).get(0)).isEmpty()) {
                    parts.remove(0);
                }
                if (parts.size() < 2 || parts.size() > 3) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown path: " + path);
                }
                AutoScalingConfig autoScalingConf = this.cloudManager.getDistribStateManager().getAutoScalingConfig();
                if (parts.size() == 2) {
                    autoScalingConf.writeMap(new MapWriter.EntryWriter(){

                        public MapWriter.EntryWriter put(String k, Object v) throws IOException {
                            rsp.getValues().add(k, v);
                            return this;
                        }
                    });
                } else if (parts.size() == 3) {
                    if ("diagnostics".equals(parts.get(2))) {
                        this.handleDiagnostics(rsp, autoScalingConf);
                    } else if ("suggestions".equals(parts.get(2))) {
                        this.handleSuggestions(rsp, autoScalingConf);
                    }
                }
            } else {
                if (req.getContentStreams() == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No commands specified for autoscaling");
                }
                List ops = CommandOperation.readCommands(req.getContentStreams(), (NamedList)rsp.getValues(), singletonCommands);
                if (ops == null) {
                    return;
                }
                this.processOps(req, rsp, ops);
            }
        }
        catch (Exception e) {
            rsp.getValues().add("result", (Object)"failure");
            throw e;
        }
        finally {
            RequestHandlerUtils.addExperimentalFormatWarning(rsp);
        }
    }

    private void handleSuggestions(SolrQueryResponse rsp, AutoScalingConfig autoScalingConf) throws IOException {
        rsp.getValues().add("suggestions", (Object)PolicyHelper.getSuggestions((AutoScalingConfig)autoScalingConf, (SolrCloudManager)this.cloudManager));
    }

    public void processOps(SolrQueryRequest req, SolrQueryResponse rsp, List<CommandOperation> ops) throws KeeperException, InterruptedException, IOException {
        while (true) {
            AutoScalingConfig initialConfig;
            AutoScalingConfig currentConfig = initialConfig = this.cloudManager.getDistribStateManager().getAutoScalingConfig();
            block27: for (CommandOperation op : ops) {
                switch (op.name) {
                    case "set-trigger": {
                        currentConfig = this.handleSetTrigger(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "remove-trigger": {
                        currentConfig = this.handleRemoveTrigger(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "set-listener": {
                        currentConfig = this.handleSetListener(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "remove-listener": {
                        currentConfig = this.handleRemoveListener(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "suspend-trigger": {
                        currentConfig = this.handleSuspendTrigger(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "resume-trigger": {
                        currentConfig = this.handleResumeTrigger(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "set-policy": {
                        currentConfig = this.handleSetPolicies(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "remove-policy": {
                        currentConfig = this.handleRemovePolicy(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "set-cluster-preferences": {
                        currentConfig = this.handleSetClusterPreferences(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "set-cluster-policy": {
                        currentConfig = this.handleSetClusterPolicy(req, rsp, op, currentConfig);
                        continue block27;
                    }
                    case "set-properties": {
                        currentConfig = this.handleSetProperties(req, rsp, op, currentConfig);
                        continue block27;
                    }
                }
                op.addError("Unknown command: " + op.name);
            }
            List errs = CommandOperation.captureErrors(ops);
            if (!errs.isEmpty()) {
                throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "Error in command payload", errs);
            }
            if (currentConfig.equals((Object)initialConfig) || this.setAutoScalingConfig(currentConfig)) break;
            rsp.getValues().add("retry", (Object)("initialVersion=" + initialConfig.getZkVersion()));
        }
        rsp.getValues().add("result", (Object)"success");
    }

    private AutoScalingConfig handleSetProperties(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) {
        Map map = op.getDataMap() == null ? Collections.emptyMap() : op.getDataMap();
        HashMap configProps = new HashMap(currentConfig.getProperties());
        configProps.putAll(map);
        map.forEach((k, v) -> {
            if (v == null) {
                configProps.remove(k);
            }
        });
        return currentConfig.withProperties(configProps);
    }

    private void handleDiagnostics(SolrQueryResponse rsp, AutoScalingConfig autoScalingConf) throws IOException {
        Policy policy = autoScalingConf.getPolicy();
        rsp.getValues().add("diagnostics", (Object)PolicyHelper.getDiagnostics((Policy)policy, (SolrCloudManager)this.cloudManager));
    }

    private AutoScalingConfig handleSetClusterPolicy(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException, IOException {
        List clusterPolicy = (List)op.getCommandData();
        if (clusterPolicy == null || !(clusterPolicy instanceof List)) {
            op.addError("set-cluster-policy expects an array of objects");
            return currentConfig;
        }
        List cp = null;
        try {
            cp = clusterPolicy.stream().map(Clause::create).collect(Collectors.toList());
        }
        catch (Exception e) {
            op.addError(e.getMessage());
            return currentConfig;
        }
        Policy p = currentConfig.getPolicy().withClusterPolicy(cp);
        currentConfig = currentConfig.withPolicy(p);
        return currentConfig;
    }

    private AutoScalingConfig handleSetClusterPreferences(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException, IOException {
        List preferences = (List)op.getCommandData();
        if (preferences == null || !(preferences instanceof List)) {
            op.addError("A list of cluster preferences not found");
            return currentConfig;
        }
        List prefs = null;
        try {
            prefs = preferences.stream().map(Preference::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            op.addError(e.getMessage());
            return currentConfig;
        }
        Policy p = currentConfig.getPolicy().withClusterPreferences(prefs);
        currentConfig = currentConfig.withPolicy(p);
        return currentConfig;
    }

    private AutoScalingConfig handleRemovePolicy(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException, IOException {
        String policyName = (String)op.getVal("");
        if (op.hasError()) {
            return currentConfig;
        }
        HashMap policies = currentConfig.getPolicy().getPolicies();
        if (policies == null || !policies.containsKey(policyName)) {
            op.addError("No policy exists with name: " + policyName);
            return currentConfig;
        }
        this.cloudManager.getClusterStateProvider().getClusterState().forEachCollection(coll -> {
            if (policyName.equals(coll.getPolicyName())) {
                op.addError(StrUtils.formatString((String)"policy : {0} is being used by collection {1}", (Object[])new Object[]{policyName, coll.getName()}));
            }
        });
        if (op.hasError()) {
            return currentConfig;
        }
        policies = new HashMap(policies);
        policies.remove(policyName);
        Policy p = currentConfig.getPolicy().withPolicies(policies);
        currentConfig = currentConfig.withPolicy(p);
        return currentConfig;
    }

    private AutoScalingConfig handleSetPolicies(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException, IOException {
        Map policiesMap = op.getDataMap();
        for (Map.Entry policy : policiesMap.entrySet()) {
            String policyName = (String)policy.getKey();
            if (policyName != null && policyName.trim().length() != 0) continue;
            op.addError("The policy name cannot be null or empty");
            return currentConfig;
        }
        ArrayList params = new ArrayList(currentConfig.getPolicy().getParams());
        HashMap mergedPolicies = new HashMap(currentConfig.getPolicy().getPolicies());
        Map newPolicies = null;
        try {
            newPolicies = Policy.policiesFromMap((Map)((Map)op.getCommandData()), params);
        }
        catch (Exception e) {
            op.addError(e.getMessage());
            return currentConfig;
        }
        mergedPolicies.putAll(newPolicies);
        Policy p = currentConfig.getPolicy().withPolicies(mergedPolicies).withParams(params);
        currentConfig = currentConfig.withPolicy(p);
        return currentConfig;
    }

    private AutoScalingConfig handleResumeTrigger(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException {
        String triggerName = op.getStr("name");
        if (op.hasError()) {
            return currentConfig;
        }
        Map triggers = currentConfig.getTriggerConfigs();
        HashSet changed = new HashSet();
        if (!"#EACH".equals(triggerName) && !triggers.containsKey(triggerName)) {
            op.addError("No trigger exists with name: " + triggerName);
            return currentConfig;
        }
        HashMap newTriggers = new HashMap();
        for (Map.Entry entry : triggers.entrySet()) {
            if ("#EACH".equals(triggerName) || triggerName.equals(entry.getKey())) {
                AutoScalingConfig.TriggerConfig trigger = (AutoScalingConfig.TriggerConfig)entry.getValue();
                if (!trigger.enabled) {
                    trigger = trigger.withEnabled(true);
                    newTriggers.put(entry.getKey(), trigger);
                    changed.add(entry.getKey());
                    continue;
                }
                newTriggers.put(entry.getKey(), entry.getValue());
                continue;
            }
            newTriggers.put(entry.getKey(), entry.getValue());
        }
        rsp.getValues().add("changed", changed);
        if (!changed.isEmpty()) {
            currentConfig = currentConfig.withTriggerConfigs(newTriggers);
        }
        return currentConfig;
    }

    private AutoScalingConfig handleSuspendTrigger(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException {
        String triggerName = op.getStr("name");
        if (op.hasError()) {
            return currentConfig;
        }
        String timeout = op.getStr("timeout", null);
        Date resumeTime = null;
        if (timeout != null) {
            try {
                int timeoutSeconds = this.parseHumanTime(timeout);
                resumeTime = new Date(TimeUnit.MILLISECONDS.convert(this.timeSource.getTimeNs(), TimeUnit.NANOSECONDS) + TimeUnit.MILLISECONDS.convert(timeoutSeconds, TimeUnit.SECONDS));
            }
            catch (IllegalArgumentException e) {
                op.addError("Invalid 'timeout' value for suspend trigger: " + triggerName);
                return currentConfig;
            }
        }
        Map triggers = currentConfig.getTriggerConfigs();
        HashSet<String> changed = new HashSet<String>();
        if (!"#EACH".equals(triggerName) && !triggers.containsKey(triggerName)) {
            op.addError("No trigger exists with name: " + triggerName);
            return currentConfig;
        }
        HashMap newTriggers = new HashMap();
        for (Map.Entry entry : triggers.entrySet()) {
            if ("#EACH".equals(triggerName) || triggerName.equals(entry.getKey())) {
                AutoScalingConfig.TriggerConfig trigger = (AutoScalingConfig.TriggerConfig)entry.getValue();
                if (trigger.enabled) {
                    trigger = trigger.withEnabled(false);
                    if (resumeTime != null) {
                        trigger = trigger.withProperty("resumeAt", (Object)resumeTime.getTime());
                    }
                    newTriggers.put(entry.getKey(), trigger);
                    changed.add(trigger.name);
                    continue;
                }
                newTriggers.put(entry.getKey(), entry.getValue());
                continue;
            }
            newTriggers.put(entry.getKey(), entry.getValue());
        }
        rsp.getValues().add("changed", changed);
        if (!changed.isEmpty()) {
            currentConfig = currentConfig.withTriggerConfigs(newTriggers);
        }
        return currentConfig;
    }

    private AutoScalingConfig handleRemoveListener(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException {
        String listenerName = op.getStr("name");
        if (op.hasError()) {
            return currentConfig;
        }
        Map listeners = currentConfig.getTriggerListenerConfigs();
        if (listeners == null || !listeners.containsKey(listenerName)) {
            op.addError("No listener exists with name: " + listenerName);
            return currentConfig;
        }
        currentConfig = currentConfig.withoutTriggerListenerConfig(listenerName);
        return currentConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private AutoScalingConfig handleSetListener(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException {
        listenerName = op.getStr("name");
        triggerName = op.getStr("trigger");
        stageNames = op.getStrs("stage", Collections.emptyList());
        listenerClass = op.getStr("class");
        beforeActions = op.getStrs("beforeAction", Collections.emptyList());
        afterActions = op.getStrs("afterAction", Collections.emptyList());
        if (op.hasError()) {
            return currentConfig;
        }
        triggers = currentConfig.getTriggerConfigs();
        if (triggers == null || !triggers.containsKey(triggerName)) {
            op.addError("A trigger with the name " + triggerName + " does not exist");
            return currentConfig;
        }
        triggerConfig = (AutoScalingConfig.TriggerConfig)triggers.get(triggerName);
        if (stageNames.isEmpty() && beforeActions.isEmpty() && afterActions.isEmpty()) {
            op.addError("Either 'stage' or 'beforeAction' or 'afterAction' must be specified");
            return currentConfig;
        }
        for (String stage : stageNames) {
            try {
                TriggerEventProcessorStage.valueOf((String)stage);
            }
            catch (IllegalArgumentException e) {
                op.addError("Invalid stage name: " + stage);
            }
        }
        if (op.hasError()) {
            return currentConfig;
        }
        listenerConfig = new AutoScalingConfig.TriggerListenerConfig(listenerName, op.getValuesExcluding(new String[]{"name"}));
        listener = null;
        try {
            listener = this.loader.newInstance(listenerClass, TriggerListener.class);
            listener.configure(this.loader, this.cloudManager, listenerConfig);
            ** if (listener == null) goto lbl-1000
        }
        catch (TriggerValidationException e) {
            block17: {
                AutoScalingHandler.log.warn("invalid listener configuration", (Throwable)e);
                op.addError("invalid listener configuration: " + e.toString());
                var16_19 = currentConfig;
                if (listener == null) break block17;
                IOUtils.closeQuietly((Closeable)listener);
            }
            return var16_19;
        }
        catch (Exception e) {
            block18: {
                AutoScalingHandler.log.warn("error loading listener class ", (Throwable)e);
                op.addError("Listener not found: " + listenerClass + ". error message:" + e.getMessage());
                var16_20 = currentConfig;
                if (listener == null) break block18;
                {
                    catch (Throwable var17_22) {
                        if (listener != null) {
                            IOUtils.closeQuietly(listener);
                        }
                        throw var17_22;
                    }
                }
                IOUtils.closeQuietly((Closeable)listener);
            }
            return var16_20;
        }
lbl-1000:
        // 1 sources

        {
            IOUtils.closeQuietly((Closeable)listener);
        }
lbl-1000:
        // 2 sources

        {
        }
        actionNames = new HashSet<E>();
        actionNames.addAll(beforeActions);
        actionNames.addAll(afterActions);
        for (AutoScalingConfig.ActionConfig action : triggerConfig.actions) {
            actionNames.remove(action.name);
        }
        if (!actionNames.isEmpty()) {
            op.addError("The trigger '" + triggerName + "' does not have actions named: " + actionNames);
            return currentConfig;
        }
        currentConfig = currentConfig.withTriggerListenerConfig(listenerConfig);
        return currentConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AutoScalingConfig handleSetTrigger(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException {
        AutoScalingConfig.TriggerConfig trigger;
        String triggerName;
        block15: {
            AutoScaling.Trigger trigger2;
            triggerName = op.getStr("name");
            String eventTypeStr = op.getStr("event");
            if (op.hasError()) {
                return currentConfig;
            }
            TriggerEventType eventType = TriggerEventType.valueOf((String)eventTypeStr.trim().toUpperCase(Locale.ROOT));
            String waitForStr = op.getStr("waitFor", null);
            CommandOperation opCopy = new CommandOperation(op.name, (Object)Utils.getDeepCopy((Map)((Map)op.getCommandData()), (int)10));
            if (waitForStr != null) {
                int seconds = 0;
                try {
                    seconds = this.parseHumanTime(waitForStr);
                }
                catch (IllegalArgumentException e) {
                    op.addError("Invalid 'waitFor' value '" + waitForStr + "' in trigger: " + triggerName);
                    return currentConfig;
                }
                opCopy.getDataMap().put("waitFor", seconds);
            }
            Integer lowerBound = op.getInt("lowerBound", null);
            Integer upperBound = op.getInt("upperBound", null);
            List<Map<String, String>> actions = (List<Map<String, String>>)op.getVal("actions");
            if (actions == null) {
                actions = this.DEFAULT_ACTIONS;
                opCopy.getDataMap().put("actions", actions);
            }
            for (Map map : actions) {
                if (!map.containsKey("name") || !map.containsKey("class")) {
                    op.addError("No 'name' or 'class' specified for action: " + map);
                    return currentConfig;
                }
                String klass = (String)map.get("class");
                try {
                    this.loader.findClass(klass, TriggerAction.class);
                }
                catch (Exception e) {
                    log.warn("Could not load class : ", (Throwable)e);
                    op.addError("Action not found: " + klass + " " + e.getMessage());
                    return currentConfig;
                }
            }
            trigger = new AutoScalingConfig.TriggerConfig(triggerName, opCopy.getValuesExcluding(new String[]{"name"}));
            Closeable closeable = null;
            try {
                trigger2 = this.triggerFactory.create(trigger.event, trigger.name, trigger.properties);
                if (trigger2 == null) break block15;
            }
            catch (Exception e) {
                op.addError("Error validating trigger config " + trigger.name + ": " + e.toString());
                AutoScalingConfig autoScalingConfig = currentConfig;
                return autoScalingConfig;
            }
            IOUtils.closeQuietly((Closeable)trigger2);
            break block15;
            finally {
                if (closeable != null) {
                    IOUtils.closeQuietly(closeable);
                }
            }
        }
        currentConfig = currentConfig.withTriggerConfig(trigger);
        return AutoScalingHandler.withSystemLogListener(currentConfig, triggerName);
    }

    static AutoScalingConfig withSystemLogListener(AutoScalingConfig autoScalingConfig, String triggerName) {
        Map configs = autoScalingConfig.getTriggerListenerConfigs();
        for (AutoScalingConfig.TriggerListenerConfig cfg : configs.values()) {
            if (!triggerName.equals(cfg.trigger)) continue;
            return autoScalingConfig;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("class", SystemLogListener.class.getName());
        properties.put("trigger", triggerName);
        properties.put("stage", EnumSet.allOf(TriggerEventProcessorStage.class));
        AutoScalingConfig.TriggerListenerConfig listener = new AutoScalingConfig.TriggerListenerConfig(triggerName + ".system", properties);
        autoScalingConfig = autoScalingConfig.withTriggerListenerConfig(listener);
        return autoScalingConfig;
    }

    private int parseHumanTime(String timeStr) {
        int seconds;
        char c = timeStr.charAt(timeStr.length() - 1);
        long timeValue = Long.parseLong(timeStr.substring(0, timeStr.length() - 1));
        switch (c) {
            case 'h': {
                seconds = (int)TimeUnit.HOURS.toSeconds(timeValue);
                break;
            }
            case 'm': {
                seconds = (int)TimeUnit.MINUTES.toSeconds(timeValue);
                break;
            }
            case 's': {
                seconds = (int)timeValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid time value");
            }
        }
        return seconds;
    }

    private AutoScalingConfig handleRemoveTrigger(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op, AutoScalingConfig currentConfig) throws KeeperException, InterruptedException {
        String triggerName = op.getStr("name");
        boolean removeListeners = op.getBoolean("removeListeners", false);
        if (op.hasError()) {
            return currentConfig;
        }
        HashMap triggerConfigs = currentConfig.getTriggerConfigs();
        if (!triggerConfigs.containsKey(triggerName)) {
            op.addError("No trigger exists with name: " + triggerName);
            return currentConfig;
        }
        triggerConfigs = new HashMap(triggerConfigs);
        HashSet<String> activeListeners = new HashSet<String>();
        HashMap listeners = currentConfig.getTriggerListenerConfigs();
        for (AutoScalingConfig.TriggerListenerConfig listener : listeners.values()) {
            if (!triggerName.equals(listener.trigger)) continue;
            activeListeners.add(listener.name);
        }
        if (!activeListeners.isEmpty()) {
            boolean onlySystemLog = false;
            if (activeListeners.size() == 1) {
                AutoScalingConfig.TriggerListenerConfig cfg = (AutoScalingConfig.TriggerListenerConfig)listeners.get(activeListeners.iterator().next());
                if (SystemLogListener.class.getName().equals(cfg.listenerClass) || ("solr." + SystemLogListener.class.getSimpleName()).equals(cfg.listenerClass)) {
                    onlySystemLog = true;
                }
            }
            if (removeListeners || onlySystemLog) {
                listeners = new HashMap(listeners);
                listeners.keySet().removeAll(activeListeners);
            } else {
                op.addError("Cannot remove trigger: " + triggerName + " because it has active listeners: " + activeListeners);
                return currentConfig;
            }
        }
        triggerConfigs.remove(triggerName);
        currentConfig = currentConfig.withTriggerConfigs(triggerConfigs).withTriggerListenerConfigs((Map)listeners);
        return currentConfig;
    }

    private boolean setAutoScalingConfig(AutoScalingConfig currentConfig) throws KeeperException, InterruptedException, IOException {
        this.verifyAutoScalingConf(currentConfig);
        try {
            this.cloudManager.getDistribStateManager().setData("/autoscaling.json", Utils.toJSON((Object)currentConfig), currentConfig.getZkVersion());
        }
        catch (BadVersionException bve) {
            return false;
        }
        return true;
    }

    private void verifyAutoScalingConf(AutoScalingConfig autoScalingConf) throws IOException {
        Policy.Session session = autoScalingConf.getPolicy().createSession(this.cloudManager);
        log.debug("Verified autoscaling configuration");
    }

    @Override
    public String getDescription() {
        return "A handler for autoscaling configuration";
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        switch (request.getHttpMethod()) {
            case "GET": {
                return PermissionNameProvider.Name.AUTOSCALING_READ_PERM;
            }
            case "POST": {
                return PermissionNameProvider.Name.AUTOSCALING_WRITE_PERM;
            }
        }
        return null;
    }

    @Override
    public Collection<Api> getApis() {
        return ApiBag.wrapRequestHandlers(this, "autoscaling.Commands");
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public SolrRequestHandler getSubHandler(String path) {
        if (path.equals("/diagnostics") || path.equals("/suggestions")) {
            return this;
        }
        return null;
    }
}

