/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.DistributedQueue;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerEventQueue {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ENQUEUE_TIME = "_enqueue_time_";
    public static final String DEQUEUE_TIME = "_dequeue_time_";
    private final String triggerName;
    private final TimeSource timeSource;
    private final DistributedQueue delegate;

    public TriggerEventQueue(SolrCloudManager cloudManager, String triggerName, Stats stats) throws IOException {
        this.delegate = cloudManager.getDistributedQueueFactory().makeQueue("/autoscaling/events/" + triggerName);
        this.triggerName = triggerName;
        this.timeSource = cloudManager.getTimeSource();
    }

    public boolean offerEvent(TriggerEvent event) {
        event.getProperties().put(ENQUEUE_TIME, this.timeSource.getTimeNs());
        try {
            byte[] data = Utils.toJSON((Object)event);
            this.delegate.offer(data);
            return true;
        }
        catch (Exception e) {
            log.warn("Exception adding event " + event + " to queue " + this.triggerName, (Throwable)e);
            return false;
        }
    }

    public TriggerEvent peekEvent() {
        try {
            byte[] data;
            while ((data = this.delegate.peek()) != null) {
                if (data.length == 0) {
                    log.warn("ignoring empty data...");
                    continue;
                }
                try {
                    Map map = (Map)Utils.fromJSON((byte[])data);
                    return this.fromMap(map);
                }
                catch (Exception e) {
                    log.warn("Invalid event data, ignoring: " + new String(data, StandardCharsets.UTF_8));
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception peeking queue of trigger " + this.triggerName, (Throwable)e);
        }
        return null;
    }

    public TriggerEvent pollEvent() {
        try {
            byte[] data;
            while ((data = this.delegate.poll()) != null) {
                if (data.length == 0) {
                    log.warn("ignoring empty data...");
                    continue;
                }
                try {
                    Map map = (Map)Utils.fromJSON((byte[])data);
                    return this.fromMap(map);
                }
                catch (Exception e) {
                    log.warn("Invalid event data, ignoring: " + new String(data, StandardCharsets.UTF_8));
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception polling queue of trigger " + this.triggerName, (Throwable)e);
        }
        return null;
    }

    private TriggerEvent fromMap(Map<String, Object> map) {
        TriggerEvent res = TriggerEvent.fromMap(map);
        res.getProperties().put(DEQUEUE_TIME, this.timeSource.getTimeNs());
        return res;
    }
}

