/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;

class DoubleFieldWriter
extends FieldWriter {
    private String field;

    public DoubleFieldWriter(String field) {
        this.field = field;
    }

    @Override
    public boolean write(SortDoc sortDoc, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        SortValue sortValue = sortDoc.getSortValue(this.field);
        if (sortValue != null) {
            if (sortValue.isPresent()) {
                double val = (Double)sortValue.getCurrentValue();
                ew.put(this.field, val);
                return true;
            }
            return false;
        }
        NumericDocValues vals = DocValues.getNumeric((LeafReader)reader, (String)this.field);
        if (vals.advance(sortDoc.docId) == sortDoc.docId) {
            long val = vals.longValue();
            ew.put(this.field, Double.longBitsToDouble(val));
            return true;
        }
        return false;
    }
}

