/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestRuleRestoreSystemProperties
extends TestRuleAdapter {
    private final String[] propertyNames;
    private final Map<String, String> restore = new HashMap<String, String>();

    public TestRuleRestoreSystemProperties(String ... propertyNames) {
        this.propertyNames = propertyNames;
        if (propertyNames.length == 0) {
            throw new IllegalArgumentException("No properties to restore? Odd.");
        }
    }

    protected void before() throws Throwable {
        super.before();
        assert (this.restore.isEmpty());
        for (String key : this.propertyNames) {
            this.restore.put(key, System.getProperty(key));
        }
    }

    protected void afterAlways(List<Throwable> errors) throws Throwable {
        for (String key : this.propertyNames) {
            try {
                String value = this.restore.get(key);
                if (value == null) {
                    System.clearProperty(key);
                    continue;
                }
                System.setProperty(key, value);
            }
            catch (SecurityException e) {
                errors.add(e);
            }
        }
        this.restore.clear();
        super.afterAlways(errors);
    }
}

